package com.bringspring.system.permission.model.organize;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.bringspring.common.util.StringUtils;
import lombok.Data;

import java.util.List;

/**
 * 组织信息导入模型
 */
@Data
public class OrganizeImportModel {

    @Excel(name = "上级组织")
    private String parentId;

    @Excel(name = "*直属组织")
    private String organizeId;

    @Excel(name = "*组织类型")
    private String category;

    @Excel(name = "*组织名称")
    private String fullName;

    @Excel(name = "*组织编码")
    private String enCode;

    @Excel(name = "排序")
    private Long sortCode;

    @Excel(name = "说明")
    private String description;

    private List<OrganizeImportModel> list;

    private String errorMessage;

    // 解析后的字段
    private String parentName;    // 上级组织名称
    private String parentEnCode;  // 上级组织编码
    private String directOrganizeName;    // 直属组织名称
    private String directOrganizeEnCode;  // 直属组织编码

    /**
     * 解析上级组织和直属组织信息
     */
    public void parseParentInfo() {
        // 解析上级组织
        if (StringUtils.isNotEmpty(this.parentId)) {
            String[] parts = this.parentId.split("/");
            if (parts.length == 2) {
                this.parentName = parts[0].trim();
                this.parentEnCode = parts[1].trim();
            } else if (parts.length == 1) {
                this.parentName = parts[0].trim();
            }
        }

        // 【修改】解析直属组织（使用 organizeId 字段）
        if (StringUtils.isNotEmpty(this.organizeId)) {
            String[] parts = this.organizeId.split("/");
            if (parts.length == 2) {
                this.directOrganizeName = parts[0].trim();
                this.directOrganizeEnCode = parts[1].trim();
            } else if (parts.length == 1) {
                this.directOrganizeName = parts[0].trim();
            }
        }
    }
}
