package com.bringspring.system.permission.util;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.entity.DictionaryTypeEntity;
import com.bringspring.system.base.entity.ProvinceEntity;
import com.bringspring.system.base.model.dataInterface.DataInterfaceActionVo;
import com.bringspring.system.base.service.*;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.PositionEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.model.user.vo.UserBaseVO;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.PositionService;
import com.bringspring.system.permission.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 数据转换
 * 其中包含人员，组织，数据字典，区域，接口服务，单据规则模板等调用工具类
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/16
 */
@Component
public class BaseDataUtil {

	@Autowired
	private OrganizeService organizeService;

	@Autowired
	private PositionService positionService ;

	@Autowired
	private UserService userService ;


	@Autowired
	private DataInterfaceService dataInterfaceService ;


	@Autowired
	private ProvinceService provinceService;

	@Autowired
	private DictionaryDataService dictionaryDataService;
	@Autowired
	private DictionaryTypeService dictionaryTypeService;

	@Autowired
	private BillRuleService billRuleService;


	public final String regEx = "[\\[\\]\"]";

	/**
	 * 行政区划转换
	 *
	 * @param data
	 * @return
	 */
	public String provinceData(String data) {
		if (StringUtils.isNotEmpty(data)) {
			try {
				if (data.contains("[[")){
					List<String> addList = new ArrayList<>();
					String[][] provinceDataS = JsonUtil.getJsonToBean(data, String[][].class);
					for (String[] AddressData :provinceDataS){
						List<String> provList = new ArrayList(Arrays.asList(AddressData));
						List<ProvinceEntity> proList = provinceService.getProList(provList);
						//单条
						List<String> adList = proList.stream().map(pro->pro.getFullName()).collect(Collectors.toList());
						addList.add(String.join("/", adList));
					}
					return String.join(";",addList);
				}else if (data.contains("[")) {
					List<String> idList = JsonUtil.getJsonToList(data, String.class);
					List<String> nameList = new ArrayList<>();
					for (String orgId : idList) {
						ProvinceEntity info = provinceService.getInfo(orgId);
						nameList.add(Objects.nonNull(info) ? info.getFullName() : orgId);
					}
					return String.join("/",nameList);
				}/*else if(data.getBytes().length != data.length()){
					String areaIds = provinceService.getAreaIds(data);
					return data;
				}*/
				else {
					String[] strs = data.split(",");
					List<String> provList = new ArrayList(Arrays.asList(strs));
					List<String> proNameList = new ArrayList<>();
					List<ProvinceEntity> proList = provinceService.getProList(provList);
					for (ProvinceEntity entity : proList){
						proNameList.add(entity.getFullName());
					}
					return String.join("/",proNameList);
				}
			}catch (Exception e){
				e.printStackTrace();
			}
		}
		return "";
	}

	/**
	 * 所属组织id转名称
	 *
	 * @param value
	 * @return
	 */
	public String comSelectValue(String value,String showLevel) {
		if (StringUtils.isNotEmpty(String.valueOf(value))) {
			OrganizeEntity organizeEntity = organizeService.getInfo(String.valueOf(value));
			if ("all".equals(showLevel)) {
				value= PermissionUtil.getLinkInfoByOrgId(value, organizeService, false);
			} else {
				if (organizeEntity != null) {
					value = organizeEntity.getFullName();
				}
			}
		}
		return value;
	}

	/**
	 * 公司部门id转名称(多选)
	 *
	 * @param ids
	 * @return
	 */
	public String comSelectValues(String ids) {
		List<String> comValueList= new ArrayList<>();
		if (StringUtils.isEmpty(ids)){
			return null;
		}
		if (ids.contains("[[")){
			String[][] idArrays = JsonUtil.getJsonToBean(ids, String[][].class);
			for (String[] array : idArrays){
				List<String> idList = new ArrayList<>();
				for (String s : array){
					OrganizeEntity info = organizeService.getInfo(s);
					idList.add(Objects.nonNull(info) ? info.getFullName() : s );
				}
				String orgCom = idList.stream().collect(Collectors.joining("/"));
				comValueList.add(orgCom);
			}
			return comValueList.stream().collect(Collectors.joining(";"));
		}else if (ids.contains("[")){
			List<String> idList=JsonUtil.getJsonToList(ids,String.class);
			List<String> nameList= new ArrayList<>();
			for (String orgId : idList){
				OrganizeEntity info = organizeService.getInfo(orgId);
				nameList.add(Objects.nonNull(info) ? info.getFullName() : orgId);
			}
			return nameList.stream().collect(Collectors.joining("/"));
		}else {
			ids = ids.replaceAll("\"","");
			String[] idList = ids.split(",");
			if (idList.length > 0) {
				List<String> comSelectList = new ArrayList<>();
				for (String id : idList) {
					OrganizeEntity organizeEntity = organizeService.getInfo(id);
					if (organizeEntity != null) {
						comSelectList.add(organizeEntity.getFullName());
					}
				}
				return String.join("/", comSelectList);
			}
		}
		return null;
	}


	/**
	 * 岗位id转名称
	 *
	 * @param id
	 * @return
	 */
	public String posSelectValue(String id) {
		if (StringUtils.isNotEmpty(id)) {
			PositionEntity positionServiceInfo = positionService.getInfo(id);
			if (ObjectUtil.isNotEmpty(positionServiceInfo)) {
				return positionServiceInfo.getFullName();
			}
			return id;
		}
		return "";
	}

	/**
	 * 岗位id转名称(多选)
	 *
	 * @param ids
	 * @return
	 */
	public String posSelectValues(String ids) {
		if (StringUtils.isEmpty(ids)){
			return "";
		}
		List<String> posList = new ArrayList<>();
		if (ids.contains("[")){
			List<String> idList=JsonUtil.getJsonToList(ids,String.class);
			List<String> nameList= new ArrayList<>();
			for (String orgId : idList){
				PositionEntity info = positionService.getInfo(orgId);
				nameList.add(Objects.nonNull(info) ? info.getFullName() : orgId);
			}
			posList = nameList;
		}else {
			String[] idList = ids.split(",");
			if (idList.length > 0) {
				for (String id : idList) {
					PositionEntity positionEntity = positionService.getInfo(id);
					if (ObjectUtil.isNotEmpty(positionEntity)) {
						posList.add(positionEntity.getFullName());
					}
				}
			}
		}
		return String.join("/", posList);
	}

	/**
	 * 用户id转名称/账户
	 *
	 * @param id
	 * @return
	 */
	public String userSelectValue(String id) {
		if (StringUtils.isNotEmpty(id)) {
			UserEntity userEntity = userService.getInfo(id);
			if (ObjectUtil.isNotEmpty(userEntity)) {
				return userEntity.getRealName() ;
			}
			return id;
		}
		return "";
	}
	/**
	 * 用户id转名称；不包含没有账户
	 * @param id
	 * @return
	 */
	public String userSelectValueNoAccount(String id) {
		if (StringUtils.isNotEmpty(id)) {
			UserEntity userEntity = userService.getInfo(id);
			if (ObjectUtil.isNotEmpty(userEntity)) {
				return userEntity.getRealName() ;
			}
			return id;
		}
		return "";
	}
	/**
	 * 用户id转用户基础信息；
	 * @param id
	 * @return
	 */
	public UserBaseVO userSelectBaseInfo(String id) {
		if (StringUtils.isNotEmpty(id)) {
			UserEntity userEntity = userService.getInfo(id);
			if (ObjectUtil.isNotEmpty(userEntity)) {
				return JsonUtil.getJsonToBean(userEntity,UserBaseVO.class);
			}
			return new UserBaseVO();
		}
		return  new UserBaseVO();
	}
	/**
	 * 用户id转名称(多选)
	 *
	 * @param ids
	 * @return
	 */
	public String userSelectValues(String ids) {
		if (StringUtils.isEmpty(ids)) {
			return ids;
		}
		if (ids.contains("[")){
			List<String> nameList = new ArrayList<>();
			List<String> jsonToList = JsonUtil.getJsonToList(ids, String.class);
			for (String userId : jsonToList){
				UserEntity info = userService.getInfo(userId);
				nameList.add(Objects.nonNull(info) ? info.getRealName() : userId);
			}
			return String.join(";", nameList);
		}else {
			List<String> userInfoList = new ArrayList<>();
			String[] idList = ids.split(",");
			if (idList.length > 0) {
				for (String id : idList) {
					UserEntity userEntity = userService.getInfo(id);
					if (ObjectUtil.isNotEmpty(userEntity)) {
						String info = userEntity.getRealName();
						userInfoList.add(info);
					}
				}
			}
			return String.join("-", userInfoList);
		}
	}

	/**
	 * 开关
	 *
	 * @param data
	 * @return
	 */
	public String switchSelectValue(String data,String activeTxt,String inactiveTxt) {
		if (StringUtils.isNotEmpty(data)) {
			if (data.equals("0") || data.equals("false")) {
				return inactiveTxt;
			} else if (data.equals("1") || data.equals("true")) {
				return activeTxt;
			} else {
				return data;
			}
		}
		return null;
	}

	/**
	 * 弹窗
	 *
	 * @param interfaceId
	 * @param propsValue
	 * @param relationField
	 * @param dataValue
	 * @return
	 */
	public String getPopupSelectValue(String interfaceId, String propsValue, String relationField, String dataValue,Map<String, Object> dataMaps) {
		if (StringUtils.isNotEmpty(dataValue)) {
			Object data = dataInterfaceService.infoToId(interfaceId).getData();
			List<Map<String, Object>> dataInterfaceDataList;
			if (data instanceof DataInterfaceActionVo){
				DataInterfaceActionVo actionVo = (DataInterfaceActionVo) data;
				dataInterfaceDataList = (List<Map<String, Object>>) actionVo.getData();
			}else {
				dataInterfaceDataList = (List<Map<String, Object>>) data;
			}
			Map<String, Object>	dataMap = dataInterfaceDataList.stream().filter(d -> d.get(propsValue).equals(dataValue)).findFirst().orElse(null);
			if (dataMap!=null){
				dataMaps.putAll(dataMap);
				return String.valueOf(dataMap.get(relationField));
			}
			return null;
		} else {
			return null;
		}
	}


	public String getFileNameInJson(String fileJson){
		if (StringUtils.isNotEmpty(fileJson) && !"null".equals(fileJson) ){
			return fileJson;
		}
		return "";
	}
	/**
	 * 获取数据字典数据
	 *
	 * @param dictDataIds 字典数据id集合
	 *  如果需要返回多个，id
	 * @return 返回字典名称集合，多选多个时名称用逗号隔开
	 */
	public String getDictName(String dictDataIds){
		return this.getDictName(dictDataIds, null);
	}
	/**
	 * 获取数据字典数据
	 *
	 * @param dictDataIds 字典数据id集合或者code集合
	 * @param dictTypeCode 字典类型code
	 *  如果需要返回多个，id/code集合用逗号隔开,如果是code,必须传字典类型编码dictTypeCode
	 * @return 返回字典名称集合，多选多个时名称用逗号隔开
	 */
	public String getDictName(String dictDataIds,String dictTypeCode) {
		if (StringUtils.isNotEmpty(dictDataIds)&&StringUtils.isNotEmpty(dictTypeCode)) {
			//去除中括号以及双引号
			dictDataIds = dictDataIds.replaceAll(regEx, "");
			//判断多选框
			String[] feilds = dictDataIds.split(",");
			List<String> dictIds = Arrays.asList(feilds);
			DictionaryTypeEntity infoByEnCode = dictionaryTypeService.getInfoByEnCode(dictTypeCode);
			String dictTypeId = null;
			if (ObjectUtil.isNotEmpty(infoByEnCode)) {
				dictTypeId = infoByEnCode.getId();
			}
			List<DictionaryDataEntity> dictNameList = dictionaryDataService.getDictionName(dictIds,dictTypeId);
			String dictNames=String.join(",",dictNameList.stream().map(dict -> {
				return dict.getFullName();
			}).collect(Collectors.toList()));
			return dictNames;
		}
		return dictDataIds;
	}


	/**
	 * 获取远端数据
	 *
	 * @param urlId
	 * @param label
	 * @param value
	 * @param feildValue
	 * @return
	 * @throws IOException
	 */
	public String getDynName(String urlId, String label, String value, String feildValue) {
		if (StringUtils.isNotEmpty(feildValue)) {
			//去除中括号以及双引号
			feildValue = feildValue.replaceAll(regEx, "");
			//获取远端数据
			ActionResult object = dataInterfaceService.infoToId(urlId);
			if (object.getData() != null && object.getData() instanceof DataInterfaceActionVo) {
				DataInterfaceActionVo vo= (DataInterfaceActionVo) object.getData();
				List<Map<String, Object>> dataList = (List<Map<String, Object>>) vo.getData();
				//判断是否多选
				String[] feildValues = feildValue.split(",");
				if (feildValues.length > 0) {
					//转换的真实值
					StringBuilder feildVa = new StringBuilder();
					for (String feild : feildValues) {
						for (Map<String, Object> data : dataList) {
							if (String.valueOf(data.get(value)).equals(feild)) {
								feildVa.append(data.get(label) + ",");
							}
						}
					}
					String finalValue;
					if (StringUtils.isEmpty(feildVa) || feildVa.equals("")) {
						finalValue = feildVa.toString();
					} else {
						finalValue = feildVa.substring(0, feildVa.length() - 1);
					}
					return finalValue;
				}
				for (Map<String, Object> data : dataList) {
					if (feildValue.equals(String.valueOf(data.get(value)))) {
						return data.get(label).toString();
					}
					return feildValue;
				}
			}
			return feildValue;
		}
		return feildValue;
	}

	/**
	 * 获取远端数据
	 *
	 * @param urlId
	 * @param name
	 * @param id
	 * @param children
	 * @param feildValue
	 * @return
	 */
	public String getDynName(String urlId, String name, String id, String children, String feildValue) {
		List<String> result = new ArrayList<>();
		if (StringUtils.isNotEmpty(feildValue)) {
			ActionResult object = dataInterfaceService.infoToId(urlId);
			DataInterfaceActionVo actionVo = (DataInterfaceActionVo) object.getData();
			List<Map<String, Object>> dataList = new ArrayList<>();
			if (actionVo.getData() instanceof List) {
				dataList = (List<Map<String, Object>>) actionVo.getData();
			}
			JSONArray dataAll = JsonUtil.getListToJsonArray(dataList);
			List<Map<String, String>> list = new ArrayList<>();
			treeToList(id, name, children, dataAll, list);
			String value = feildValue.replaceAll("\\[", "").replaceAll("\\]", "");
			result = list.stream().filter(t -> value.contains(String.valueOf(t.get(id)))).map(t -> String.valueOf(t.get(name))).collect(Collectors.toList());
		}
		return String.join(",", result);
	}


	/**
	 * 树转成list
	 **/
	private void treeToList(String id, String fullName, String children, JSONArray data, List<Map<String, String>> result) {
		for (int i = 0; i < data.size(); i++) {
			JSONObject ob = data.getJSONObject(i);
			Map<String, String> tree = new HashMap<>(16);
			tree.put(id, String.valueOf(ob.get(id)));
			tree.put(fullName, String.valueOf(ob.get(fullName)));
			result.add(tree);
			if (ob.get(children) != null) {
				JSONArray childArray = ob.getJSONArray(children);
				treeToList(id, fullName, children, childArray, result);
			}
		}
	}

	/**
	 * 生成单据规则
	 * @param encode
	 * @param isCache
	 * @return
	 * @throws DataException
	 */
	public String getBillNumber(String encode, Boolean isCache) throws DataException {
		return billRuleService.getBillNumber(encode, isCache);
	}
}
