package com.bringspring.system.scheduletask.utils;

import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.context.SpringContext;
import com.bringspring.system.base.util.jobutil.JobManager;
import com.bringspring.system.base.util.jobutil.TimeJob;
import com.bringspring.system.scheduletask.entity.TimeTaskEntity;
import com.bringspring.system.scheduletask.model.ContentModel;
import com.bringspring.system.scheduletask.service.TimetaskService;
import lombok.extern.slf4j.Slf4j;
import org.quartz.CronExpression;
import org.quartz.JobDataMap;

import java.util.List;

import static com.bringspring.system.base.util.jobutil.JobManager.CRON_DELIMITER;

@Slf4j
public class TaskUtil {

    public static void task() {
        //多租户下不启动任务调度
        ConfigValueUtil configValueUtil = SpringContext.getBean(ConfigValueUtil.class);
        if (!Boolean.parseBoolean(configValueUtil.getMultiTenancy())) {
            TimetaskService timetaskService = SpringContext.getBean(TimetaskService.class);
//            DataSourceUtil dataSourceUtil = SpringContext.getBean(DataSourceUtil.class);
//            DblinkService dblinkService = SpringContext.getBean(DblinkService.class);
            List<TimeTaskEntity> list = timetaskService.getList();
            for (TimeTaskEntity entity : list) {
                if (isjson(entity.getExecuteContent())) {
                    ContentModel model = JsonUtil.getJsonToBean(entity.getExecuteContent(), ContentModel.class);
                    JobDataMap jobDataMap = new JobDataMap();
                    jobDataMap.put("content", model);
                    jobDataMap.put("tenantId", "");
                    jobDataMap.put("tenantDbConnectionString", "");
                    jobDataMap.put("id", entity.getId());
                    jobDataMap.put("type", entity.getExecuteType());
                    jobDataMap.put("timeTaskEntity", entity);
                    String jobName = entity.getId();
                    String jobGroupName = entity.getGroupName();
                    String cron = entity.getExecuteCronExpression();
                    if (filterWithCronTime(cron)) {
                        JobManager jobManager = new JobManager();
                        jobManager.addJob(jobName, jobGroupName, cron, jobDataMap, null, null, TimeJob.class);
                    }
                }
            }
        }
    }

    /**
     * 验证Cron表达式有效性 - 支持单个和多个触发器
     * @param cron 单个表达式："0 0 9 * * ?" 或多个表达式："0 0 9 * * ?;0 0 18 * * ?"
     * @return 所有表达式都有效返回true，否则返回false
     */
    private static Boolean filterWithCronTime(String cron) {
        if (StringUtils.isEmpty(cron)) {
            return false;
        }

        // 分割多个Cron表达式
        String[] cronExpressions = cron.split(JobManager.CRON_DELIMITER);

        // 如果只有一个表达式，直接验证
        if (cronExpressions.length == 1) {
            return CronExpression.isValidExpression(cron.trim());
        }

        // 验证多个表达式
        for (String singleCron : cronExpressions) {
            String trimmedCron = singleCron.trim();
            if (!trimmedCron.isEmpty() && !CronExpression.isValidExpression(trimmedCron)) {
                log.warn("无效的Cron表达式: {}", trimmedCron);
                return false;
            }
        }

        return true;
    }

    private static boolean isjson(String string) {
        try {
            JSONObject jsonStr = JSONObject.parseObject(string);
            return true;
        } catch (Exception e) {
            return false;
        }
    }
}
