/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.Pagination;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.database.model.DataSourceModel;
import com.bringspring.common.util.FileUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.system.base.entity.DbBackupEntity;
import com.bringspring.system.base.mapper.DbBackupMapper;
import com.bringspring.system.base.service.DbBackupService;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DbBackupServiceImpl
extends ServiceImpl<DbBackupMapper, DbBackupEntity>
implements DbBackupService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private DataSourceModel dataSourceUtils;
    @Autowired
    private ConfigValueUtil configValueUtil;

    @Override
    public List<DbBackupEntity> getList(Pagination pagination) {
        boolean flag = false;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().orderByAsc(DbBackupEntity::getSortCode);
        if (pagination.getKeyword() != null) {
            flag = true;
            queryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(DbBackupEntity::getFileName, (Object)pagination.getKeyword())).or()).like(DbBackupEntity::getBackupDbName, (Object)pagination.getKeyword());
            });
        }
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(DbBackupEntity::getSortCode)).orderByDesc(DbBackupEntity::getCreatorTime);
        if (flag) {
            queryWrapper.lambda().orderByDesc(DbBackupEntity::getLastModifyTime);
        }
        Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
        IPage iPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return pagination.setData(iPage.getRecords(), page.getTotal());
    }

    @Override
    public DbBackupEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(DbBackupEntity::getId, (Object)id);
        return (DbBackupEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void delete(DbBackupEntity entity) {
        if (entity != null) {
            FileUtil.deleteFile((String)(this.configValueUtil.getDataBackupFilePath() + entity.getFileName()));
            this.removeById((Serializable)((Object)entity.getId()));
            UploadUtil.removeFile((String)this.configValueUtil.getFileType(), (String)"dataBackup", (String)entity.getFileName());
        }
    }

    @Override
    public void create(DbBackupEntity entity) {
        entity.setId(RandomUtil.uuId());
        entity.setSortCode(RandomUtil.parses());
        entity.setCreatorUserId(this.userProvider.get().getUserId());
        this.save(entity);
    }
}

