/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.external.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Validator;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.external.bean.WeComModel;
import com.bringspring.system.external.config.mutil.WxCpConfiguration;
import com.bringspring.system.external.service.SynPushToThirdQyService;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.message.service.SynThirdInfoService;
import com.bringspring.system.message.util.SynThirdConsts;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.PositionEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.PositionService;
import com.bringspring.system.permission.service.UserRelationService;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.Gender;
import me.chanjar.weixin.cp.bean.WxCpDepart;
import me.chanjar.weixin.cp.bean.WxCpUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class SynPushToThirdQyServiceImpl
implements SynPushToThirdQyService {
    @Autowired
    private SynThirdInfoService synThirdInfoService;
    @Autowired
    WxCpConfiguration wxCpConfiguration;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private PositionService positionService;
    @Autowired
    private UserRelationService userRelationService;

    @Override
    public JSONObject createDepartmentSysToQy(UserInfo currentUser, boolean isBatch, OrganizeEntity deptEntity, String corpId) {
        String description;
        Integer synState;
        String thirdObjId;
        JSONObject retMsg;
        block15: {
            retMsg = new JSONObject();
            String deptFlag = "\u521b\u5efa\uff1a";
            boolean isDeptDiff = true;
            thirdObjId = "";
            synState = SynThirdConsts.SYN_STATE_NO;
            description = "";
            if (StringUtils.isEmpty((String)corpId) && (retMsg = this.getOrganizeCorpid(deptEntity.getOrganizeIdTree(), deptFlag)).getBoolean("code").booleanValue()) {
                corpId = retMsg.getString("cropId");
            }
            if (StringUtils.isNotEmpty((String)corpId)) {
                WeComModel weComModel = this.wxCpConfiguration.getWeComModel(corpId);
                if (weComModel == null) {
                    synState = SynThirdConsts.SYN_STATE_NO;
                    description = String.format("[%s]\u672a\u627e\u5230\u5bf9\u5e94corpId=[%s]\u7684\u914d\u7f6e", deptFlag, corpId);
                    retMsg.put("code", (Object)false);
                    retMsg.put("msg", (Object)description);
                } else {
                    int qyhIsSyn = isBatch ? 1 : weComModel.getQyhIsSynOrg();
                    boolean isLinkedCorp = weComModel.getIsLinkedCorp();
                    if (qyhIsSyn == 1 && !isLinkedCorp) {
                        String agentId = weComModel.getQyhAgentId();
                        WxCpService wxCorpService = this.wxCpConfiguration.getCorpService(corpId);
                        WxCpService wxCpService = this.wxCpConfiguration.getCpService(corpId, Integer.valueOf(agentId));
                        if (wxCorpService == null || wxCpService == null) {
                            synState = SynThirdConsts.SYN_STATE_NO;
                            description = String.format("[%s]\u672a\u627e\u5230\u5bf9\u5e94corpId=[%s]\u3001agentId=[%d]\u7684\u914d\u7f6e", deptFlag, corpId, agentId);
                            retMsg.put("code", (Object)false);
                            retMsg.put("msg", (Object)description);
                        } else {
                            try {
                                SynThirdInfoEntity parentSynThirdInfo;
                                List departList = wxCpService.getDepartmentService().list(null);
                                if (departList == null || departList.size() == 0) {
                                    synState = SynThirdConsts.SYN_STATE_FAIL;
                                    description = String.format("[%s]\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1\u90e8\u95e8\u5217\u8868\u63a5\u53e3\u6570\u636e\u4e3a\u7a7a", deptFlag);
                                    retMsg.put("code", (Object)false);
                                    retMsg.put("msg", (Object)description);
                                    break block15;
                                }
                                WxCpDepart depart = new WxCpDepart();
                                depart.setName(deptEntity.getFullName());
                                depart.setEnName(deptEntity.getEnCode());
                                if (!("company".equals(deptEntity.getCategory()) && "-1".equals(deptEntity.getParentId()) || !(isDeptDiff = (retMsg = this.checkDepartmentSysToQy(parentSynThirdInfo = this.synThirdInfoService.getInfoBySysObjId("1", "1", deptEntity.getParentId()), departList)).getBoolean("code").booleanValue()))) {
                                    depart.setParentId(Long.valueOf(parentSynThirdInfo.getThirdObjectId()));
                                }
                                depart.setOrder(Long.valueOf(111100000L - deptEntity.getSortCode()));
                                if (isDeptDiff) {
                                    retMsg = this.checkCnEnName(depart.getName(), depart.getEnName(), "add", null, currentUser, corpId, "1", "1", deptEntity.getId(), thirdObjId, deptFlag);
                                    if (!retMsg.getBoolean("code").booleanValue()) {
                                        return retMsg;
                                    }
                                    Long departId = wxCorpService.getDepartmentService().create(depart);
                                    thirdObjId = String.valueOf(departId);
                                    synState = SynThirdConsts.SYN_STATE_OK;
                                    description = deptFlag + "\u540c\u6b65\u6210\u529f";
                                    retMsg.put("code", (Object)true);
                                    retMsg.put("error", (Object)description);
                                    break block15;
                                }
                                synState = SynThirdConsts.SYN_STATE_FAIL;
                                description = deptFlag + "\u4e0a\u7ea7\u90e8\u95e8\u65e0\u5bf9\u5e94\u7684\u4f01\u4e1a\u5fae\u4fe1ID";
                                retMsg.put("code", (Object)false);
                                retMsg.put("error", (Object)description);
                            }
                            catch (WxErrorException e) {
                                synState = SynThirdConsts.SYN_STATE_FAIL;
                                description = deptFlag + e.getError().getErrorMsg();
                                retMsg.put("code", (Object)false);
                                retMsg.put("error", (Object)description);
                            }
                        }
                    } else {
                        synState = SynThirdConsts.SYN_STATE_NO;
                        description = deptFlag + "\u7cfb\u7edf\u672a\u8bbe\u7f6e\u5355\u6761\u540c\u6b65";
                        retMsg.put("code", (Object)true);
                        retMsg.put("error", (Object)description);
                        retMsg.put("retDeptId", (Object)"0");
                    }
                }
            } else {
                description = retMsg.getString("error");
            }
        }
        this.saveSynThirdInfoEntity("add", null, currentUser, corpId, "1", "1", deptEntity.getId(), thirdObjId, synState, description);
        return retMsg;
    }

    @Override
    public JSONObject updateDepartmentSysToQy(UserInfo currentUser, boolean isBatch, OrganizeEntity deptEntity, String corpId) {
        String thirdObjId;
        SynThirdInfoEntity synThirdInfoEntity;
        String description;
        Integer synState;
        String opType;
        JSONObject retMsg;
        block22: {
            retMsg = new JSONObject();
            String deptFlag = "\u66f4\u65b0\uff1a";
            boolean isDeptDiff = true;
            opType = "upd";
            synState = SynThirdConsts.SYN_STATE_NO;
            description = "";
            synThirdInfoEntity = this.synThirdInfoService.getInfoBySysObjId("1", "1", deptEntity.getId());
            thirdObjId = ObjectUtil.isNotEmpty((Object)synThirdInfoEntity) ? synThirdInfoEntity.getThirdObjectId() : "";
            SynThirdInfoEntity synThirdInfoPara = new SynThirdInfoEntity();
            if (StringUtils.isEmpty((String)corpId) && (retMsg = this.getOrganizeCorpid(deptEntity.getOrganizeIdTree(), deptFlag)).getBoolean("code").booleanValue()) {
                corpId = retMsg.getString("cropId");
            }
            if (StringUtils.isNotEmpty((String)corpId)) {
                WeComModel weComModel = this.wxCpConfiguration.getWeComModel(corpId);
                if (weComModel == null) {
                    synState = SynThirdConsts.SYN_STATE_NO;
                    description = String.format("[%s]\u672a\u627e\u5230\u5bf9\u5e94corpId=[%s]\u7684\u914d\u7f6e", deptFlag, corpId);
                    retMsg.put("code", (Object)false);
                    retMsg.put("msg", (Object)description);
                } else {
                    int qyhIsSyn = isBatch ? 1 : weComModel.getQyhIsSynOrg();
                    boolean isLinkedCorp = weComModel.getIsLinkedCorp();
                    if (qyhIsSyn == 1 && !isLinkedCorp) {
                        String agentId = weComModel.getQyhAgentId();
                        WxCpService wxCorpService = this.wxCpConfiguration.getCorpService(corpId);
                        WxCpService wxCpService = this.wxCpConfiguration.getCpService(corpId, Integer.valueOf(agentId));
                        if (wxCorpService == null || wxCpService == null) {
                            synState = SynThirdConsts.SYN_STATE_NO;
                            description = String.format("[%s]\u672a\u627e\u5230\u5bf9\u5e94corpId=[%s]\u3001agentId=[%d]\u7684\u914d\u7f6e", deptFlag, corpId, agentId);
                            retMsg.put("code", (Object)false);
                            retMsg.put("msg", (Object)description);
                        } else {
                            try {
                                SynThirdInfoEntity parentSynThirdInfo;
                                List departList = wxCpService.getDepartmentService().list(null);
                                if (departList == null || departList.size() == 0) {
                                    synState = SynThirdConsts.SYN_STATE_FAIL;
                                    description = String.format("[%s]\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1\u90e8\u95e8\u5217\u8868\u63a5\u53e3\u6570\u636e\u4e3a\u7a7a", deptFlag);
                                    retMsg.put("code", (Object)false);
                                    retMsg.put("msg", (Object)description);
                                    break block22;
                                }
                                WxCpDepart depart = new WxCpDepart();
                                depart.setName(deptEntity.getFullName());
                                depart.setEnName(deptEntity.getEnCode());
                                if (!"-1".equals(deptEntity.getParentId()) && (isDeptDiff = (retMsg = this.checkDepartmentSysToQy(parentSynThirdInfo = this.synThirdInfoService.getInfoBySysObjId("1", "1", deptEntity.getParentId()), departList)).getBoolean("code").booleanValue())) {
                                    depart.setParentId(Long.valueOf(parentSynThirdInfo.getThirdObjectId()));
                                }
                                depart.setOrder(Long.valueOf(1000000000L - deptEntity.getSortCode()));
                                if (isDeptDiff) {
                                    retMsg = this.checkDepartmentSysToQy(synThirdInfoEntity, departList);
                                    if (!retMsg.getBoolean("code").booleanValue()) {
                                        Long departId;
                                        String flag = retMsg.getString("flag");
                                        if ("1".equals(flag) || "3".equals(flag)) {
                                            if ("1".equals(flag)) {
                                                this.synThirdInfoService.delete(synThirdInfoEntity);
                                            }
                                            opType = "add";
                                            synThirdInfoPara = null;
                                            thirdObjId = "";
                                            retMsg = this.checkCnEnName(depart.getName(), depart.getEnName(), opType, synThirdInfoPara, currentUser, corpId, "1", "1", deptEntity.getId(), thirdObjId, deptFlag);
                                            if (!retMsg.getBoolean("code").booleanValue()) {
                                                return retMsg;
                                            }
                                            departId = wxCorpService.getDepartmentService().create(depart);
                                            thirdObjId = String.valueOf(departId);
                                            synState = SynThirdConsts.SYN_STATE_OK;
                                            description = deptFlag + "\u540c\u6b65\u6210\u529f";
                                            retMsg.put("code", (Object)true);
                                            retMsg.put("error", (Object)description);
                                        }
                                        if ("2".equals(flag)) {
                                            opType = "upd";
                                            synThirdInfoPara = synThirdInfoEntity;
                                            thirdObjId = "";
                                            retMsg = this.checkCnEnName(depart.getName(), depart.getEnName(), "upd", synThirdInfoPara, currentUser, corpId, "1", "1", deptEntity.getId(), thirdObjId, deptFlag);
                                            if (!retMsg.getBoolean("code").booleanValue()) {
                                                return retMsg;
                                            }
                                            departId = wxCorpService.getDepartmentService().create(depart);
                                            thirdObjId = String.valueOf(departId);
                                            synState = SynThirdConsts.SYN_STATE_OK;
                                            description = deptFlag + "\u540c\u6b65\u6210\u529f";
                                            retMsg.put("code", (Object)true);
                                            retMsg.put("error", (Object)description);
                                        }
                                    } else {
                                        opType = "upd";
                                        synThirdInfoPara = synThirdInfoEntity;
                                        thirdObjId = synThirdInfoEntity.getThirdObjectId();
                                        retMsg = this.checkCnEnName(depart.getName(), depart.getEnName(), "upd", synThirdInfoPara, currentUser, corpId, "1", "1", deptEntity.getId(), thirdObjId, deptFlag);
                                        if (!retMsg.getBoolean("code").booleanValue()) {
                                            return retMsg;
                                        }
                                        Long departId = Long.valueOf(synThirdInfoEntity.getThirdObjectId());
                                        depart.setId(departId);
                                        wxCorpService.getDepartmentService().update(depart);
                                        thirdObjId = String.valueOf(departId);
                                        synState = SynThirdConsts.SYN_STATE_OK;
                                        description = deptFlag + "\u540c\u6b65\u6210\u529f";
                                        retMsg.put("code", (Object)true);
                                        retMsg.put("error", (Object)description);
                                    }
                                    break block22;
                                }
                                synState = SynThirdConsts.SYN_STATE_FAIL;
                                description = deptFlag + "\u4e0a\u7ea7\u90e8\u95e8\u65e0\u5bf9\u5e94\u7684\u4f01\u4e1a\u5fae\u4fe1ID";
                                retMsg.put("code", (Object)false);
                                retMsg.put("error", (Object)description);
                            }
                            catch (WxErrorException e) {
                                synState = SynThirdConsts.SYN_STATE_FAIL;
                                description = deptFlag + e.getError().getErrorMsg();
                                retMsg.put("code", (Object)false);
                                retMsg.put("error", (Object)description);
                            }
                        }
                    } else {
                        synState = SynThirdConsts.SYN_STATE_NO;
                        description = deptFlag + "\u7cfb\u7edf\u672a\u8bbe\u7f6e\u5355\u6761\u540c\u6b65";
                        retMsg.put("code", (Object)true);
                        retMsg.put("error", (Object)description);
                        retMsg.put("retDeptId", (Object)"0");
                    }
                }
            } else {
                description = retMsg.getString("error");
            }
        }
        this.saveSynThirdInfoEntity(opType, synThirdInfoEntity, currentUser, corpId, "1", "1", deptEntity.getId(), thirdObjId, synState, description);
        return retMsg;
    }

    @Override
    public JSONObject deleteDepartmentSysToQy(UserInfo currentUser, boolean isBatch, String deptId, String corpId) {
        JSONObject retMsg = new JSONObject();
        String deptFlag = "\u5220\u9664\uff1a";
        SynThirdInfoEntity synThirdInfoEntity = this.synThirdInfoService.getInfoBySysObjId("1", "1", deptId);
        if (ObjectUtil.isNotEmpty((Object)synThirdInfoEntity)) {
            WeComModel weComModel;
            String thirdObjId = synThirdInfoEntity.getThirdObjectId();
            Integer synState = SynThirdConsts.SYN_STATE_NO;
            String description = "";
            if (StringUtils.isEmpty((String)corpId)) {
                corpId = synThirdInfoEntity.getCropId();
            }
            if ((weComModel = this.wxCpConfiguration.getWeComModel(corpId)) == null) {
                synState = SynThirdConsts.SYN_STATE_NO;
                description = String.format("[%s]\u672a\u627e\u5230\u5bf9\u5e94corpId=[%s]\u7684\u914d\u7f6e", deptFlag, corpId);
                retMsg.put("code", (Object)false);
                retMsg.put("msg", (Object)description);
            } else {
                int qyhIsSyn = isBatch ? 1 : weComModel.getQyhIsSynOrg();
                boolean isLinkedCorp = weComModel.getIsLinkedCorp();
                if (qyhIsSyn == 1 && !isLinkedCorp) {
                    String agentId = weComModel.getQyhAgentId();
                    WxCpService wxCorpService = this.wxCpConfiguration.getCorpService(corpId);
                    WxCpService wxCpService = this.wxCpConfiguration.getCpService(corpId, Integer.valueOf(agentId));
                    if (wxCorpService == null || wxCpService == null) {
                        synState = SynThirdConsts.SYN_STATE_NO;
                        description = String.format("[%s]\u672a\u627e\u5230\u5bf9\u5e94corpId=[%s]\u3001agentId=[%d]\u7684\u914d\u7f6e", deptFlag, corpId, agentId);
                        retMsg.put("code", (Object)false);
                        retMsg.put("msg", (Object)description);
                    } else {
                        try {
                            if (StringUtils.isNotEmpty((String)thirdObjId)) {
                                Long departId = Long.valueOf(synThirdInfoEntity.getThirdObjectId());
                                wxCorpService.getDepartmentService().delete(departId);
                                this.synThirdInfoService.delete(synThirdInfoEntity);
                            } else {
                                this.synThirdInfoService.delete(synThirdInfoEntity);
                            }
                            retMsg.put("code", (Object)true);
                            retMsg.put("msg", (Object)(deptFlag + "\u540c\u6b65\u6210\u529f"));
                            return retMsg;
                        }
                        catch (WxErrorException e) {
                            synState = SynThirdConsts.SYN_STATE_FAIL;
                            description = deptFlag + e.getError().getErrorMsg();
                            retMsg.put("code", (Object)false);
                            retMsg.put("error", (Object)description);
                        }
                    }
                } else {
                    synState = SynThirdConsts.SYN_STATE_NO;
                    description = deptFlag + "\u7cfb\u7edf\u672a\u8bbe\u7f6e\u5355\u6761\u540c\u6b65";
                    retMsg.put("code", (Object)true);
                    retMsg.put("error", (Object)description);
                    retMsg.put("retDeptId", (Object)"0");
                }
            }
            this.saveSynThirdInfoEntity("upd", synThirdInfoEntity, currentUser, corpId, "1", "1", deptId, thirdObjId, synState, description);
        } else {
            retMsg.put("code", (Object)true);
            retMsg.put("msg", (Object)"\u7b2c\u4e09\u65b9\u540c\u6b65\u4fe1\u606f\u4e3a\u7a7a");
        }
        return retMsg;
    }

    @Override
    public boolean triggeringCondition(OrganizeEntity oldDept, OrganizeEntity newDept) {
        if (ObjectUtil.isNotEmpty((Object)oldDept) && ObjectUtil.isNotEmpty((Object)newDept)) {
            if (!StringUtils.equals((CharSequence)oldDept.getParentId(), (CharSequence)newDept.getParentId())) {
                return true;
            }
            if (!StringUtils.equals((CharSequence)oldDept.getFullName(), (CharSequence)newDept.getFullName())) {
                return true;
            }
            if (oldDept.getSortCode().longValue() != newDept.getSortCode().longValue()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean triggeringConditionForUser(OrganizeEntity oldDept, OrganizeEntity newDept) {
        return ObjectUtil.isNotEmpty((Object)oldDept) && ObjectUtil.isNotEmpty((Object)newDept) && !StringUtils.equals((CharSequence)oldDept.getManagerId(), (CharSequence)newDept.getManagerId());
    }

    public JSONObject checkDepartmentSysToQy(SynThirdInfoEntity synThirdInfoEntity) {
        return this.checkDepartmentSysToQy(synThirdInfoEntity, null);
    }

    public JSONObject checkDepartmentSysToQy(SynThirdInfoEntity synThirdInfoEntity, List<WxCpDepart> qyDeptList) {
        JSONObject retMsg = new JSONObject();
        retMsg.put("code", (Object)true);
        retMsg.put("flag", (Object)"");
        retMsg.put("error", (Object)"");
        if (synThirdInfoEntity != null) {
            if (StringUtils.isNotEmpty((String)synThirdInfoEntity.getThirdObjectId())) {
                if (CollectionUtil.isNotEmpty(qyDeptList) && qyDeptList.stream().filter(t -> t.getId().toString().equals(synThirdInfoEntity.getThirdObjectId())).count() == 0L) {
                    retMsg.put("code", (Object)false);
                    retMsg.put("flag", (Object)"1");
                    retMsg.put("error", (Object)"\u4f01\u4e1a\u5fae\u4fe1\u4e0d\u5b58\u5728\u540c\u6b65\u8868\u5bf9\u5e94\u7684\u90e8\u95e8ID!");
                }
            } else {
                retMsg.put("code", (Object)false);
                retMsg.put("flag", (Object)"2");
                retMsg.put("error", (Object)"\u540c\u6b65\u8868\u4e2d\u90e8\u95e8\u5bf9\u5e94\u7684\u4f01\u4e1a\u5fae\u4fe1ID\u4e3a\u7a7a!");
            }
        } else {
            retMsg.put("code", (Object)false);
            retMsg.put("flag", (Object)"3");
            retMsg.put("error", (Object)"\u90e8\u95e8\u672a\u540c\u6b65\u5230\u4f01\u4e1a\u5fae\u4fe1!");
        }
        return retMsg;
    }

    public JSONObject checkCnEnName(String cnName, String EnName, String opType, SynThirdInfoEntity synThirdInfoEntity, UserInfo currentUser, String corpId, String thirdType, String dataType, String sysObjId, String thirdObjId, String deptFlag) {
        JSONObject retMsg = new JSONObject();
        retMsg.put("code", (Object)true);
        retMsg.put("error", (Object)"");
        if (cnName.equals(EnName)) {
            Integer synState = SynThirdConsts.SYN_STATE_FAIL;
            String description = deptFlag + "\u90e8\u95e8\u4e2d\u6587\u540d\u79f0\u4e0e\u82f1\u6587\u540d\u79f0\u4e0d\u80fd\u76f8\u540c";
            this.saveSynThirdInfoEntity(opType, synThirdInfoEntity, currentUser, corpId, thirdType, dataType, sysObjId, thirdObjId, synState, description);
            retMsg.put("code", (Object)false);
            retMsg.put("error", (Object)description);
        }
        return retMsg;
    }

    public void saveSynThirdInfoEntity(String opType, SynThirdInfoEntity synThirdInfoEntity, UserInfo currentUser, String corpId, String thirdType, String dataType, String sysObjId, String thirdObjId, Integer synState, String description) {
        SynThirdInfoEntity entity = new SynThirdInfoEntity();
        if ("add".equals(opType)) {
            entity.setId(RandomUtil.uuId());
            entity.setCropId(corpId);
            entity.setThirdType(Integer.parseInt(thirdType));
            entity.setDataType(Integer.parseInt(dataType));
            entity.setSystemObjectId(sysObjId);
            entity.setThirdObjectId(thirdObjId);
            entity.setSynState(synState);
            entity.setDescription(description);
            entity.setCreatorUserId(currentUser.getUserId());
            entity.setLastModifyUserId(currentUser.getUserId());
            this.synThirdInfoService.create(entity);
        } else {
            entity = synThirdInfoEntity;
            entity.setCropId(corpId);
            entity.setThirdType(Integer.parseInt(thirdType));
            entity.setDataType(Integer.parseInt(dataType));
            entity.setThirdObjectId(thirdObjId);
            entity.setSynState(synState);
            entity.setDescription(description);
            entity.setLastModifyUserId(currentUser.getUserId());
            this.synThirdInfoService.update(entity.getId(), entity);
        }
    }

    public JSONObject getOrganizeCorpid(String organizeIdTree, String deptFlag) {
        JSONObject retMsg = new JSONObject();
        retMsg.put("code", (Object)false);
        if (StringUtils.isNotEmpty((String)organizeIdTree)) {
            String[] organizeIdArr = organizeIdTree.split(",");
            if (ObjectUtil.isNotEmpty((Object)organizeIdArr) && organizeIdArr.length > 0) {
                SynThirdInfoEntity topEntity = this.synThirdInfoService.getInfoBySysObjId("1", "1", organizeIdArr[0]);
                if (ObjectUtil.isNotEmpty((Object)topEntity)) {
                    if (StringUtils.isNotEmpty((String)topEntity.getCropId())) {
                        retMsg.put("code", (Object)true);
                        retMsg.put("error", (Object)(deptFlag + "\u83b7\u53d6\u7ec4\u7ec7\u6240\u5c5ecorpid\u6210\u529f"));
                        retMsg.put("cropId", (Object)topEntity.getCropId());
                    } else {
                        retMsg.put("code", (Object)false);
                        retMsg.put("error", (Object)(deptFlag + "\u83b7\u53d6\u7ec4\u7ec7\u6240\u5c5ecorpid\u5931\u8d25\uff0c\u7cfb\u7edf\u7ec4\u7ec7\u9876\u7ea7id\u7b2c\u4e09\u65b9\u8868\u4fe1\u606fCorpid\u4e3a\u7a7a"));
                    }
                } else {
                    retMsg.put("code", (Object)false);
                    retMsg.put("error", (Object)(deptFlag + "\u83b7\u53d6\u7ec4\u7ec7\u6240\u5c5ecorpid\u5931\u8d25\uff0c\u7cfb\u7edf\u7ec4\u7ec7\u9876\u7ea7id\u4e0d\u5b58\u5728\u7b2c\u4e09\u65b9\u8868\u4fe1\u606f"));
                }
            } else {
                retMsg.put("code", (Object)false);
                retMsg.put("error", (Object)(deptFlag + "\u83b7\u53d6\u7ec4\u7ec7\u6240\u5c5ecorpid\u5931\u8d25\uff0c\u7cfb\u7edf\u7ec4\u7ec7\u9876\u7ea7id\u83b7\u53d6\u5931\u8d25"));
            }
        } else {
            retMsg.put("code", (Object)false);
            retMsg.put("error", (Object)(deptFlag + "\u83b7\u53d6\u7ec4\u7ec7\u6240\u5c5ecorpid\u5931\u8d25\uff0c\u7cfb\u7edf\u7ec4\u7ec7\u7236\u7ea7\u7ec4\u7ec7tree\u4e3a\u7a7a"));
        }
        return retMsg;
    }

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED)
    public JSONObject createUserSysToQy(UserInfo currentUser, boolean isBatch, UserEntity userEntity, String corpId) {
        String description;
        Integer synState;
        String thirdObjId;
        JSONObject retMsg;
        block12: {
            retMsg = new JSONObject();
            retMsg.put("code", (Object)false);
            String userFlag = "\u521b\u5efa\uff1a";
            thirdObjId = "";
            synState = SynThirdConsts.SYN_STATE_NO;
            description = "";
            String organizeId = userEntity.getOrganizeId();
            OrganizeEntity deptEntity = this.organizeService.getInfo(organizeId);
            if (StringUtils.isEmpty((String)corpId) && (retMsg = this.getOrganizeCorpid(deptEntity.getOrganizeIdTree(), userFlag)).getBoolean("code").booleanValue()) {
                corpId = retMsg.getString("cropId");
            }
            if (StringUtils.isNotEmpty((String)corpId)) {
                WeComModel weComModel = this.wxCpConfiguration.getWeComModel(corpId);
                if (weComModel == null) {
                    synState = SynThirdConsts.SYN_STATE_NO;
                    description = String.format("[%s]\u672a\u627e\u5230\u5bf9\u5e94corpId=[%s]\u7684\u914d\u7f6e", userFlag, corpId);
                    retMsg.put("code", (Object)false);
                    retMsg.put("msg", (Object)description);
                } else {
                    int qyhIsSyn = isBatch ? 1 : weComModel.getQyhIsSynUser();
                    boolean isLinkedCorp = weComModel.getIsLinkedCorp();
                    if (qyhIsSyn == 1 && !isLinkedCorp) {
                        String agentId = weComModel.getQyhAgentId();
                        WxCpService wxCorpService = this.wxCpConfiguration.getCorpService(corpId);
                        WxCpService wxCpService = this.wxCpConfiguration.getCpService(corpId, Integer.valueOf(agentId));
                        if (wxCorpService == null || wxCpService == null) {
                            synState = SynThirdConsts.SYN_STATE_NO;
                            description = String.format("[%s]\u672a\u627e\u5230\u5bf9\u5e94corpId=[%s]\u3001agentId=[%d]\u7684\u914d\u7f6e", userFlag, corpId, agentId);
                            retMsg.put("code", (Object)false);
                            retMsg.put("msg", (Object)description);
                        } else {
                            try {
                                retMsg = this.wxCpUserCreateOrUpdate(wxCpService, userEntity, retMsg, null);
                                if (retMsg.getBoolean("code").booleanValue()) {
                                    WxCpUser user = (WxCpUser)retMsg.getObject("wxCpUser", WxCpUser.class);
                                    wxCorpService.getUserService().create(user);
                                    thirdObjId = user.getUserId();
                                    synState = SynThirdConsts.SYN_STATE_OK;
                                    description = userFlag + "\u540c\u6b65\u6210\u529f";
                                    retMsg.put("code", (Object)true);
                                    retMsg.put("error", (Object)description);
                                    break block12;
                                }
                                synState = SynThirdConsts.SYN_STATE_FAIL;
                                description = userFlag + retMsg.getString("error");
                                retMsg.put("code", (Object)false);
                                retMsg.put("error", (Object)description);
                            }
                            catch (WxErrorException e) {
                                synState = SynThirdConsts.SYN_STATE_FAIL;
                                description = userFlag + e.getError().getErrorMsg();
                                retMsg.put("code", (Object)false);
                                retMsg.put("error", (Object)description);
                            }
                        }
                    } else {
                        synState = SynThirdConsts.SYN_STATE_NO;
                        description = userFlag + "\u7cfb\u7edf\u672a\u8bbe\u7f6e\u5355\u6761\u540c\u6b65";
                        retMsg.put("code", (Object)false);
                        retMsg.put("error", (Object)description);
                    }
                }
            } else {
                description = retMsg.getString("error");
            }
        }
        this.saveSynThirdInfoEntity("add", null, currentUser, corpId, "1", "2", userEntity.getId(), thirdObjId, synState, description);
        return retMsg;
    }

    public JSONObject wxCpUserCreateOrUpdate(WxCpService wxCpService, UserEntity userEntity, JSONObject retMsg, WxCpUser wxCpUserInfo) throws WxErrorException {
        WxCpUser user = new WxCpUser();
        if (StringUtils.isNotEmpty((String)userEntity.getEmail()) && !Validator.isEmail((CharSequence)userEntity.getEmail())) {
            retMsg.put("code", (Object)false);
            retMsg.put("error", (Object)"\u90ae\u7bb1\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
            retMsg.put("wxCpUser", null);
            return retMsg;
        }
        List departList = wxCpService.getDepartmentService().list(null);
        if (CollectionUtil.isEmpty((Collection)departList)) {
            retMsg.put("code", (Object)false);
            retMsg.put("error", (Object)"\u4f01\u4e1a\u5fae\u4fe1\u90e8\u95e8\u5217\u8868\u63a5\u53e3\u6570\u636eisEmpty");
            retMsg.put("wxCpUser", null);
            return retMsg;
        }
        List<String> userAllOrgIds = this.userRelationService.getListByUserIdAndObjType(userEntity.getId(), "Organize").stream().map(UserRelationEntity::getObjectId).collect(Collectors.toList());
        String organizeId = userEntity.getOrganizeId();
        if (CollectionUtil.isEmpty(userAllOrgIds)) {
            retMsg.put("code", (Object)false);
            retMsg.put("error", (Object)"\u6210\u5458\u6240\u5c5e\u90e8\u95e8isEmpty");
            retMsg.put("wxCpUser", null);
            return retMsg;
        }
        List<SynThirdInfoEntity> orgSynThirdList = this.synThirdInfoService.getListByObjId(Integer.valueOf("1"), userAllOrgIds);
        if (CollectionUtil.isEmpty(orgSynThirdList)) {
            retMsg.put("code", (Object)false);
            retMsg.put("error", (Object)"\u6210\u5458\u6240\u5c5e\u90e8\u95e8\u7b2c\u4e09\u65b9\u540c\u6b65\u8868\u4fe1\u606fisEmpty");
            retMsg.put("wxCpUser", null);
            return retMsg;
        }
        String mainDepartment = null;
        boolean orgAllSyn = true;
        String description = "";
        for (SynThirdInfoEntity entity : orgSynThirdList) {
            JSONObject validateRetMsg = this.checkDepartmentSysToQy(entity, departList);
            if (!validateRetMsg.getBoolean("code").booleanValue()) {
                String errorMsg = validateRetMsg.getString("error");
                orgAllSyn = false;
                description = description + String.format("[%s]\uff0c[%s]", entity.getSystemObjectId(), errorMsg);
                continue;
            }
            if (!entity.getSystemObjectId().equals(organizeId)) continue;
            mainDepartment = entity.getThirdObjectId();
        }
        if (!orgAllSyn) {
            retMsg.put("code", (Object)false);
            retMsg.put("error", (Object)description);
            retMsg.put("wxCpUser", null);
            return retMsg;
        }
        List<OrganizeEntity> listAll = this.organizeService.getListAll(userAllOrgIds, null);
        int size = orgSynThirdList.size();
        Long[] departIds = new Long[size];
        Integer[] orders = new Integer[size];
        Long sortCode = userEntity.getSortCode();
        Integer[] isLeaderInDept = new Integer[size];
        for (int i = 0; i < size; ++i) {
            SynThirdInfoEntity thirdInfoEntity = orgSynThirdList.get(i);
            departIds[i] = Long.valueOf(thirdInfoEntity.getThirdObjectId());
            Optional first = listAll.stream().filter(s -> s.getId().equals(thirdInfoEntity.getSystemObjectId())).collect(Collectors.toList()).stream().findFirst();
            isLeaderInDept[i] = userEntity.getId().equals(((OrganizeEntity)first.get()).getManagerId()) ? Integer.valueOf(1) : Integer.valueOf(0);
            isLeaderInDept[i] = 0;
            orders[i] = ObjectUtil.isNull((Object)sortCode) ? 0 : 1000000000 - sortCode.intValue();
        }
        user.setDepartIds(departIds);
        user.setMainDepartment(mainDepartment);
        user.setOrders(orders);
        user.setIsLeaderInDept(isLeaderInDept);
        PositionEntity positionEntity = this.positionService.getInfo(userEntity.getPositionId());
        if (ObjectUtil.isNotEmpty((Object)positionEntity)) {
            user.setPosition(positionEntity.getFullName());
        }
        user.setUserId(userEntity.getAccount());
        user.setName(userEntity.getRealName());
        user.setAlias(userEntity.getQuickQuery());
        user.setMobile(userEntity.getMobilePhone());
        user.setEmail(userEntity.getEmail());
        user.setGender(Gender.fromCode((String)userEntity.getGender().toString()));
        user.setTelephone(userEntity.getTelePhone());
        Integer enabledMark = userEntity.getEnabledMark();
        user.setEnable(Integer.valueOf(enabledMark != null && enabledMark != 0 ? 1 : 0));
        user.addExtAttr("\u5de5\u53f7", userEntity.getCode());
        user.addExtAttr("\u624b\u673a\u53f7\u7801", userEntity.getMobilePhone());
        user.setAddress(userEntity.getPostalAddress());
        List<SynThirdInfoEntity> synThirdInfoEntityList = this.synThirdInfoService.getInfoBySysObjIds("1", "2", userEntity.getManagerId(), false);
        if (CollectionUtil.isNotEmpty(synThirdInfoEntityList)) {
            user.setDirectLeader(new String[]{synThirdInfoEntityList.get(0).getThirdObjectId()});
        }
        if (ObjectUtil.isNotEmpty((Object)wxCpUserInfo)) {
            user.setUserId(wxCpUserInfo.getUserId());
            user.setAlias(wxCpUserInfo.getAlias());
            user.setAvatarMediaId(wxCpUserInfo.getAvatarMediaId());
            user.setExternalAttrs(wxCpUserInfo.getExternalAttrs());
            user.setExternalPosition(wxCpUserInfo.getExternalPosition());
        }
        retMsg.put("code", (Object)true);
        retMsg.put("error", (Object)"\u63d0\u4ea4\u4f01\u4e1a\u5fae\u4fe1\u7684\u7528\u6237\u4fe1\u606f\u5c01\u88c5\u5b8c\u6210");
        retMsg.put("wxCpUser", (Object)user);
        return retMsg;
    }

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED)
    public JSONObject updateUserSysToQy(UserInfo currentUser, boolean isBatch, UserEntity userEntity, String corpId) {
        String thirdObjId;
        SynThirdInfoEntity synThirdInfoEntity;
        String description;
        Integer synState;
        String opType;
        JSONObject retMsg;
        block23: {
            retMsg = new JSONObject();
            retMsg.put("code", (Object)false);
            String userFlag = "\u66f4\u65b0\uff1a";
            opType = "upd";
            synState = SynThirdConsts.SYN_STATE_NO;
            description = "";
            synThirdInfoEntity = null;
            List<SynThirdInfoEntity> infoBySysObjIds = this.synThirdInfoService.getInfoBySysObjIds("1", "2", userEntity.getId(), false);
            if (CollectionUtil.isNotEmpty(infoBySysObjIds)) {
                synThirdInfoEntity = infoBySysObjIds.get(0);
            }
            thirdObjId = ObjectUtil.isNotEmpty(synThirdInfoEntity) ? synThirdInfoEntity.getThirdObjectId() : "";
            String organizeId = userEntity.getOrganizeId();
            OrganizeEntity deptEntity = this.organizeService.getInfo(organizeId);
            if (StringUtils.isEmpty((String)corpId) && (retMsg = this.getOrganizeCorpid(deptEntity.getOrganizeIdTree(), userFlag)).getBoolean("code").booleanValue()) {
                corpId = retMsg.getString("cropId");
            }
            if (StringUtils.isEmpty((String)corpId)) {
                synState = SynThirdConsts.SYN_STATE_NO;
                description = retMsg.getString("error");
                retMsg.put("code", (Object)false);
                retMsg.put("error", (Object)description);
            } else {
                WeComModel weComModel = this.wxCpConfiguration.getWeComModel(corpId);
                if (weComModel == null) {
                    synState = SynThirdConsts.SYN_STATE_NO;
                    description = String.format("[%s]\u672a\u627e\u5230\u5bf9\u5e94corpId=[%s]\u7684\u914d\u7f6e", userFlag, corpId);
                    retMsg.put("code", (Object)false);
                    retMsg.put("msg", (Object)description);
                } else {
                    int qyhIsSyn = isBatch ? 1 : weComModel.getQyhIsSynUser();
                    boolean isLinkedCorp = weComModel.getIsLinkedCorp();
                    if (qyhIsSyn == 1 && !isLinkedCorp) {
                        String agentId = weComModel.getQyhAgentId();
                        WxCpService wxCorpService = this.wxCpConfiguration.getCorpService(corpId);
                        WxCpService wxCpService = this.wxCpConfiguration.getCpService(corpId, Integer.valueOf(agentId));
                        if (wxCorpService == null || wxCpService == null) {
                            synState = SynThirdConsts.SYN_STATE_NO;
                            description = String.format("[%s]\u672a\u627e\u5230\u5bf9\u5e94corpId=[%s]\u3001agentId=[%d]\u7684\u914d\u7f6e", userFlag, corpId, agentId);
                            retMsg.put("code", (Object)false);
                            retMsg.put("msg", (Object)description);
                        } else {
                            try {
                                retMsg = this.wxCpUserCreateOrUpdate(wxCpService, userEntity, retMsg, null);
                                if (retMsg.getBoolean("code").booleanValue()) {
                                    WxCpUser wxCpUser = (WxCpUser)retMsg.getObject("wxCpUser", WxCpUser.class);
                                    Long departId = 1L;
                                    boolean fetchChild = true;
                                    Integer status = 0;
                                    List wxCpUserList = wxCpService.getUserService().listByDepartment(departId, Boolean.valueOf(fetchChild), status);
                                    if (StringUtils.isEmpty((Collection)wxCpUserList)) {
                                        synState = SynThirdConsts.SYN_STATE_FAIL;
                                        description = String.format("[%s]\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1\u7528\u6237\u5217\u8868\u63a5\u53e3\u6570\u636e\u4e3a\u7a7a", userFlag);
                                        retMsg.put("code", (Object)false);
                                        retMsg.put("msg", (Object)description);
                                    } else {
                                        retMsg = this.checkUserSysToQy(synThirdInfoEntity, wxCpUserList);
                                        if (!retMsg.getBoolean("code").booleanValue()) {
                                            String flag = retMsg.getString("flag");
                                            if ("1".equals(flag) || "3".equals(flag)) {
                                                if ("1".equals(flag)) {
                                                    this.synThirdInfoService.delete(synThirdInfoEntity);
                                                }
                                                opType = "add";
                                                synThirdInfoEntity = null;
                                                thirdObjId = "";
                                                wxCorpService.getUserService().create(wxCpUser);
                                                thirdObjId = wxCpUser.getUserId();
                                                synState = SynThirdConsts.SYN_STATE_OK;
                                                description = userFlag + "\u540c\u6b65\u6210\u529f";
                                                retMsg.put("code", (Object)true);
                                                retMsg.put("error", (Object)description);
                                            }
                                            if ("2".equals(flag)) {
                                                opType = "upd";
                                                thirdObjId = "";
                                                wxCorpService.getUserService().create(wxCpUser);
                                                thirdObjId = wxCpUser.getUserId();
                                                synState = SynThirdConsts.SYN_STATE_OK;
                                                description = userFlag + "\u540c\u6b65\u6210\u529f";
                                                retMsg.put("code", (Object)true);
                                                retMsg.put("error", (Object)description);
                                            }
                                        } else {
                                            opType = "upd";
                                            String userId = thirdObjId = synThirdInfoEntity.getThirdObjectId();
                                            WxCpUser wxCpUserInfo = wxCpService.getUserService().getById(userId);
                                            if (ObjectUtil.isEmpty((Object)wxCpUserInfo)) {
                                                synState = SynThirdConsts.SYN_STATE_FAIL;
                                                description = userFlag + "\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1\u5f53\u524d\u7528\u6237\u4fe1\u606f\u5931\u8d25";
                                            } else {
                                                retMsg = this.wxCpUserCreateOrUpdate(wxCpService, userEntity, retMsg, wxCpUserInfo);
                                                wxCpUser = (WxCpUser)retMsg.getObject("wxCpUser", WxCpUser.class);
                                                wxCorpService.getUserService().update(wxCpUser);
                                                thirdObjId = wxCpUser.getUserId();
                                                synState = SynThirdConsts.SYN_STATE_OK;
                                                description = userFlag + "\u540c\u6b65\u6210\u529f";
                                                retMsg.put("code", (Object)true);
                                                retMsg.put("error", (Object)description);
                                            }
                                        }
                                    }
                                    break block23;
                                }
                                synState = SynThirdConsts.SYN_STATE_FAIL;
                                description = userFlag + retMsg.getString("error");
                                retMsg.put("code", (Object)false);
                                retMsg.put("error", (Object)description);
                            }
                            catch (WxErrorException e) {
                                synState = SynThirdConsts.SYN_STATE_FAIL;
                                description = userFlag + e.getError().toString();
                                retMsg.put("code", (Object)false);
                                retMsg.put("error", (Object)description);
                            }
                        }
                    } else {
                        synState = SynThirdConsts.SYN_STATE_NO;
                        description = userFlag + "\u7cfb\u7edf\u672a\u8bbe\u7f6e\u5355\u6761\u540c\u6b65";
                        retMsg.put("code", (Object)false);
                        retMsg.put("error", (Object)description);
                    }
                }
            }
        }
        if (ObjectUtil.isEmpty((Object)synThirdInfoEntity) && !"add".equals(opType)) {
            opType = "add";
        }
        this.saveSynThirdInfoEntity(opType, synThirdInfoEntity, currentUser, corpId, "1", "2", userEntity.getId(), thirdObjId, synState, description);
        return retMsg;
    }

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED)
    public JSONObject deleteUserSysToQy(UserInfo currentUser, boolean isBatch, String sysUserId, String corpId) {
        JSONObject retMsg = new JSONObject();
        String deptFlag = "\u5220\u9664\uff1a";
        SynThirdInfoEntity synThirdInfoEntity = this.synThirdInfoService.getInfoBySysObjId("1", "2", sysUserId);
        if (ObjectUtil.isNotEmpty((Object)synThirdInfoEntity)) {
            WeComModel weComModel;
            String thirdObjId = synThirdInfoEntity.getThirdObjectId();
            Integer synState = SynThirdConsts.SYN_STATE_NO;
            String description = "";
            if (StringUtils.isEmpty((String)corpId)) {
                corpId = synThirdInfoEntity.getCropId();
            }
            if ((weComModel = this.wxCpConfiguration.getWeComModel(corpId)) == null) {
                synState = SynThirdConsts.SYN_STATE_NO;
                description = String.format("[%s]\u672a\u627e\u5230\u5bf9\u5e94corpId=[%s]\u7684\u914d\u7f6e", deptFlag, corpId);
                retMsg.put("code", (Object)false);
                retMsg.put("msg", (Object)description);
            } else {
                int qyhIsSyn = isBatch ? 1 : weComModel.getQyhIsSynUser();
                boolean isLinkedCorp = weComModel.getIsLinkedCorp();
                if (qyhIsSyn == 1 && !isLinkedCorp) {
                    String agentId = weComModel.getQyhAgentId();
                    WxCpService wxCorpService = this.wxCpConfiguration.getCorpService(corpId);
                    WxCpService wxCpService = this.wxCpConfiguration.getCpService(corpId, Integer.valueOf(agentId));
                    if (wxCorpService == null || wxCpService == null) {
                        synState = SynThirdConsts.SYN_STATE_NO;
                        description = String.format("[%s]\u672a\u627e\u5230\u5bf9\u5e94corpId=[%s]\u3001agentId=[%d]\u7684\u914d\u7f6e", deptFlag, corpId, agentId);
                        retMsg.put("code", (Object)false);
                        retMsg.put("msg", (Object)description);
                    } else {
                        try {
                            if (StringUtils.isNotEmpty((String)thirdObjId)) {
                                String userId = thirdObjId;
                                if (!StringUtils.isEmpty((String)userId)) {
                                    wxCorpService.getUserService().delete(new String[]{userId});
                                    this.synThirdInfoService.delete(synThirdInfoEntity);
                                    retMsg.put("code", (Object)true);
                                    retMsg.put("msg", (Object)(deptFlag + "\u540c\u6b65\u6210\u529f"));
                                    return retMsg;
                                }
                            } else {
                                this.synThirdInfoService.delete(synThirdInfoEntity);
                                retMsg.put("code", (Object)true);
                                retMsg.put("msg", (Object)(deptFlag + "\u540c\u6b65\u6210\u529f"));
                                return retMsg;
                            }
                            synState = SynThirdConsts.SYN_STATE_FAIL;
                            description = deptFlag + "\u7528\u6237UserId\u662fisEmpty";
                            retMsg.put("code", (Object)false);
                            retMsg.put("error", (Object)description);
                        }
                        catch (WxErrorException e) {
                            synState = SynThirdConsts.SYN_STATE_FAIL;
                            description = deptFlag + e.getError().getErrorMsg();
                            retMsg.put("code", (Object)false);
                            retMsg.put("error", (Object)description);
                        }
                    }
                } else {
                    synState = SynThirdConsts.SYN_STATE_NO;
                    description = deptFlag + "\u7cfb\u7edf\u672a\u8bbe\u7f6e\u5355\u6761\u540c\u6b65";
                    retMsg.put("code", (Object)true);
                    retMsg.put("error", (Object)description);
                    retMsg.put("retDeptId", (Object)"0");
                }
            }
            this.saveSynThirdInfoEntity("upd", synThirdInfoEntity, currentUser, corpId, "1", "2", sysUserId, thirdObjId, synState, description);
        } else {
            retMsg.put("code", (Object)true);
            retMsg.put("msg", (Object)"\u7b2c\u4e09\u65b9\u540c\u6b65\u4fe1\u606f\u4e3a\u7a7a");
        }
        return retMsg;
    }

    public JSONObject checkUserSysToQy(SynThirdInfoEntity synThirdInfoEntity, List<WxCpUser> wxCpUserList) {
        JSONObject retMsg = new JSONObject();
        retMsg.put("code", (Object)true);
        retMsg.put("flag", (Object)"");
        retMsg.put("error", (Object)"");
        if (synThirdInfoEntity != null) {
            String thirdObjectId = synThirdInfoEntity.getThirdObjectId();
            if (StringUtils.isNotEmpty((String)thirdObjectId)) {
                String userId = thirdObjectId.substring(thirdObjectId.lastIndexOf("/") + 1);
                if (wxCpUserList.stream().filter(t -> t.getUserId().equals(userId)).count() == 0L) {
                    retMsg.put("code", (Object)false);
                    retMsg.put("flag", (Object)"1");
                    retMsg.put("error", (Object)"\u4f01\u4e1a\u5fae\u4fe1\u4e0d\u5b58\u5728\u540c\u6b65\u8868\u5bf9\u5e94\u7684\u7528\u6237ID!");
                }
            } else {
                retMsg.put("code", (Object)false);
                retMsg.put("flag", (Object)"2");
                retMsg.put("error", (Object)"\u540c\u6b65\u8868\u4e2d\u7528\u6237\u5bf9\u5e94\u7684\u7b2c\u4e09\u65b9ID\u4e3a\u7a7a!");
            }
        } else {
            retMsg.put("code", (Object)false);
            retMsg.put("flag", (Object)"3");
            retMsg.put("error", (Object)"\u7528\u6237\u672a\u540c\u6b65!");
        }
        return retMsg;
    }

    @Override
    public boolean triggeringCondition(UserEntity oldUser, UserEntity newUser) {
        if (ObjectUtil.isNotEmpty((Object)oldUser) && ObjectUtil.isNotEmpty((Object)newUser)) {
            if (!StringUtils.equals((CharSequence)oldUser.getRealName(), (CharSequence)newUser.getRealName())) {
                return true;
            }
            if (!StringUtils.equals((CharSequence)oldUser.getNickName(), (CharSequence)newUser.getNickName())) {
                return true;
            }
            if (!StringUtils.equals((CharSequence)oldUser.getMobilePhone(), (CharSequence)newUser.getMobilePhone())) {
                return true;
            }
            if (!StringUtils.equals((CharSequence)oldUser.getTelePhone(), (CharSequence)newUser.getTelePhone())) {
                return true;
            }
            if (!StringUtils.equals((CharSequence)oldUser.getOrganizeId(), (CharSequence)newUser.getOrganizeId())) {
                return true;
            }
            if (!StringUtils.equals((CharSequence)oldUser.getPositionId(), (CharSequence)newUser.getPositionId())) {
                return true;
            }
            if (oldUser.getGender().intValue() != newUser.getGender().intValue()) {
                return true;
            }
            if (!StringUtils.equals((CharSequence)oldUser.getEmail(), (CharSequence)newUser.getEmail())) {
                return true;
            }
            if (!StringUtils.equals((CharSequence)oldUser.getCode(), (CharSequence)newUser.getCode())) {
                return true;
            }
            if (ObjectUtil.isNotEmpty((Object)oldUser.getSortCode()) && ObjectUtil.isNotEmpty((Object)newUser.getSortCode()) && oldUser.getSortCode().longValue() != newUser.getSortCode().longValue()) {
                return true;
            }
            if (!StringUtils.equals((CharSequence)oldUser.getManagerId(), (CharSequence)newUser.getManagerId())) {
                return true;
            }
            if (oldUser.getEnabledMark().intValue() != newUser.getEnabledMark().intValue()) {
                return true;
            }
        }
        return false;
    }
}

