/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgcenter.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.EnabledMarkEnum;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.msgcenter.entity.McMsgTemplateEntity;
import com.bringspring.system.msgcenter.entity.McMsgTemplateFieldEntity;
import com.bringspring.system.msgcenter.mapper.McMsgTemplateMapper;
import com.bringspring.system.msgcenter.model.mcmsgtemplate.McMsgTemplateCrForm;
import com.bringspring.system.msgcenter.model.mcmsgtemplate.McMsgTemplatePagination;
import com.bringspring.system.msgcenter.model.mcmsgtemplate.McMsgTemplateUpForm;
import com.bringspring.system.msgcenter.service.McMsgTemplateFieldService;
import com.bringspring.system.msgcenter.service.McMsgTemplateService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class McMsgTemplateServiceImpl
extends ServiceImpl<McMsgTemplateMapper, McMsgTemplateEntity>
implements McMsgTemplateService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private McMsgTemplateFieldService mcMsgTemplateFieldService;

    @Override
    public List<McMsgTemplateEntity> getList(McMsgTemplatePagination pagination) {
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)pagination.getTemplateType())) {
            queryWrapper.lambda().eq(McMsgTemplateEntity::getTemplateType, (Object)pagination.getTemplateType());
        }
        if (StringUtils.isNotEmpty((String)pagination.getMessageType())) {
            queryWrapper.lambda().eq(McMsgTemplateEntity::getMessageType, (Object)pagination.getMessageType());
        }
        if (StringUtils.isNotEmpty((String)pagination.getMessageSource())) {
            queryWrapper.lambda().eq(McMsgTemplateEntity::getMessageSource, (Object)pagination.getMessageSource());
        }
        if (StringUtils.isNotEmpty((String)pagination.getEnabledMark())) {
            queryWrapper.lambda().eq(McMsgTemplateEntity::getEnabledMark, (Object)pagination.getEnabledMark());
        }
        if (StringUtils.isNotEmpty((String)pagination.getKeyword())) {
            ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().like(McMsgTemplateEntity::getFullName, (Object)pagination.getKeyword())).or()).like(McMsgTemplateEntity::getEnCode, (Object)pagination.getKeyword());
        }
        if (StringUtils.isNotEmpty((String)pagination.getFullName())) {
            queryWrapper.lambda().like(McMsgTemplateEntity::getFullName, (Object)pagination.getFullName());
        }
        if (StringUtils.isNotEmpty((String)pagination.getEnCode())) {
            queryWrapper.lambda().like(McMsgTemplateEntity::getEnCode, (Object)pagination.getEnCode());
        }
        if (StringUtils.isNotEmpty((String)pagination.getSubscriberType())) {
            queryWrapper.lambda().eq(McMsgTemplateEntity::getSubscriberType, (Object)pagination.getSubscriberType());
        }
        if (AllIdList.size() > 0) {
            queryWrapper.lambda().in(McMsgTemplateEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)pagination.getSidx())) {
            queryWrapper.lambda().orderByAsc(McMsgTemplateEntity::getSortCode);
        } else {
            try {
                String sidx = pagination.getSidx();
                Field declaredField = McMsgTemplateEntity.class.getDeclaredField(sidx);
                String value = declaredField.getAnnotation(TableField.class).value();
                queryWrapper = "asc".equals(pagination.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)value) : (QueryWrapper)queryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)queryWrapper);
            return pagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return pagination.setData(list, list.size());
    }

    @Override
    public List<McMsgTemplateEntity> getTypeList(McMsgTemplatePagination pagination, String dataType) {
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)pagination.getTemplateType())) {
            queryWrapper.lambda().eq(McMsgTemplateEntity::getTemplateType, (Object)pagination.getTemplateType());
        }
        if (StringUtils.isNotEmpty((String)pagination.getMessageType())) {
            queryWrapper.lambda().eq(McMsgTemplateEntity::getMessageType, (Object)pagination.getMessageType());
        }
        if (StringUtils.isNotEmpty((String)pagination.getMessageSource())) {
            queryWrapper.lambda().eq(McMsgTemplateEntity::getMessageSource, (Object)pagination.getMessageSource());
        }
        if (StringUtils.isNotEmpty((String)pagination.getFullName())) {
            queryWrapper.lambda().like(McMsgTemplateEntity::getFullName, (Object)pagination.getFullName());
        }
        if (StringUtils.isNotEmpty((String)pagination.getEnCode())) {
            queryWrapper.lambda().like(McMsgTemplateEntity::getEnCode, (Object)pagination.getEnCode());
        }
        if (StringUtils.isNotEmpty((String)pagination.getSubscriberType())) {
            queryWrapper.lambda().eq(McMsgTemplateEntity::getSubscriberType, (Object)pagination.getSubscriberType());
        }
        if (AllIdList.size() > 0) {
            queryWrapper.lambda().in(McMsgTemplateEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)pagination.getSidx())) {
            queryWrapper.lambda().orderByAsc(McMsgTemplateEntity::getSortCode);
        } else {
            try {
                String sidx = pagination.getSidx();
                Field declaredField = McMsgTemplateEntity.class.getDeclaredField(sidx);
                String value = declaredField.getAnnotation(TableField.class).value();
                queryWrapper = "asc".equals(pagination.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)value) : (QueryWrapper)queryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)queryWrapper);
                return pagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return pagination.setData(list, list.size());
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<McMsgTemplateEntity> getInfoByCode(String enCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(McMsgTemplateEntity::getMessageSource, (Object)enCode);
        queryWrapper.lambda().eq(McMsgTemplateEntity::getEnabledMark, (Object)EnabledMarkEnum.ENABLE.getCode());
        queryWrapper.lambda().orderByAsc(McMsgTemplateEntity::getEnCode);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public McMsgTemplateEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(McMsgTemplateEntity::getId, (Object)id);
        return (McMsgTemplateEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public void create(McMsgTemplateCrForm mcMsgTemplateCrForm) {
        McMsgTemplateEntity entity = (McMsgTemplateEntity)JsonUtil.getJsonToBean((Object)mcMsgTemplateCrForm, McMsgTemplateEntity.class);
        String mainId = RandomUtil.uuId();
        entity.setId(mainId);
        this.save(entity);
        List fieldList = JsonUtil.getJsonToList(mcMsgTemplateCrForm.getFieldList(), McMsgTemplateFieldEntity.class);
        for (McMsgTemplateFieldEntity entitys : fieldList) {
            entitys.setId(RandomUtil.uuId());
            entitys.setTemplateId(entity.getId());
            this.mcMsgTemplateFieldService.save(entitys);
        }
    }

    @Override
    @DSTransactional
    public boolean update(String id, McMsgTemplateUpForm mcMsgTemplateUpForm) {
        McMsgTemplateEntity entity = (McMsgTemplateEntity)JsonUtil.getJsonToBean((Object)mcMsgTemplateUpForm, McMsgTemplateEntity.class);
        entity.setId(id);
        QueryWrapper fieldQueryWrapper = new QueryWrapper();
        fieldQueryWrapper.lambda().eq(McMsgTemplateFieldEntity::getTemplateId, (Object)entity.getId());
        this.mcMsgTemplateFieldService.remove((Wrapper)fieldQueryWrapper);
        List fieldList = JsonUtil.getJsonToList(mcMsgTemplateUpForm.getFieldList(), McMsgTemplateFieldEntity.class);
        for (McMsgTemplateFieldEntity entitys : fieldList) {
            entitys.setId(RandomUtil.uuId());
            entitys.setTemplateId(entity.getId());
            this.mcMsgTemplateFieldService.save(entitys);
        }
        return this.updateById(entity);
    }

    @Override
    @DSTransactional
    public void delete(McMsgTemplateEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
            QueryWrapper fieldQueryWrapper = new QueryWrapper();
            fieldQueryWrapper.lambda().eq(McMsgTemplateFieldEntity::getTemplateId, (Object)entity.getId());
            this.mcMsgTemplateFieldService.remove((Wrapper)fieldQueryWrapper);
        }
    }

    @Override
    public List<McMsgTemplateFieldEntity> getMcMsgTemplateFieldList(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(McMsgTemplateFieldEntity::getTemplateId, (Object)id);
        return this.mcMsgTemplateFieldService.list((Wrapper)queryWrapper);
    }

    @Override
    public boolean checkEnCodeUnique(String enCode, String id) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(McMsgTemplateEntity::getEnCode, (Object)enCode);
        queryWrapper.last("limit 1");
        McMsgTemplateEntity entity = (McMsgTemplateEntity)this.getOne((Wrapper)queryWrapper);
        return !ObjectUtil.isNotNull((Object)entity) || !StringUtils.isEmpty((String)id) && entity.getId().equals(id);
    }

    @Override
    public boolean checkFullNameUnique(String fullName, String id) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(McMsgTemplateEntity::getFullName, (Object)fullName);
        queryWrapper.last("limit 1");
        McMsgTemplateEntity entity = (McMsgTemplateEntity)this.getOne((Wrapper)queryWrapper);
        return !ObjectUtil.isNotNull((Object)entity) || !StringUtils.isEmpty((String)id) && entity.getId().equals(id);
    }

    @Override
    public long getCountByMessageSource(String messageSource) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(McMsgTemplateEntity::getMessageSource, (Object)messageSource);
        return this.count((Wrapper)queryWrapper);
    }
}

