/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgcenter.service.strategy.impl;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.WxMaSubscribeMessage;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.external.config.mutil.WxMaConfiguration;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.msgcenter.entity.McMsgAccountEntity;
import com.bringspring.system.msgcenter.entity.McMsgTemplateEntity;
import com.bringspring.system.msgcenter.entity.McTaskMsgContentEntity;
import com.bringspring.system.msgcenter.entity.McTaskMsgReceiveEntity;
import com.bringspring.system.msgcenter.enums.ChannelTypeEnum;
import com.bringspring.system.msgcenter.enums.EnabledMarkEnum;
import com.bringspring.system.msgcenter.enums.ToTypeEnum;
import com.bringspring.system.msgcenter.model.mcmsgsendtemplate.McMsgSendTemplateModel;
import com.bringspring.system.msgcenter.model.mcwxtemplate.McWxSendResult;
import com.bringspring.system.msgcenter.service.context.SendMessageContext;
import com.bringspring.system.msgcenter.service.strategy.AbstractMessageSender;
import com.bringspring.system.msgcenter.util.BlacklistUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.chanjar.weixin.common.error.WxErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MsgToWxMiniappService
extends AbstractMessageSender {
    private static final Logger log = LoggerFactory.getLogger(MsgToWxMiniappService.class);
    private final WxMaConfiguration wxMaConfiguration;
    private WxMaService wxMaService;
    private String programState = "formal";

    public MsgToWxMiniappService(WxMaConfiguration wxMaConfiguration) {
        this.wxMaConfiguration = wxMaConfiguration;
    }

    @Override
    protected int getBatchSize() {
        return 1000;
    }

    @Override
    public ChannelTypeEnum getChannelType() {
        return ChannelTypeEnum.WX_MINIAPP;
    }

    @Override
    protected void validateParameters(SendMessageContext context) {
        this.validateTemplate(context);
        this.validateAccount(context);
    }

    @Override
    protected void doSend(SendMessageContext context) {
        if (CollectionUtil.isNotEmpty(context.getValidList())) {
            List<McTaskMsgReceiveEntity> receiveList = context.getValidList();
            McMsgAccountEntity account = context.getMsgAccount();
            this.programState = account.getProgramState();
            String appId = account.getAppId();
            this.wxMaService = this.wxMaConfiguration.getWxMaService(appId);
            McMsgTemplateEntity templateInfo = context.getTemplateInfo();
            String templateCode = templateInfo.getTemplateCode();
            McTaskMsgContentEntity taskMsgContent = context.getTaskMsgContent();
            ArrayList<WxMaSubscribeMessage.MsgData> msgDataList = new ArrayList<WxMaSubscribeMessage.MsgData>();
            if (StringUtils.isNotEmpty((String)taskMsgContent.getContent())) {
                Map map = (Map)JSONObject.parseObject((String)taskMsgContent.getContent(), Map.class);
                for (Map.Entry entry : map.entrySet()) {
                    msgDataList.add(new WxMaSubscribeMessage.MsgData((String)entry.getKey(), (String)entry.getValue()));
                }
            }
            String toType = context.getToType();
            Map<String, SynThirdInfoEntity> thirdInfoMap = context.getThirdInfoMap();
            ArrayList<McTaskMsgReceiveEntity> validList = new ArrayList<McTaskMsgReceiveEntity>();
            ArrayList<McTaskMsgReceiveEntity> invalidList = new ArrayList<McTaskMsgReceiveEntity>();
            for (McTaskMsgReceiveEntity receiveEntity : receiveList) {
                String opneid = receiveEntity.getReceiveUserId();
                if (!ToTypeEnum.NON_USER.getCode().equals(toType)) {
                    opneid = thirdInfoMap.get(opneid).getThirdObjectId();
                }
                WxMaSubscribeMessage wxMaSubscribeMessage = WxMaSubscribeMessage.builder().toUser(opneid).templateId(templateCode).data(msgDataList).page(taskMsgContent.getLinkUrl()).miniprogramState(this.programState).build();
                try {
                    this.wxMaService.getSubscribeService().sendSubscribeMsg(wxMaSubscribeMessage);
                    receiveEntity.setEnabledMark(EnabledMarkEnum.SUCCESS.getCode());
                    validList.add(receiveEntity);
                }
                catch (WxErrorException e) {
                    e.printStackTrace();
                    receiveEntity.setEnabledMark(EnabledMarkEnum.FAIL.getCode());
                    receiveEntity.setDescription(e.getMessage());
                    invalidList.add(receiveEntity);
                }
            }
            context.getInvalidList().addAll(invalidList);
            context.setValidList(validList);
        }
    }

    @Override
    protected void sendBatchNonSystemUser(boolean isAgain, McMsgSendTemplateModel sendTemplate, McTaskMsgContentEntity taskMsgContent, List<McTaskMsgReceiveEntity> receiveListS, UserInfo currentUserInfo) {
        if (ObjectUtil.isEmpty((Object)taskMsgContent) || CollectionUtil.isEmpty(receiveListS)) {
            log.error("~\u00b7~\u00b7~\u00b7~\u8c03\u7528\u4e86 \u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u6d88\u606f\u3010\u975e\u7cfb\u7edf\u7528\u6237\u3011\u4e0b\u53d1\uff0c\u4f46message info\u4e3a\u7a7a \u6216 \u63a5\u6536\u4eba\u5217\u8868\u4e3a\u7a7a~\u00b7~\u00b7~\u00b7~");
        }
        List receiveList = JsonUtil.getJsonToList(receiveListS, McTaskMsgReceiveEntity.class);
        McMsgTemplateEntity templateInfo = this.mcMsgTemplateService.getInfo(sendTemplate.getTemplateId());
        McMsgAccountEntity msgAccount = this.mcMsgAccountService.getInfo(sendTemplate.getAccountConfigId());
        if (ObjectUtil.isNotNull((Object)templateInfo) && ObjectUtil.isNotNull((Object)msgAccount)) {
            List<String> openidList;
            String appId = msgAccount.getAppId();
            this.wxMaService = this.wxMaConfiguration.getWxMaService(appId);
            McMsgAccountEntity account = this.wxMaConfiguration.getAccount(appId);
            if (ObjectUtil.isNotNull((Object)account) && StringUtils.isNotEmpty((String)account.getProgramState())) {
                this.programState = account.getProgramState();
            }
            String templateCode = templateInfo.getTemplateCode();
            if (CollectionUtil.isNotEmpty((Collection)receiveList) && CollectionUtil.isNotEmpty(openidList = receiveList.stream().map(r -> r.getReceiveUserId()).collect(Collectors.toList()))) {
                List<McWxSendResult> failList = this.postMessageSend(taskMsgContent, templateCode, openidList);
                if (CollectionUtil.isNotEmpty((Collection)receiveList)) {
                    String errMsg = isAgain ? "\u91cd\u53d1\u6210\u529f\uff1a" : "\u4e0b\u53d1\u6210\u529f\uff1a";
                    this.mcTaskMsgReceiveService.updateByList(isAgain, receiveList, 1, errMsg, currentUserInfo);
                }
                if (CollectionUtil.isNotEmpty(failList)) {
                    ArrayList updateBatch = new ArrayList();
                    for (McWxSendResult result : failList) {
                        String errMsg = isAgain ? "\u91cd\u53d1" : "\u4e0b\u53d1";
                        Integer errCode = result.getErrCode();
                        String description = errMsg + (errCode == 1 ? "\u6210\u529f\uff1a" : "\u5931\u8d25\uff1a") + result.getErrMsg();
                        String openid = result.getFailUser();
                        List receiveEntityList = receiveList.stream().filter(r -> openid.equals(r.getReceiveUserId())).collect(Collectors.toList());
                        if (!CollectionUtil.isNotEmpty(receiveEntityList)) continue;
                        for (McTaskMsgReceiveEntity receiveEntity : receiveEntityList) {
                            receiveEntity.setSendTime(new Date());
                            receiveEntity.setSendUserId(currentUserInfo.getUserId());
                            receiveEntity.setEnabledMark(errCode);
                            receiveEntity.setDescription(description);
                            if (ObjectUtil.isEmpty((Object)receiveEntity.getAutoAgainNum())) {
                                receiveEntity.setAutoAgainNum(0);
                                continue;
                            }
                            receiveEntity.setAutoAgainNum(receiveEntity.getAutoAgainNum() + 1);
                        }
                        updateBatch.addAll(receiveEntityList);
                    }
                    if (CollectionUtil.isNotEmpty(updateBatch)) {
                        this.mcTaskMsgReceiveService.updateBatchById(updateBatch);
                    }
                }
            }
        }
    }

    @Override
    protected void sendBatch(boolean isAgain, McMsgSendTemplateModel sendTemplate, McTaskMsgContentEntity taskMsgContent, List<McTaskMsgReceiveEntity> receiveListS, UserInfo currentUserInfo) {
        if (ObjectUtil.isEmpty((Object)taskMsgContent) || CollectionUtil.isEmpty(receiveListS)) {
            log.error("~\u00b7~\u00b7~\u00b7~\u8c03\u7528\u4e86 \u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u6d88\u606f\u4e0b\u53d1\uff0c\u4f46message info\u4e3a\u7a7a \u6216 \u63a5\u6536\u4eba\u5217\u8868\u4e3a\u7a7a~\u00b7~\u00b7~\u00b7~");
        }
        List receiveList = JsonUtil.getJsonToList(receiveListS, McTaskMsgReceiveEntity.class);
        McMsgTemplateEntity templateInfo = this.mcMsgTemplateService.getInfo(sendTemplate.getTemplateId());
        McMsgAccountEntity msgAccount = this.mcMsgAccountService.getInfo(sendTemplate.getAccountConfigId());
        if (ObjectUtil.isNotNull((Object)templateInfo) && ObjectUtil.isNotNull((Object)msgAccount)) {
            String appId = msgAccount.getAppId();
            this.wxMaService = this.wxMaConfiguration.getWxMaService(appId);
            McMsgAccountEntity account = this.wxMaConfiguration.getAccount(appId);
            if (ObjectUtil.isNotNull((Object)account) && StringUtils.isNotEmpty((String)account.getProgramState())) {
                this.programState = account.getProgramState();
            }
            String templateCode = templateInfo.getTemplateCode();
            List<McTaskMsgReceiveEntity> receiveBlacklist = BlacklistUtil.receiveListFilter(receiveList);
            if (CollectionUtil.isNotEmpty((Collection)receiveList)) {
                List<McTaskMsgReceiveEntity> thirdNullList = receiveList.stream().filter(r -> StringUtils.isEmpty((String)r.getReceiveUserId())).collect(Collectors.toList());
                List thirdNotNullList = receiveList.stream().filter(r -> StringUtils.isNotEmpty((String)r.getReceiveUserId())).collect(Collectors.toList());
                List thirdInfoIds = thirdNotNullList.stream().map(r -> r.getReceiveUserId()).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(thirdInfoIds)) {
                    List<McWxSendResult> failList;
                    List thirdInfoList = this.synThirdInfoService.listByIds(thirdInfoIds);
                    List thirdUseridNullList = thirdInfoList.stream().filter(r -> StringUtils.isEmpty((String)r.getThirdObjectId())).collect(Collectors.toList());
                    List<McTaskMsgReceiveEntity> useridNullList = thirdNotNullList.stream().filter(r -> thirdUseridNullList.stream().map(e -> e.getId()).collect(Collectors.toList()).contains(r.getReceiveUserId())).collect(Collectors.toList());
                    List<SynThirdInfoEntity> thirdUseridNotNullList = thirdInfoList.stream().filter(r -> StringUtils.isNotEmpty((String)r.getThirdObjectId())).collect(Collectors.toList());
                    List<McTaskMsgReceiveEntity> useridNotNullList = thirdNotNullList.stream().filter(r -> thirdUseridNotNullList.stream().map(e -> e.getId()).collect(Collectors.toList()).contains(r.getReceiveUserId())).collect(Collectors.toList());
                    List<String> openidList = thirdUseridNotNullList.stream().map(r -> r.getThirdObjectId()).collect(Collectors.toList());
                    if (CollectionUtil.isNotEmpty(openidList) && CollectionUtil.isNotEmpty(failList = this.postMessageSend(taskMsgContent, templateCode, openidList))) {
                        this.wxMiniappSendMessageResult(isAgain, taskMsgContent, useridNotNullList, thirdUseridNotNullList, failList, currentUserInfo);
                    }
                    if (CollectionUtil.isNotEmpty(useridNullList)) {
                        String errMsg = (isAgain ? "\u91cd\u53d1\u5931\u8d25\uff1a" : "\u4e0b\u53d1\u5931\u8d25\uff1a") + "third\u65e0userid";
                        this.mcTaskMsgReceiveService.updateByList(isAgain, useridNullList, 2, errMsg, currentUserInfo);
                    }
                }
                if (CollectionUtil.isNotEmpty(thirdNullList)) {
                    String errMsg = (isAgain ? "\u91cd\u53d1\u5931\u8d25\uff1a" : "\u4e0b\u53d1\u5931\u8d25\uff1a") + "\u65e0third\u7ed1\u5b9a\u6570\u636e";
                    this.mcTaskMsgReceiveService.updateByList(isAgain, thirdNullList, 2, errMsg, currentUserInfo);
                }
            }
            if (CollectionUtil.isNotEmpty(receiveBlacklist)) {
                this.mcTaskMsgReceiveService.updateBlacklist(receiveBlacklist, currentUserInfo);
            }
        }
    }

    public List<McWxSendResult> postMessageSend(McTaskMsgContentEntity taskMsgContent, String templateCode, List<String> openidList) {
        if (ObjectUtil.isEmpty((Object)taskMsgContent) || StringUtils.isEmpty((String)templateCode) || CollectionUtil.isEmpty(openidList)) {
            log.error("~\u00b7~\u00b7~\u00b7~\u6267\u884c \u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u5e94\u7528\u6d88\u606fpost\u4e0b\u53d1\uff0c\u4f46message info \u6216 templateCode \u6216 openidList\u4e3a\u7a7a~\u00b7~\u00b7~\u00b7~");
        }
        ArrayList<WxMaSubscribeMessage.MsgData> msgDataList = new ArrayList<WxMaSubscribeMessage.MsgData>();
        if (StringUtils.isNotEmpty((String)taskMsgContent.getContent())) {
            Map map = (Map)JSONObject.parseObject((String)taskMsgContent.getContent(), Map.class);
            for (Map.Entry entry : map.entrySet()) {
                msgDataList.add(new WxMaSubscribeMessage.MsgData((String)entry.getKey(), (String)entry.getValue()));
            }
        }
        ArrayList<McWxSendResult> failList = new ArrayList<McWxSendResult>();
        for (String string : openidList) {
            WxMaSubscribeMessage wxMaSubscribeMessage = WxMaSubscribeMessage.builder().toUser(string).templateId(templateCode).data(msgDataList).page(taskMsgContent.getLinkUrl()).miniprogramState(this.programState).build();
            McWxSendResult mcWxSendResult = new McWxSendResult();
            try {
                this.wxMaService.getSubscribeService().sendSubscribeMsg(wxMaSubscribeMessage);
                mcWxSendResult.setErrCode(1);
                mcWxSendResult.setFailUser(string);
            }
            catch (WxErrorException e) {
                e.printStackTrace();
                mcWxSendResult.setErrCode(2);
                mcWxSendResult.setErrMsg(e.getMessage());
                mcWxSendResult.setFailUser(string);
            }
            failList.add(mcWxSendResult);
        }
        return failList;
    }

    public void wxMiniappSendMessageResult(boolean isAgain, McTaskMsgContentEntity taskMsgContent, List<McTaskMsgReceiveEntity> receiveList, List<SynThirdInfoEntity> thirdInfoList, List<McWxSendResult> failList, UserInfo currentUserInfo) {
        if (CollectionUtil.isNotEmpty(receiveList)) {
            String errMsg = isAgain ? "\u91cd\u53d1\u6210\u529f\uff1a" : "\u4e0b\u53d1\u6210\u529f\uff1a";
            this.mcTaskMsgReceiveService.updateByList(isAgain, receiveList, 1, errMsg, currentUserInfo);
        }
        if (CollectionUtil.isNotEmpty(failList)) {
            ArrayList updateBatch = new ArrayList();
            for (McWxSendResult result : failList) {
                List receiveEntityList;
                String errMsg = StringUtils.isEmpty((String)result.getErrMsg()) ? "" : result.getErrMsg();
                String openid = result.getFailUser();
                List thirdInfo = thirdInfoList.stream().filter(r -> openid.equals(r.getThirdObjectId())).collect(Collectors.toList());
                if (!CollectionUtil.isNotEmpty(thirdInfo) || !CollectionUtil.isNotEmpty(receiveEntityList = receiveList.stream().filter(r -> thirdInfo.stream().map(e -> e.getId()).collect(Collectors.toList()).contains(r.getReceiveUserId())).collect(Collectors.toList()))) continue;
                if (!isAgain) {
                    receiveEntityList.stream().forEach(s -> {
                        s.setSendTime(new Date());
                        s.setSendUserId(currentUserInfo.getUserId());
                        s.setEnabledMark(result.getErrCode());
                        s.setDescription((result.getErrCode() == 1 ? "\u4e0b\u53d1\u6210\u529f\uff1a" : "\u4e0b\u53d1\u5931\u8d25\uff1a") + errMsg);
                        s.setAutoAgainNum(0);
                    });
                } else {
                    receiveEntityList.stream().forEach(s -> {
                        s.setAgainTime(new Date());
                        s.setAgainUserId(currentUserInfo.getUserId());
                        s.setEnabledMark(result.getErrCode());
                        s.setDescription((result.getErrCode() == 1 ? "\u91cd\u53d1\u6210\u529f\uff1a" : "\u91cd\u53d1\u5931\u8d25\uff1a") + errMsg);
                        if (ObjectUtil.isEmpty((Object)s.getAutoAgainNum())) {
                            s.setAutoAgainNum(0);
                        } else {
                            s.setAutoAgainNum(s.getAutoAgainNum() + 1);
                        }
                    });
                }
                updateBatch.addAll(receiveEntityList);
            }
            if (CollectionUtil.isNotEmpty(updateBatch)) {
                this.mcTaskMsgReceiveService.updateBatchById(updateBatch);
            }
        }
    }
}

