/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.permission.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.base.exception.ExcelValidationException;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.PermissionEntityBase;
import com.bringspring.system.permission.model.organize.OrganizeImportModel;
import com.bringspring.system.permission.model.organize.OrganizeImportVO;
import com.bringspring.system.permission.service.OrganizeImportService;
import com.bringspring.system.permission.service.OrganizeService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;

@Service
public class OrganizeImportServiceImpl
implements OrganizeImportService {
    private static final Logger log = LoggerFactory.getLogger(OrganizeImportServiceImpl.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OrganizeService organizeService;

    @Override
    public Map<String, Object> importPreview(List<OrganizeImportModel> organizeList) {
        ArrayList dataRow = new ArrayList();
        ArrayList columns = new ArrayList();
        if (organizeList != null) {
            for (OrganizeImportModel model : organizeList) {
                HashMap<String, Object> dataRowMap = new HashMap<String, Object>();
                dataRowMap.put("parentId", model.getParentId());
                dataRowMap.put("organizeId", model.getOrganizeId());
                dataRowMap.put("category", model.getCategory());
                dataRowMap.put("fullName", model.getFullName());
                dataRowMap.put("enCode", model.getEnCode());
                dataRowMap.put("sortCode", model.getSortCode());
                dataRowMap.put("description", model.getDescription());
                dataRow.add(dataRowMap);
            }
            String[] columnNames = new String[]{"\u4e0a\u7ea7\u7ec4\u7ec7", "\u76f4\u5c5e\u7ec4\u7ec7", "\u7ec4\u7ec7\u7c7b\u578b", "\u7ec4\u7ec7\u540d\u79f0", "\u7ec4\u7ec7\u7f16\u7801", "\u6392\u5e8f", "\u8bf4\u660e"};
            for (int i = 0; i < columnNames.length; ++i) {
                HashMap<String, Object> columnsMap = new HashMap<String, Object>();
                columnsMap.put("AllowDBNull", true);
                columnsMap.put("Caption", columnNames[i]);
                columnsMap.put("ColumnName", columnNames[i]);
                columnsMap.put("DataType", "System.String, mscorlib, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b77a5c561934e089");
                columns.add(columnsMap);
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataRow", dataRow);
        map.put("columns", columns);
        return map;
    }

    @Override
    @DSTransactional
    @CacheEvict(value={"OrganizeCache"}, allEntries=true)
    public OrganizeImportVO importData(List<OrganizeImportModel> dataList, String menuId) throws Exception {
        UserInfo userInfo = this.userProvider.get();
        dataList.forEach(OrganizeImportModel::parseParentInfo);
        List allOrganizes = this.organizeService.list();
        HashMap<String, OrganizeEntity> existingOrganizeByCode = new HashMap<String, OrganizeEntity>();
        allOrganizes.forEach(org -> existingOrganizeByCode.put(org.getEnCode(), (OrganizeEntity)org));
        Map<String, String> organizeCodeToIdMap = allOrganizes.stream().collect(Collectors.toMap(PermissionEntityBase::getEnCode, OrganizeEntity::getId));
        Map<Integer, List<OrganizeImportModel>> organizedData = this.organizeByLevel(dataList, existingOrganizeByCode, organizeCodeToIdMap);
        int successCount = 0;
        int failCount = 0;
        ArrayList<OrganizeImportModel> errorList = new ArrayList<OrganizeImportModel>();
        for (int level = 0; level < organizedData.size(); ++level) {
            List<OrganizeImportModel> levelData = organizedData.get(level);
            if (levelData == null) continue;
            for (OrganizeImportModel model : levelData) {
                try {
                    this.validateOrganizeData(model, existingOrganizeByCode, organizeCodeToIdMap);
                    OrganizeEntity entity = this.processOrganizeEntity(model, userInfo, existingOrganizeByCode, organizeCodeToIdMap);
                    existingOrganizeByCode.put(entity.getEnCode(), entity);
                    organizeCodeToIdMap.put(entity.getEnCode(), entity.getId());
                    ++successCount;
                }
                catch (ExcelValidationException e) {
                    this.handleImportError(model, e, errorList);
                    ++failCount;
                }
            }
        }
        if (successCount > 0) {
            try {
                this.batchUpdateOrganizeIdTree(existingOrganizeByCode);
            }
            catch (Exception e) {
                log.error("\u6279\u91cf\u66f4\u65b0organizeIdTree\u5931\u8d25", (Throwable)e);
            }
        }
        return this.buildImportResult(successCount, failCount, errorList);
    }

    private Map<Integer, List<OrganizeImportModel>> organizeByLevel(List<OrganizeImportModel> dataList, Map<String, OrganizeEntity> existingOrganizeByCode, Map<String, String> organizeCodeToIdMap) {
        HashMap<Integer, List<OrganizeImportModel>> result = new HashMap<Integer, List<OrganizeImportModel>>();
        List<OrganizeImportModel> rootLevel = dataList.stream().filter(org -> StringUtils.isEmpty((String)org.getParentId())).collect(Collectors.toList());
        result.put(0, rootLevel);
        int currentLevel = 0;
        HashSet<String> processedCodes = new HashSet<String>();
        rootLevel.forEach(org -> {
            if (existingOrganizeByCode.containsKey(org.getEnCode())) {
                processedCodes.add(org.getEnCode());
            }
        });
        ArrayList<OrganizeImportModel> remaining = new ArrayList<OrganizeImportModel>(dataList);
        remaining.removeAll(rootLevel);
        while (!remaining.isEmpty()) {
            ++currentLevel;
            ArrayList<OrganizeImportModel> currentLevelData = new ArrayList<OrganizeImportModel>();
            Iterator iterator = remaining.iterator();
            while (iterator.hasNext()) {
                OrganizeImportModel model = (OrganizeImportModel)iterator.next();
                if (!this.isParentProcessed(model, processedCodes, existingOrganizeByCode, organizeCodeToIdMap)) continue;
                currentLevelData.add(model);
                iterator.remove();
                processedCodes.add(model.getEnCode());
            }
            if (currentLevelData.isEmpty()) {
                for (OrganizeImportModel model : remaining) {
                    model.setErrorMessage("\u4e0a\u7ea7\u7ec4\u7ec7\u4e0d\u5b58\u5728: " + model.getParentId());
                    currentLevelData.add(model);
                }
                result.put(currentLevel, currentLevelData);
                break;
            }
            result.put(currentLevel, currentLevelData);
            if (currentLevel <= 50) continue;
            for (OrganizeImportModel model : remaining) {
                model.setErrorMessage("\u4e0a\u7ea7\u7ec4\u7ec7\u4e0d\u5b58\u5728\u6216\u5b58\u5728\u5faa\u73af\u4f9d\u8d56: " + model.getParentId());
                currentLevelData.add(model);
            }
        }
        return result;
    }

    private boolean isParentProcessed(OrganizeImportModel model, Set<String> processedCodes, Map<String, OrganizeEntity> existingOrganizeByCode, Map<String, String> organizeCodeToIdMap) {
        if (StringUtils.isEmpty((String)model.getParentId())) {
            return true;
        }
        if (StringUtils.isNotEmpty((String)model.getParentEnCode())) {
            if (processedCodes.contains(model.getParentEnCode())) {
                return true;
            }
            if (organizeCodeToIdMap.containsKey(model.getParentEnCode())) {
                return true;
            }
        }
        if (StringUtils.isNotEmpty((String)model.getParentName())) {
            // empty if block
        }
        return false;
    }

    private OrganizeEntity processOrganizeEntity(OrganizeImportModel model, UserInfo userInfo, Map<String, OrganizeEntity> existingOrganizeByCode, Map<String, String> organizeCodeToIdMap) {
        OrganizeEntity entity;
        boolean isUpdate = false;
        if (existingOrganizeByCode.containsKey(model.getEnCode())) {
            entity = existingOrganizeByCode.get(model.getEnCode());
            isUpdate = true;
        } else {
            entity = new OrganizeEntity();
            entity.setId(RandomUtil.uuId());
            entity.setCreatorUserId(userInfo.getUserId());
            entity.setCreatorTime(new Date());
        }
        entity.setFullName(model.getFullName());
        entity.setShortName(model.getFullName());
        entity.setEnCode(model.getEnCode());
        entity.setCategory(this.getCategoryMap().get(model.getCategory()));
        entity.setSortCode(model.getSortCode() != null ? model.getSortCode() : 0L);
        entity.setDescription(model.getDescription());
        entity.setEnabledMark(1);
        entity.setDeleteMark(0);
        String newParentId = this.determineParentId(model, existingOrganizeByCode, organizeCodeToIdMap);
        entity.setParentId(newParentId);
        String organizeId = this.determineParentIdWithDirectOrganize(model, existingOrganizeByCode, organizeCodeToIdMap);
        entity.setOrganizeId(organizeId);
        if (isUpdate) {
            entity.setLastModifyUserId(userInfo.getUserId());
            entity.setLastModifyTime(new Date());
            this.organizeService.updateById(entity);
        } else {
            this.organizeService.save(entity);
        }
        return entity;
    }

    private String determineParentIdWithDirectOrganize(OrganizeImportModel model, Map<String, OrganizeEntity> existingOrganizeByCode, Map<String, String> organizeCodeToIdMap) {
        if (StringUtils.isEmpty((String)model.getOrganizeId())) {
            return "1";
        }
        if (StringUtils.isNotEmpty((String)model.getDirectOrganizeEnCode())) {
            if (existingOrganizeByCode.containsKey(model.getDirectOrganizeEnCode())) {
                return existingOrganizeByCode.get(model.getDirectOrganizeEnCode()).getId();
            }
            if (organizeCodeToIdMap.containsKey(model.getDirectOrganizeEnCode())) {
                return organizeCodeToIdMap.get(model.getDirectOrganizeEnCode());
            }
        }
        if (StringUtils.isNotEmpty((String)model.getDirectOrganizeName())) {
            // empty if block
        }
        throw new ExcelValidationException("\u65e0\u6cd5\u627e\u5230\u76f4\u5c5e\u7ec4\u7ec7: " + model.getOrganizeId());
    }

    private String determineParentId(OrganizeImportModel model, Map<String, OrganizeEntity> existingOrganizeByCode, Map<String, String> organizeCodeToIdMap) {
        if (StringUtils.isEmpty((String)model.getParentId())) {
            return "-1";
        }
        if (StringUtils.isNotEmpty((String)model.getParentEnCode())) {
            if (existingOrganizeByCode.containsKey(model.getParentEnCode())) {
                return existingOrganizeByCode.get(model.getParentEnCode()).getId();
            }
            if (organizeCodeToIdMap.containsKey(model.getParentEnCode())) {
                return organizeCodeToIdMap.get(model.getParentEnCode());
            }
        }
        if (StringUtils.isNotEmpty((String)model.getParentName())) {
            // empty if block
        }
        throw new ExcelValidationException("\u65e0\u6cd5\u627e\u5230\u4e0a\u7ea7\u7ec4\u7ec7: " + model.getParentId());
    }

    private void validateOrganizeData(OrganizeImportModel model, Map<String, OrganizeEntity> existingOrganizeByCode, Map<String, String> organizeCodeToIdMap) throws ExcelValidationException {
        HashMap<String, String> errorMessages = new HashMap<String, String>();
        String fullName = StringUtils.trim((String)model.getFullName());
        if (StringUtils.isEmpty((String)fullName)) {
            errorMessages.put("\u7ec4\u7ec7\u540d\u79f0", "\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            boolean nameExistsInSameParent = this.isNameExistsInSameParentByCode(fullName, model.getParentEnCode(), model.getEnCode(), existingOrganizeByCode);
            if (nameExistsInSameParent) {
                errorMessages.put("\u7ec4\u7ec7\u540d\u79f0", "\u540c\u4e00\u4e0a\u7ea7\u7ec4\u7ec7\u4e0b\u5df2\u5b58\u5728\u540c\u540d\u7ec4\u7ec7: " + fullName);
            }
        }
        String enCode = StringUtils.trim((String)model.getEnCode());
        if (StringUtils.isEmpty((String)enCode)) {
            errorMessages.put("\u7ec4\u7ec7\u7f16\u7801", "\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            boolean codeExists;
            boolean bl = codeExists = existingOrganizeByCode.containsKey(enCode) && !this.isSameOrganize(model, existingOrganizeByCode.get(enCode).getId(), existingOrganizeByCode);
            if (codeExists) {
                errorMessages.put("\u7ec4\u7ec7\u7f16\u7801", "\u7ec4\u7ec7\u7f16\u7801\u5df2\u5b58\u5728: " + enCode);
            }
        }
        String category = model.getCategory();
        if (StringUtils.isEmpty((String)category)) {
            errorMessages.put("\u7ec4\u7ec7\u7c7b\u578b", "\u4e0d\u80fd\u4e3a\u7a7a");
        } else if (!this.getCategoryMap().containsKey(category)) {
            errorMessages.put("\u7ec4\u7ec7\u7c7b\u578b", "\u7ec4\u7ec7\u7c7b\u578b\u4e0d\u5b58\u5728: " + category);
        }
        if (StringUtils.isNotEmpty((String)model.getOrganizeId())) {
            if (StringUtils.isNotEmpty((String)model.getDirectOrganizeEnCode())) {
                if (!existingOrganizeByCode.containsKey(model.getDirectOrganizeEnCode())) {
                    errorMessages.put("\u76f4\u5c5e\u7ec4\u7ec7", "\u76f4\u5c5e\u7ec4\u7ec7\u4e0d\u5b58\u5728: " + model.getOrganizeId());
                }
            } else {
                boolean directOrganizeExists = existingOrganizeByCode.values().stream().anyMatch(org -> org.getFullName().equals(model.getDirectOrganizeName()));
                if (!directOrganizeExists) {
                    errorMessages.put("\u76f4\u5c5e\u7ec4\u7ec7", "\u76f4\u5c5e\u7ec4\u7ec7\u4e0d\u5b58\u5728: " + model.getOrganizeId());
                }
            }
        }
        if (!errorMessages.isEmpty()) {
            throw new ExcelValidationException(errorMessages);
        }
    }

    private boolean isNameExistsInSameParentByCode(String fullName, String parentEnCode, String currentEnCode, Map<String, OrganizeEntity> existingOrganizeByCode) {
        ArrayList<OrganizeEntity> allOrganizes = new ArrayList<OrganizeEntity>(existingOrganizeByCode.values());
        for (OrganizeEntity existing : allOrganizes) {
            String existingParentEnCode;
            if (existing.getEnCode().equals(currentEnCode) || !existing.getFullName().equals(fullName) || !this.isSameParent(parentEnCode, existingParentEnCode = this.getParentEnCode(existing, existingOrganizeByCode))) continue;
            return true;
        }
        return false;
    }

    private String getParentEnCode(OrganizeEntity organize, Map<String, OrganizeEntity> existingOrganizeByCode) {
        if (organize.getParentId() == null || "-1".equals(organize.getParentId())) {
            return null;
        }
        for (OrganizeEntity parent : existingOrganizeByCode.values()) {
            if (!parent.getId().equals(organize.getParentId())) continue;
            return parent.getEnCode();
        }
        return null;
    }

    private boolean isSameParent(String parentEnCode1, String parentEnCode2) {
        if (parentEnCode1 == null && parentEnCode2 == null) {
            return true;
        }
        if (parentEnCode1 == null || parentEnCode2 == null) {
            return false;
        }
        return parentEnCode1.equals(parentEnCode2);
    }

    private boolean isSameOrganize(OrganizeImportModel model, String organizeId, Map<String, OrganizeEntity> existingOrganizeByCode) {
        if (!existingOrganizeByCode.containsKey(model.getEnCode())) {
            return false;
        }
        OrganizeEntity existing = existingOrganizeByCode.get(model.getEnCode());
        return existing.getId().equals(organizeId);
    }

    private OrganizeImportVO buildImportResult(int successCount, int failCount, List<OrganizeImportModel> errorList) {
        OrganizeImportVO vo = new OrganizeImportVO();
        vo.setSnum(successCount);
        vo.setFnum(failCount);
        vo.setResultType(failCount > 0 ? 1 : 0);
        vo.setFailResult(errorList);
        return vo;
    }

    private Map<String, String> getCategoryMap() {
        HashMap<String, String> categoryMap = new HashMap<String, String>();
        categoryMap.put("\u516c\u53f8", "company");
        categoryMap.put("\u90e8\u95e8", "department");
        categoryMap.put("\u96c6\u56e2", "company");
        categoryMap.put("\u5b50\u516c\u53f8", "company");
        categoryMap.put("\u673a\u6784", "department");
        categoryMap.put("\u673a\u5173", "department");
        categoryMap.put("\u5355\u4f4d", "department");
        return categoryMap;
    }

    private void handleImportError(OrganizeImportModel model, ExcelValidationException e, List<OrganizeImportModel> errorList) {
        StringBuilder errorMsg = new StringBuilder();
        if (e.getErrorMessages() != null && !e.getErrorMessages().isEmpty()) {
            int index = 0;
            int size = e.getErrorMessages().size();
            for (Map.Entry<String, String> error : e.getErrorMessages().entrySet()) {
                errorMsg.append(error.getKey()).append(": ").append(error.getValue());
                if (index != size - 1) {
                    errorMsg.append("; ");
                }
                ++index;
            }
        } else {
            errorMsg.append(e.getMessage());
        }
        model.setErrorMessage(errorMsg.toString());
        errorList.add(model);
    }

    private void batchUpdateOrganizeIdTree(Map<String, OrganizeEntity> existingOrganizeByCode) {
        boolean hasChanges;
        if (existingOrganizeByCode.isEmpty()) {
            return;
        }
        Map idToEntityMap = existingOrganizeByCode.values().stream().collect(Collectors.toMap(OrganizeEntity::getId, Function.identity()));
        List rootOrganizes = existingOrganizeByCode.values().stream().filter(org -> org.getParentId() == null || "-1".equals(org.getParentId())).collect(Collectors.toList());
        for (OrganizeEntity root : rootOrganizes) {
            root.setOrganizeIdTree(root.getId());
        }
        int maxIterations = 50;
        int iteration = 0;
        do {
            hasChanges = false;
            ++iteration;
            for (OrganizeEntity entity : existingOrganizeByCode.values()) {
                String parentId = entity.getParentId();
                if (parentId == null || "-1".equals(parentId)) {
                    entity.setOrganizeIdTree(entity.getId());
                    hasChanges = true;
                    continue;
                }
                OrganizeEntity parent = (OrganizeEntity)idToEntityMap.get(parentId);
                if (parent == null || parent.getOrganizeIdTree() == null) continue;
                entity.setOrganizeIdTree(parent.getOrganizeIdTree() + "," + entity.getId());
                hasChanges = true;
            }
        } while (hasChanges && iteration < maxIterations);
        for (OrganizeEntity entity : existingOrganizeByCode.values()) {
            if (entity.getOrganizeIdTree() != null) continue;
            entity.setOrganizeIdTree(entity.getId());
        }
        List toUpdate = existingOrganizeByCode.values().stream().filter(org -> org.getOrganizeIdTree() != null).collect(Collectors.toList());
        if (!toUpdate.isEmpty()) {
            this.organizeService.updateBatchById(toUpdate);
        }
    }
}

