package com.bringspring.system.base.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 系统功能
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月27日 上午9:18
 */
@Data
@TableName("BASE_MODULE")
public class ModuleEntity implements Serializable {
    /**
     * 功能主键
     */
    @TableId("ID")
    private String id;

    /**
     * 功能上级
     */
    @TableField("PARENT_ID")
    private String parentId="0";
    /**
     * 所有功能上级
     * 示例：1,2,3
     */
    @TableField("PARENT_IDS")
    private String parentIds;

    /**
     * 功能类别
     */
    @TableField("TYPE")
    private Integer type;

    /**
     * 功能名称
     */
    @TableField("FULL_NAME")
    private String fullName;

    /**
     * 功能编码
     */
    @TableField("ENCODE")
    private String enCode;

    /**
     * 功能地址
     */
    @TableField("URL_ADDRESS")
    private String urlAddress;

    /**
     * 按钮权限
     */
    @TableField("IS_BUTTON_AUTHORIZE")
    private Integer isButtonAuthorize;

    /**
     * 列表权限
     */
    @TableField("IS_COLUMN_AUTHORIZE")
    private Integer isColumnAuthorize;

    /**
     * 数据权限
     */
    @TableField("IS_DATA_AUTHORIZE")
    private Integer isDataAuthorize;

    /**
     * 表单权限
     */
    @TableField("IS_FORM_AUTHORIZE")
    private Integer isFormAuthorize;

    /**
     * 扩展属性
     */
    @TableField("PROPERTY_JSON")
    private String propertyJson;

    /**
     * 描述
     */
    @TableField("DESCRIPTION")
    private String description;

    /**
     * 菜单图标
     */
    @TableField("ICON")
    private String icon;
    /**
     * 链接目标
     */
    @TableField("LINK_TARGET")
    private String linkTarget;
    /**
     * 菜单分类 Web、App
     */
    @TableField("CATEGORY")
    private String category;

    /**
     * 关联功能id
     */
    @TableField("MODULE_ID")
    private String moduleId;
    /**
     * 排序码
     */
    @TableField("SORT_CODE")
    private Long sortCode;

    /**
     * 有效标志
     */
    @TableField("ENABLED_MARK")
    private Integer enabledMark=0;

    /**
     * 创建时间
     */
    @TableField(value = "CREATOR_TIME",fill = FieldFill.INSERT)
    private Date creatorTime;

    /**
     * 创建用户
     */
    @TableField(value = "CREATOR_USER_ID",fill = FieldFill.INSERT)
    private String creatorUserId;

    /**
     * 修改时间
     */
    @TableField(value = "LAST_MODIFY_TIME",fill = FieldFill.UPDATE)
    private Date lastModifyTime;

    /**
     * 修改用户
     */
    @TableField(value = "LAST_MODIFY_USER_ID",fill = FieldFill.UPDATE)
    private String lastModifyUserId;

    /**
     * 删除标志
     */
    @TableField("DELETE_MARK")
    private Integer deleteMark;

    /**
     * 删除时间
     */
    @TableField("DELETE_TIME")
    private Date deleteTime;

    /**
     * 删除用户
     */
    @TableField("DELETE_USER_ID")
    private String deleteUserId;
}
