package com.bringspring.system.base.mapper;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.bringspring.system.base.entity.LogEntity;
import com.bringspring.system.base.model.BurialPoint.VisitVO;
import com.bringspring.system.base.model.logs.LoginUserStatistics;
import com.bringspring.system.base.model.logs.LoginUserStatisticsQuery;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;


/**
 * 系统日志
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月27日 上午9:18
 */
public interface LogMapper extends BaseMapper<LogEntity> {

    /**
     * 根据请求日志统计近30分钟内，每分钟上，访问请求所属用户的用户数量
     *
     * @return
     */
    List<Map<String, Object>> selectUserGroupByCreatorTime(@Param(Constants.WRAPPER) Wrapper ew);

    /**
     * 根据请求日志统计近30分钟内，每分钟上，访问请求所属模块的模块数量
     *
     * @return
     */
    List<Map<String, Object>> selectModuleGroupByCreatorTime(@Param(Constants.WRAPPER) Wrapper ew);

    /**
     * 根据请求日志统计近30分钟内，每分钟上，访问请求数量
     *
     * @return
     */
    List<Map<String, Object>> selectGroupByCreatorTime(@Param(Constants.WRAPPER) Wrapper ew);

    /**
     * 根据请求日志统计近30分钟内，功能模块的请求量
     *
     * @return
     */
    List<Map<String, Object>> selectGroupByModule(@Param(Constants.WRAPPER) Wrapper ew);

    /**
     * 埋点用户访问情况
     *
     * @return
     */
    List<VisitVO> userVisit(VisitVO visitVO);

    /**
     * 埋点功能访问情况
     *
     * @return
     */
    List<VisitVO> functionVisit(VisitVO visitVO);

    /**
     * 埋点功能用户访问情况
     *
     * @return
     */
    List<VisitVO> functionUserVisit(VisitVO visitVO);

    /**
     * 埋点功能用户访问情况
     *
     * @return
     */
    List<VisitVO> functionUserCountVisit(VisitVO visitVO);

    /**
     * 埋点功能用列表
     *
     * @return
     */
    List<VisitVO> functionList();
    /**
     * 登录用户统计
     * @param loginUserStatisticsQuery
     * @return
     * @author RKKJ
     */
    LoginUserStatistics loginUserStatistics(LoginUserStatisticsQuery loginUserStatisticsQuery);
}
