package com.bringspring.system.base.service;

import com.bringspring.common.database.model.DbTableDataForm;
import com.bringspring.common.database.model.DbTableFieldModel;
import com.bringspring.common.database.model.DbTableModel;
import com.bringspring.common.database.model.dto.DbConnDTO;
import com.bringspring.common.database.model.interfaces.JdbcGetMod;
import com.bringspring.common.exception.DataException;
import com.bringspring.system.base.model.dbtable.DbTableCreate;
import com.bringspring.system.base.model.dbtable.DbTableUpdate;

import java.util.List;
import java.util.Map;

/**
 * 数据管理
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月27日 上午9:18
 */
public interface DbTableService {

    /**
     * 表列表
     *
     * @param dbId 连接Id
     * @return 表集合信息
     * @throws DataException ignore
     */
    List<DbTableModel> getList(String dbId) throws DataException;

    /**
     *
     * @param table
     * @param modType
     * @param connDTO
     * @param <T>
     * @return
     * @throws DataException
     */
    <T extends JdbcGetMod> List<T> getListCommon(String table, Class<T> modType, DbConnDTO connDTO) throws DataException;
    /**
     * 表字段
     *
     * @param dbId  连接Id
     * @param table 表名
     * @return 字段集合信息
     * @throws DataException ignore
     */
    List<DbTableFieldModel> getFieldList(String dbId, String table) throws DataException;

    /**
     * 表数据
     *
     * @param dbTableDataForm 分页
     * @param dbId            连接Id
     * @param table           表名
     * @return 表数据集合
     * @throws Exception ignore
     */
    List<Map<String, Object>> getData(DbTableDataForm dbTableDataForm, String dbId, String table) throws Exception;

    /**
     * 校验：表名重名
     *
     * @param dbId     连接Id
     * @return 重名标识
     * @throws DataException ignore
     */
    boolean isExistByTableName(String dbId, String table) throws DataException;

    /**
     * 删除表
     *
     * @param dbId  连接Id
     * @param table 表名
     * @throws DataException ignore
     */
    void delete(String dbId, String table) throws DataException;

    /**
     * 创建表
     *
     * @param dbTableCreate 前端创表表单信息
     * @return 执行状态（1：成功；0：重名）
     * @throws DataException ignore
     */
    int createTable(DbTableCreate dbTableCreate) throws DataException;

    /**
     * 修改表
     *
     * @param dbTableUpdate 修改表参数对象
     * @throws DataException ignore
     */
    void update(DbTableUpdate dbTableUpdate) throws DataException;

    /**
     * 获取表数据行数
     *
     * @param dbId  数据连接Id
     * @param table 表名
     * @return 数据行数
     * @throws DataException ignore
     */
    int getSum(String dbId, String table) throws DataException;


    /**
     * 获取同步表
     *
     * @param lindId 连接id
     */
    void getSyncTable(String lindId);
}
