package com.bringspring.system.msgcenter.service.chain;

import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 构建处理链工厂
 */
@Component
public class FilterChainFactory {

    private final ApplicationContext applicationContext;

    public FilterChainFactory(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public FilterChain createChain(ChainChannelType chainChannelType) {
        List<FilterProcessor> processors = chainChannelType.getProcessors().stream()
                .map(clazz -> applicationContext.getBean(clazz))
                .collect(Collectors.toList());

        return new FilterChain(processors);
    }
}
