package com.bringspring.system.msgcenter.service.context;

import lombok.Data;

/**
 * 定义消息接收人参数传输元数据值对象
 */
@Data
public class TaskMsgReceiveMetadata {
    // 所有字段设为 final 确保不可变性
    private final String taskMsgId;
    private final String templateId;
    private final String channelType;
    private final String msgTemplateId;
    private final String msgAccountId;
    private final String contentId;

    // 私有构造函数（只能通过 Builder 访问）
    private TaskMsgReceiveMetadata(String taskMsgId, String templateId, String channelType,
                                   String msgTemplateId, String msgAccountId, String contentId) {
        this.taskMsgId = taskMsgId;
        this.templateId = templateId;
        this.channelType = channelType;
        this.msgTemplateId = msgTemplateId;
        this.msgAccountId = msgAccountId;
        this.contentId = contentId;
    }

    // 静态方法获取 Builder
    public static Builder builder() {
        return new Builder();
    }

    // 建造者类
    public static class Builder {
        private String taskMsgId;
        private String templateId;
        private String channelType;
        private String msgTemplateId;
        private String msgAccountId;
        private String contentId;

        // 链式设置方法
        public Builder taskMsgId(String taskMsgId) {
            this.taskMsgId = taskMsgId;
            return this;
        }

        public Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public Builder channelType(String channelType) {
            this.channelType = channelType;
            return this;
        }

        public Builder msgTemplateId(String msgTemplateId) {
            this.msgTemplateId = msgTemplateId;
            return this;
        }

        public Builder msgAccountId(String msgAccountId) {
            this.msgAccountId = msgAccountId;
            return this;
        }

        public Builder contentId(String contentId) {
            this.contentId = contentId;
            return this;
        }

        // 构建方法
        public TaskMsgReceiveMetadata build() {
            return new TaskMsgReceiveMetadata(
                    taskMsgId,
                    templateId,
                    channelType,
                    msgTemplateId,
                    msgAccountId,
                    contentId
            );
        }
    }
}
