package com.bringspring.system.msgcenter.service.strategy.impl;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.WxMaSubscribeMessage;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.external.config.mutil.WxMaConfiguration;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.message.service.SynThirdInfoService;
import com.bringspring.system.msgcenter.entity.McMsgAccountEntity;
import com.bringspring.system.msgcenter.entity.McMsgTemplateEntity;
import com.bringspring.system.msgcenter.entity.McTaskMsgContentEntity;
import com.bringspring.system.msgcenter.entity.McTaskMsgReceiveEntity;
import com.bringspring.system.msgcenter.enums.ChannelTypeEnum;
import com.bringspring.system.msgcenter.enums.EnabledMarkEnum;
import com.bringspring.system.msgcenter.enums.ToTypeEnum;
import com.bringspring.system.msgcenter.model.mcmsgsendtemplate.McMsgSendTemplateModel;
import com.bringspring.system.msgcenter.model.mcwxtemplate.McWxSendResult;
import com.bringspring.system.msgcenter.service.McMsgAccountService;
import com.bringspring.system.msgcenter.service.McMsgTemplateService;
import com.bringspring.system.msgcenter.service.McTaskMsgReceiveService;
import com.bringspring.system.msgcenter.service.context.SendMessageContext;
import com.bringspring.system.msgcenter.service.strategy.AbstractMessageSender;
import com.bringspring.system.msgcenter.util.BlacklistUtil;
import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.common.error.WxErrorException;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static cn.binarywang.wx.miniapp.constant.WxMaConstants.MiniProgramState.FORMAL;

/**
 * 消息中心-微信小程序消息下发工具类
 * 使用WxJava（微信Java开发工具包）
 */
@Component
@Slf4j
public class MsgToWxMiniappService extends AbstractMessageSender {

    private final WxMaConfiguration wxMaConfiguration;
    private WxMaService wxMaService;

    private String programState = FORMAL;

    public MsgToWxMiniappService(WxMaConfiguration wxMaConfiguration) {
        this.wxMaConfiguration = wxMaConfiguration;
    }

    @Override
    protected int getBatchSize() {
        return 1000;
    }

    @Override
    public ChannelTypeEnum getChannelType() {
        return ChannelTypeEnum.WX_MINIAPP;
    }


    @Override
    protected void validateParameters(SendMessageContext context) {
        validateTemplate(context);
        validateAccount(context);
    }


    @Override
    protected void doSend(SendMessageContext context) {
        if (CollectionUtil.isNotEmpty(context.getValidList())) {
            List<McTaskMsgReceiveEntity> receiveList = context.getValidList();
            // 预处理：应用账号配置
            McMsgAccountEntity account = context.getMsgAccount();
            programState = account.getProgramState();
            String appId = account.getAppId();
            wxMaService = wxMaConfiguration.getWxMaService(appId);

            // 预处理：消息模板
            McMsgTemplateEntity templateInfo = context.getTemplateInfo();
            String templateCode = templateInfo.getTemplateCode(); // 微信小程序订阅消息模板

            // 预处理：消息内容
            McTaskMsgContentEntity taskMsgContent = context.getTaskMsgContent();
            List<WxMaSubscribeMessage.MsgData> msgDataList = new ArrayList<>();
            if (StringUtils.isNotEmpty(taskMsgContent.getContent())) {
                Map<String, String> map = JSONObject.parseObject(taskMsgContent.getContent(), Map.class);
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    msgDataList.add(new WxMaSubscribeMessage.MsgData(entry.getKey(), entry.getValue()));
                }
            }

            String toType = context.getToType();
            Map<String, SynThirdInfoEntity> thirdInfoMap = context.getThirdInfoMap();
            List<McTaskMsgReceiveEntity> validList = new ArrayList<>();
            List<McTaskMsgReceiveEntity> invalidList = new ArrayList<>();
            for (McTaskMsgReceiveEntity receiveEntity : receiveList) {
                String opneid = receiveEntity.getReceiveUserId(); //
                if (!ToTypeEnum.NON_USER.getCode().equals(toType)) {
                    opneid = thirdInfoMap.get(opneid).getThirdObjectId();
                }
                WxMaSubscribeMessage wxMaSubscribeMessage =
                        WxMaSubscribeMessage.builder()
                                .toUser(opneid)
                                .templateId(templateCode)
                                .data(msgDataList)
                                .page(taskMsgContent.getLinkUrl())
                                .miniprogramState(programState)
                                .build();
                try {
                    this.wxMaService.getSubscribeService().sendSubscribeMsg(wxMaSubscribeMessage);
                    receiveEntity.setEnabledMark(EnabledMarkEnum.SUCCESS.getCode());
//                    receiveEntity.setDescription(msgid);
                    validList.add(receiveEntity);
                } catch (WxErrorException e) {
                    e.printStackTrace();
                    receiveEntity.setEnabledMark(EnabledMarkEnum.FAIL.getCode());
                    receiveEntity.setDescription(e.getMessage());
                    invalidList.add(receiveEntity);
                }
            }

            context.getInvalidList().addAll(invalidList);
            context.setValidList(validList);
        }
    }


    @Override
    protected void sendBatchNonSystemUser(boolean isAgain,
                                          McMsgSendTemplateModel sendTemplate,
                                          McTaskMsgContentEntity taskMsgContent,
                                          List<McTaskMsgReceiveEntity> receiveListS,
                                          UserInfo currentUserInfo) {
        if (ObjectUtil.isEmpty(taskMsgContent) || CollectionUtil.isEmpty(receiveListS)) {
            log.error("~·~·~·~调用了 微信小程序消息【非系统用户】下发，但message info为空 或 接收人列表为空~·~·~·~");
        }
        List<McTaskMsgReceiveEntity> receiveList = JsonUtil.getJsonToList(receiveListS, McTaskMsgReceiveEntity.class);

        // 消息模板
        McMsgTemplateEntity templateInfo = mcMsgTemplateService.getInfo(sendTemplate.getTemplateId());
        // 账号
        McMsgAccountEntity msgAccount = mcMsgAccountService.getInfo(sendTemplate.getAccountConfigId());

        if (ObjectUtil.isNotNull(templateInfo) && ObjectUtil.isNotNull(msgAccount)) {
            String appId = msgAccount.getAppId();
            wxMaService = wxMaConfiguration.getWxMaService(appId);
            McMsgAccountEntity account = wxMaConfiguration.getAccount(appId);
            if (ObjectUtil.isNotNull(account) && StringUtils.isNotEmpty(account.getProgramState())) {
                programState = account.getProgramState();
            }
            // 微信小程序订阅消息模板
            String templateCode = templateInfo.getTemplateCode();

            if (CollectionUtil.isNotEmpty(receiveList)) {
                List<String> openidList =
                        receiveList.stream().map(r -> r.getReceiveUserId()).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(openidList)) {
                    /**
                     * 调用企业API 发送消息
                     */
                    List<McWxSendResult> failList = this.postMessageSend(taskMsgContent, templateCode, openidList);

                    /**
                     * 处理发送结果
                     * 将‘待下发’临时处理为‘下发成功’
                     */
                    if (CollectionUtil.isNotEmpty(receiveList)) {
                        String errMsg = isAgain ? "重发成功：" : "下发成功：";
                        mcTaskMsgReceiveService.updateByList(isAgain, receiveList, 1, errMsg, currentUserInfo);
                    }
                    if (CollectionUtil.isNotEmpty(failList)) {
                        List<McTaskMsgReceiveEntity> updateBatch = new ArrayList<>();
                        for (McWxSendResult result : failList) {
                            String errMsg = isAgain ? "重发" : "下发";
                            Integer errCode = result.getErrCode(); // 渠道消息下发状态，0待下发、1下/重发成功、2下/重发失败
                            String description = errMsg + (errCode == 1 ? "成功：" : "失败：") + result.getErrMsg();
                            String openid = result.getFailUser();
                            List<McTaskMsgReceiveEntity> receiveEntityList =
                                    receiveList.stream().filter(r -> openid.equals(r.getReceiveUserId())).collect(Collectors.toList());
                            if (CollectionUtil.isNotEmpty(receiveEntityList)) {
                                for (McTaskMsgReceiveEntity receiveEntity : receiveEntityList) {
                                    receiveEntity.setSendTime(new Date());
                                    receiveEntity.setSendUserId(currentUserInfo.getUserId());
                                    receiveEntity.setEnabledMark(errCode);
                                    receiveEntity.setDescription(description);
                                    if (ObjectUtil.isEmpty(receiveEntity.getAutoAgainNum())) {
                                        receiveEntity.setAutoAgainNum(0);
                                    } else {
                                        receiveEntity.setAutoAgainNum(receiveEntity.getAutoAgainNum() + 1);
                                    }
                                }
                                updateBatch.addAll(receiveEntityList);
                            }
                        }
                        if (CollectionUtil.isNotEmpty(updateBatch)) {
                            mcTaskMsgReceiveService.updateBatchById(updateBatch);
                        }
                    }
                }
            }
        }
    }


    /**
     * 微信小程序消息下发
     * 发送应用消息
     *
     * @param isAgain        是否重发
     * @param taskMsgContent 消息
     * @param receiveListS   接收人source
     */
    @Override
    protected void sendBatch(boolean isAgain, McMsgSendTemplateModel sendTemplate,
                             McTaskMsgContentEntity taskMsgContent,
                             List<McTaskMsgReceiveEntity> receiveListS, UserInfo currentUserInfo) {
        if (ObjectUtil.isEmpty(taskMsgContent) || CollectionUtil.isEmpty(receiveListS)) {
            log.error("~·~·~·~调用了 微信小程序消息下发，但message info为空 或 接收人列表为空~·~·~·~");
        }
        List<McTaskMsgReceiveEntity> receiveList = JsonUtil.getJsonToList(receiveListS, McTaskMsgReceiveEntity.class);

        // 消息模板
        McMsgTemplateEntity templateInfo = mcMsgTemplateService.getInfo(sendTemplate.getTemplateId());

        // 账号
        McMsgAccountEntity msgAccount = mcMsgAccountService.getInfo(sendTemplate.getAccountConfigId());

        if (ObjectUtil.isNotNull(templateInfo) && ObjectUtil.isNotNull(msgAccount)) {
            String appId = msgAccount.getAppId();
            wxMaService = wxMaConfiguration.getWxMaService(appId);
            McMsgAccountEntity account = wxMaConfiguration.getAccount(appId);
            if (ObjectUtil.isNotNull(account) && StringUtils.isNotEmpty(account.getProgramState())) {
                programState = account.getProgramState();
            }
            // 微信小程序订阅消息模板
            String templateCode = templateInfo.getTemplateCode();


            // 黑名单成员
            List<McTaskMsgReceiveEntity> receiveBlacklist = BlacklistUtil.receiveListFilter(receiveList);

            if (CollectionUtil.isNotEmpty(receiveList)) {
                // 无third绑定数据
                List<McTaskMsgReceiveEntity> thirdNullList =
                        receiveList.stream().filter(r -> StringUtils.isEmpty(r.getReceiveUserId())).collect(Collectors.toList());
                // 有third绑定数据
                List<McTaskMsgReceiveEntity> thirdNotNullList =
                        receiveList.stream().filter(r -> StringUtils.isNotEmpty(r.getReceiveUserId())).collect(Collectors.toList());
                List<String> thirdInfoIds =
                        thirdNotNullList.stream().map(r -> r.getReceiveUserId()).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(thirdInfoIds)) {
                    List<SynThirdInfoEntity> thirdInfoList = synThirdInfoService.listByIds(thirdInfoIds);
                    // third无userid
                    List<SynThirdInfoEntity> thirdUseridNullList =
                            thirdInfoList.stream().filter(r -> StringUtils.isEmpty(r.getThirdObjectId())).collect(Collectors.toList());
                    List<McTaskMsgReceiveEntity> useridNullList =
                            thirdNotNullList.stream().filter(r -> thirdUseridNullList.stream().map(e ->
                                    e.getId()).collect(Collectors.toList()).contains(r.getReceiveUserId())).collect(Collectors.toList());
                    // third有userid
                    List<SynThirdInfoEntity> thirdUseridNotNullList =
                            thirdInfoList.stream().filter(r -> StringUtils.isNotEmpty(r.getThirdObjectId())).collect(Collectors.toList());
                    List<McTaskMsgReceiveEntity> useridNotNullList =
                            thirdNotNullList.stream().filter(r -> thirdUseridNotNullList.stream().map(e ->
                                    e.getId()).collect(Collectors.toList()).contains(r.getReceiveUserId())).collect(Collectors.toList());

                    List<String> openidList =
                            thirdUseridNotNullList.stream().map(r -> r.getThirdObjectId()).collect(Collectors.toList());
                    if (CollectionUtil.isNotEmpty(openidList)) {
                        /**
                         * 调用企业API 发送消息
                         */
                        List<McWxSendResult> failList = this.postMessageSend(taskMsgContent, templateCode, openidList);

                        /**
                         * 处理发送结果
                         */
                        if (CollectionUtil.isNotEmpty(failList)) {
                            this.wxMiniappSendMessageResult(isAgain, taskMsgContent, useridNotNullList,
                                    thirdUseridNotNullList, failList, currentUserInfo);
                        }
                    }

                    if (CollectionUtil.isNotEmpty(useridNullList)) {
                        String errMsg = (isAgain ? "重发失败：" : "下发失败：") + "third无userid";
                        mcTaskMsgReceiveService.updateByList(isAgain, useridNullList, 2, errMsg, currentUserInfo);
                    }
                }

                if (CollectionUtil.isNotEmpty(thirdNullList)) {
                    String errMsg = (isAgain ? "重发失败：" : "下发失败：") + "无third绑定数据";
                    mcTaskMsgReceiveService.updateByList(isAgain, thirdNullList, 2, errMsg, currentUserInfo);
                }

            }
            if (CollectionUtil.isNotEmpty(receiveBlacklist)) {
                // 黑名单
                mcTaskMsgReceiveService.updateBlacklist(receiveBlacklist, currentUserInfo);
            }
        }
    }

    /**
     * 执行 微信小程序应用消息post下发
     *
     * @param taskMsgContent 消息内容
     * @param templateCode
     * @param openidList
     * @throws WxErrorException
     */
    public List<McWxSendResult> postMessageSend(McTaskMsgContentEntity taskMsgContent, String templateCode,
                                                List<String> openidList) {
        if (ObjectUtil.isEmpty(taskMsgContent) || StringUtils.isEmpty(templateCode) || CollectionUtil.isEmpty(openidList)) {
            log.error("~·~·~·~执行 微信小程序应用消息post下发，但message info 或 templateCode 或 openidList为空~·~·~·~");
        }

        List<WxMaSubscribeMessage.MsgData> msgDataList = new ArrayList<>();
        if (StringUtils.isNotEmpty(taskMsgContent.getContent())) {
            Map<String, String> map = JSONObject.parseObject(taskMsgContent.getContent(), Map.class);
            for (Map.Entry<String, String> entry : map.entrySet()) {
                msgDataList.add(new WxMaSubscribeMessage.MsgData(entry.getKey(), entry.getValue()));
            }
        }

        List<McWxSendResult> failList = new ArrayList<>();
        for (String opneid : openidList) {
            WxMaSubscribeMessage wxMaSubscribeMessage =
                    WxMaSubscribeMessage.builder()
                            .toUser(opneid)
                            .templateId(templateCode)
                            .data(msgDataList)
                            .page(taskMsgContent.getLinkUrl())
                            .miniprogramState(programState)
                            .build();

            McWxSendResult mcWxSendResult = new McWxSendResult();
            try {
                this.wxMaService.getSubscribeService().sendSubscribeMsg(wxMaSubscribeMessage);
                mcWxSendResult.setErrCode(1);
                mcWxSendResult.setFailUser(opneid);
            } catch (WxErrorException e) {
                e.printStackTrace();
                mcWxSendResult.setErrCode(2);
                mcWxSendResult.setErrMsg(e.getMessage());
                mcWxSendResult.setFailUser(opneid);
            }
            failList.add(mcWxSendResult);
        }

        return failList;
    }

    /**
     * 执行 微信小程序应用消息post下发 结果处理
     *
     * @param isAgain        是否重发
     * @param taskMsgContent 消息内容表信息
     * @param receiveList    微信小程序消息发送集合
     * @param thirdInfoList  绑定微信小程序发送集合
     * @param failList       微信小程序消息发送结果集合
     */
    public void wxMiniappSendMessageResult(boolean isAgain, McTaskMsgContentEntity taskMsgContent,
                                           List<McTaskMsgReceiveEntity> receiveList,
                                           List<SynThirdInfoEntity> thirdInfoList,
                                           List<McWxSendResult> failList, UserInfo currentUserInfo) {

        /**
         * 将‘待下发’临时处理为‘下发成功’
         */
        if (CollectionUtil.isNotEmpty(receiveList)) {
            String errMsg = isAgain ? "重发成功：" : "下发成功：";
            mcTaskMsgReceiveService.updateByList(isAgain, receiveList, 1, errMsg, currentUserInfo);
        }

        /**
         * 处理微信小程序下发接口返回的 不合法的userid
         */
        if (CollectionUtil.isNotEmpty(failList)) {
            List<McTaskMsgReceiveEntity> updateBatch = new ArrayList<>();
            for (McWxSendResult result : failList) {
                String errMsg = StringUtils.isEmpty(result.getErrMsg()) ? "" : result.getErrMsg();
                String openid = result.getFailUser();
                List<SynThirdInfoEntity> thirdInfo =
                        thirdInfoList.stream().filter(r -> openid.equals(r.getThirdObjectId())).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(thirdInfo)) {
                    List<McTaskMsgReceiveEntity> receiveEntityList =
                            receiveList.stream().filter(r -> thirdInfo.stream().map(e ->
                                    e.getId()).collect(Collectors.toList()).contains(r.getReceiveUserId())).collect(Collectors.toList());
                    if (CollectionUtil.isNotEmpty(receiveEntityList)) {
                        if (!isAgain) {
                            receiveEntityList.stream().forEach(s -> {
                                s.setSendTime(new Date());
                                s.setSendUserId(currentUserInfo.getUserId());
                                s.setEnabledMark(result.getErrCode()); // 渠道消息下发状态，0待下发、1下/重发成功、2下/重发失败
                                s.setDescription((result.getErrCode() == 1 ? "下发成功：" : "下发失败：") + errMsg);
                                s.setAutoAgainNum(0);
                            });
                        } else {
                            receiveEntityList.stream().forEach(s -> {
                                s.setAgainTime(new Date());
                                s.setAgainUserId(currentUserInfo.getUserId());
                                s.setEnabledMark(result.getErrCode()); // 渠道消息下发状态，0待下发、1下/重发成功、2下/重发失败
                                s.setDescription((result.getErrCode() == 1 ? "重发成功：" : "重发失败：") + errMsg);
                                if (ObjectUtil.isEmpty(s.getAutoAgainNum())) {
                                    s.setAutoAgainNum(0);
                                } else {
                                    s.setAutoAgainNum(s.getAutoAgainNum() + 1);
                                }
                            });
                        }
                        updateBatch.addAll(receiveEntityList);
                    }
                }
            }
            if (CollectionUtil.isNotEmpty(updateBatch)) {
                mcTaskMsgReceiveService.updateBatchById(updateBatch);
            }
        }
    }

}
