package com.bringspring.system.permission.aop;

import com.bringspring.common.util.UserProvider;
import com.bringspring.system.permission.constant.PermissionConstant;
import com.bringspring.system.permission.model.position.PositionCrForm;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.PositionService;
import com.bringspring.system.permission.util.PermissionAspectUtil;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 岗位分级管理
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/15 17:12
 */
@Slf4j
@Aspect
@Component
public class PermissionPositionAspect implements PermissionAdminBase{

    @Autowired
    private UserProvider userProvider;
    @Autowired
    private PositionService positionService;
    @Autowired
    private OrganizeService organizeService;

    /**
     * 分级管理切点
     */
    @Pointcut("@annotation(com.bringspring.common.annotation.PositionPermission)")
    public void pointcut() {
    }

    /**
     * 分级管理切点
     *
     * @param pjp
     * @return
     * @throws Throwable
     */
    @Around("pointcut()")
    public Object around(ProceedingJoinPoint pjp) throws Throwable {
        return PermissionAdminBase.permissionCommon(pjp, userProvider, this);
    }

    @Override
    public Boolean detailPermission(ProceedingJoinPoint pjp, String operatorUserId, String methodName) {
        switch (methodName){
            case PermissionConstant.METHOD_CREATE:
            case PermissionConstant.METHOD_UPDATE:
                return PermissionAspectUtil.getPermitByOrgIds(
                        // 操作目标对象组织ID集合
                        ((PositionCrForm) pjp.getArgs()[0]).getOrganizeId(),
                        operatorUserId,
                        methodName);
            case PermissionConstant.METHOD_DELETE:
                // 获取岗位所关联的组织ID字符串
                String positionId = String.valueOf(pjp.getArgs()[0]);
                String orgIds = organizeService.getInfo(positionService.getInfo(positionId).getOrganizeId()).getId();
                return PermissionAspectUtil.getPermitByOrgIds(
                        // 操作目标对象组织ID集合
                        orgIds,
                        operatorUserId,
                        PermissionConstant.METHOD_DELETE);
            default:
                return false;
        }
    }
}
