package com.bringspring.system.permission.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.bringspring.common.base.UserInfo;
import com.bringspring.system.base.entity.*;
import com.bringspring.system.permission.entity.AuthorizeEntity;
import com.bringspring.system.permission.model.authorize.*;

import java.util.List;
import java.util.Map;

/**
 * 操作权限
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月26日 上午9:18
 */
public interface AuthorizeService extends IService<AuthorizeEntity> {

    /**
     * 获取权限（菜单、按钮、列表）
     *
     * @param userInfo 对象
     * @return
     */
    AuthorizeVO getAuthorize(UserInfo userInfo) throws Exception;

    /**
     * 获取权限（菜单、按钮、列表）根据角色id
     *
     * @param roleId
     * @return
     */
    AuthorizeVO getAuthorizeByRoleId(String roleId) throws Exception;

    /**
     * 获取权限（菜单、按钮、列表）
     *
     * @param isCache 是否存在redis
     * @return
     */
    AuthorizeVO getAuthorize(boolean isCache);

    /**
     * 获取表单条件内容、条件符号选项
     * @return
     */
    Map<String, List<Map<String, Object>>> getDataAuthorizeForm();

    /**
     * 获取条件内容 描述
     * @return
     */
    String getDescByCondition(String condition);

    /**
     * 创建角色和数据权限
     *
     * @param objectId      对象主键
     * @param authorizeList 实体对象
     */
    void save(String objectId, AuthorizeDataUpForm authorizeList);

    /**
     * 创建批量
     *
     * @param saveBatchForm 对象主键
     */
    void saveBatch(SaveBatchForm saveBatchForm, boolean isBatch);

    /**
     * 根据用户id获取列表
     *
     * @param isAdmin 是否管理员
     * @param userId  用户主键
     * @return
     */
    List<AuthorizeEntity> getListByUserId(boolean isAdmin, String userId);

    /**
     * 根据对象Id获取列表
     *
     * @param objectId 对象主键
     * @return
     */
    List<AuthorizeEntity> getListByObjectId(String objectId);

    /**
     * 判断角色是不是有菜单权限
     *
     * @param objectId 角色ID
     * @return
     */
    Boolean existByObjId(String objectId);

    /**
     * 根据对象Id获取列表
     *
     * @param objectId 对象主键
     * @param itemType 对象主键
     * @return
     */
    List<AuthorizeEntity> getListByObjectId(String objectId, String itemType);

    /**
     * 根据对象Id获取列表
     *
     * @param objectType 对象主键
     * @return
     */
    List<AuthorizeEntity> getListByObjectAndItem(String itemId, String objectType);

    List<AuthorizeEntity> getListByItemId(String itemId);

    void saveAuth(String itemId, SaveAuthForm saveAuthForm);

    Object getCondition(AuthorizeConditionModel conditionModel);

    String getConditionSql(UserInfo userInfo, String moduleId, String mainTable);

    AuthorizeDataReturnVO getAuthorizeDataReturnVO(AuthorizeVO authorizeModel, List<AuthorizeEntity> list,
                                                   DataValuesQuery dataValuesQuery, String objectId);

    AuthorizeDataReturnVO module(List<ModuleEntity> moduleList, List<AuthorizeEntity> list, AuthorizeVO authorizeModel);

    AuthorizeDataReturnVO moduleButton(List<ModuleEntity> moduleList, List<ModuleButtonEntity> moduleButtonList,
                                       List<AuthorizeEntity> list, AuthorizeVO authorizeModel);

    AuthorizeDataReturnVO moduleColumn(List<ModuleEntity> moduleList, List<ModuleColumnEntity> moduleColumnList,
                                       List<AuthorizeEntity> list, AuthorizeVO authorizeModel);

    AuthorizeDataReturnVO moduleForm(List<ModuleEntity> moduleList, List<ModuleFormEntity> moduleFormList,
                                     List<AuthorizeEntity> list, AuthorizeVO authorizeModel);

    AuthorizeDataReturnVO resourceData(List<ModuleEntity> moduleList,
                                       List<ModuleDataAuthorizeSchemeEntity> moduleDataSchemeList,
                                       List<AuthorizeEntity> list, AuthorizeVO authorizeModel);
}
