/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgcenter.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.DeleteMarkEnum;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.msgcenter.entity.McBusinessEntity;
import com.bringspring.system.msgcenter.entity.McBusinessKeywordEntity;
import com.bringspring.system.msgcenter.mapper.McBusinessMapper;
import com.bringspring.system.msgcenter.model.mcbusiness.McBusinessCrForm;
import com.bringspring.system.msgcenter.model.mcbusiness.McBusinessInfoVO;
import com.bringspring.system.msgcenter.model.mcbusiness.McBusinessPagination;
import com.bringspring.system.msgcenter.model.mcbusiness.McBusinessUpForm;
import com.bringspring.system.msgcenter.model.mcbusinesskeyword.McBusinessKeywordModel;
import com.bringspring.system.msgcenter.service.McBusinessKeywordService;
import com.bringspring.system.msgcenter.service.McBusinessService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class McBusinessServiceImpl
extends ServiceImpl<McBusinessMapper, McBusinessEntity>
implements McBusinessService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private McBusinessKeywordService mcBusinessKeywordService;

    @Override
    public List<McBusinessEntity> getList(McBusinessPagination pagination) {
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)pagination.getCategory())) {
            queryWrapper.lambda().eq(McBusinessEntity::getCategory, (Object)pagination.getCategory());
        }
        if (StringUtils.isNotEmpty((String)pagination.getKeyword())) {
            ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().like(McBusinessEntity::getFullName, (Object)pagination.getKeyword())).or()).like(McBusinessEntity::getEnCode, (Object)pagination.getKeyword());
        }
        if (StringUtils.isNotEmpty((String)pagination.getFullName())) {
            queryWrapper.lambda().like(McBusinessEntity::getFullName, (Object)pagination.getFullName());
        }
        if (StringUtils.isNotEmpty((String)pagination.getEnCode())) {
            queryWrapper.lambda().like(McBusinessEntity::getEnCode, (Object)pagination.getEnCode());
        }
        if (StringUtils.isNotEmpty(pagination.getCreatorTime())) {
            List<String> CreatorTimeList = pagination.getCreatorTime();
            Long fir = Long.valueOf(CreatorTimeList.get(0));
            Long sec = Long.valueOf(CreatorTimeList.get(1));
            ((LambdaQueryWrapper)queryWrapper.lambda().ge(McBusinessEntity::getCreatorTime, (Object)new Date(fir))).le(McBusinessEntity::getCreatorTime, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (StringUtils.isNotEmpty((String)pagination.getDeleteMark())) {
            queryWrapper.lambda().eq(McBusinessEntity::getDeleteMark, (Object)pagination.getDeleteMark());
        }
        if (StringUtils.isNotEmpty(pagination.getCompanyId())) {
            queryWrapper.lambda().eq(McBusinessEntity::getCompanyId, (Object)JsonUtil.getObjectToString(pagination.getCompanyId()));
        }
        if (AllIdList.size() > 0) {
            queryWrapper.lambda().in(McBusinessEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)pagination.getSidx())) {
            queryWrapper.lambda().orderByDesc(McBusinessEntity::getCreatorTime);
        } else {
            try {
                String sidx = pagination.getSidx();
                Field declaredField = McBusinessEntity.class.getDeclaredField(sidx);
                String value = declaredField.getAnnotation(TableField.class).value();
                queryWrapper = "asc".equals(pagination.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)value) : (QueryWrapper)queryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)queryWrapper);
            return pagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return pagination.setData(list, list.size());
    }

    @Override
    public List<McBusinessEntity> getTypeList(McBusinessPagination pagination, String dataType) {
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)pagination.getCategory())) {
            queryWrapper.lambda().eq(McBusinessEntity::getCategory, (Object)pagination.getCategory());
        }
        if (StringUtils.isNotEmpty((String)pagination.getFullName())) {
            queryWrapper.lambda().like(McBusinessEntity::getFullName, (Object)pagination.getFullName());
        }
        if (StringUtils.isNotEmpty((String)pagination.getEnCode())) {
            queryWrapper.lambda().like(McBusinessEntity::getEnCode, (Object)pagination.getEnCode());
        }
        if (StringUtils.isNotEmpty(pagination.getCreatorTime())) {
            List<String> CreatorTimeList = pagination.getCreatorTime();
            Long fir = Long.valueOf(CreatorTimeList.get(0));
            Long sec = Long.valueOf(CreatorTimeList.get(1));
            ((LambdaQueryWrapper)queryWrapper.lambda().ge(McBusinessEntity::getCreatorTime, (Object)new Date(fir))).le(McBusinessEntity::getCreatorTime, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (StringUtils.isNotEmpty((String)pagination.getDeleteMark())) {
            queryWrapper.lambda().eq(McBusinessEntity::getDeleteMark, (Object)pagination.getDeleteMark());
        }
        if (StringUtils.isNotEmpty(pagination.getCompanyId())) {
            queryWrapper.lambda().eq(McBusinessEntity::getCompanyId, (Object)JsonUtil.getObjectToString(pagination.getCompanyId()));
        }
        if (AllIdList.size() > 0) {
            queryWrapper.lambda().in(McBusinessEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)pagination.getSidx())) {
            queryWrapper.lambda().orderByDesc(McBusinessEntity::getCreatorTime);
        } else {
            try {
                String sidx = pagination.getSidx();
                Field declaredField = McBusinessEntity.class.getDeclaredField(sidx);
                String value = declaredField.getAnnotation(TableField.class).value();
                queryWrapper = "asc".equals(pagination.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)value) : (QueryWrapper)queryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)queryWrapper);
                return pagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return pagination.setData(list, list.size());
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public McBusinessEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(McBusinessEntity::getId, (Object)id);
        return (McBusinessEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public McBusinessInfoVO getInfoByEnCode(String enCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(McBusinessEntity::getEnCode, (Object)enCode);
        queryWrapper.last("limit 1");
        McBusinessEntity one = (McBusinessEntity)this.getOne((Wrapper)queryWrapper);
        McBusinessInfoVO infoVO = (McBusinessInfoVO)JsonUtil.getJsonToBean((Object)one, McBusinessInfoVO.class);
        if (ObjectUtil.isNotNull((Object)infoVO)) {
            List<McBusinessKeywordEntity> keywordList = this.getMcBusinessKeywordList(infoVO.getEnCode());
            List keywordModelList = JsonUtil.getJsonToList(keywordList, McBusinessKeywordModel.class);
            infoVO.setKeywordList(keywordModelList);
        }
        return infoVO;
    }

    @Override
    @DSTransactional
    public void create(McBusinessCrForm mcBusinessCrForm) {
        McBusinessEntity entity = (McBusinessEntity)JsonUtil.getJsonToBean((Object)mcBusinessCrForm, McBusinessEntity.class);
        String mainId = RandomUtil.uuId();
        entity.setId(mainId);
        entity.setDeleteMark(DeleteMarkEnum.NOT_DELETE.getCode());
        this.save(entity);
        List keywordList = JsonUtil.getJsonToList(mcBusinessCrForm.getKeywordList(), McBusinessKeywordEntity.class);
        for (McBusinessKeywordEntity entitys : keywordList) {
            entitys.setId(RandomUtil.uuId());
            entitys.setBusinessCode(entity.getEnCode());
            this.mcBusinessKeywordService.save(entitys);
        }
    }

    @Override
    @DSTransactional
    public boolean update(String id, McBusinessUpForm mcBusinessUpForm) {
        McBusinessEntity entity = (McBusinessEntity)JsonUtil.getJsonToBean((Object)mcBusinessUpForm, McBusinessEntity.class);
        entity.setId(id);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(McBusinessKeywordEntity::getBusinessCode, (Object)entity.getEnCode());
        this.mcBusinessKeywordService.remove((Wrapper)queryWrapper);
        List keywordList = JsonUtil.getJsonToList(mcBusinessUpForm.getKeywordList(), McBusinessKeywordEntity.class);
        for (McBusinessKeywordEntity entitys : keywordList) {
            entitys.setId(RandomUtil.uuId());
            entitys.setBusinessCode(entity.getEnCode());
            this.mcBusinessKeywordService.save(entitys);
        }
        entity.setDeleteMark(DeleteMarkEnum.NOT_DELETE.getCode());
        return this.updateById(entity);
    }

    @Override
    @DSTransactional
    public void delete(McBusinessEntity entity) {
        if (ObjectUtil.isNotNull((Object)entity)) {
            this.removeById((Serializable)((Object)entity.getId()));
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(McBusinessKeywordEntity::getBusinessCode, (Object)entity.getEnCode());
            this.mcBusinessKeywordService.remove((Wrapper)queryWrapper);
        }
    }

    @Override
    public List<McBusinessKeywordEntity> getMcBusinessKeywordList(String enCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(McBusinessKeywordEntity::getBusinessCode, (Object)enCode);
        return this.mcBusinessKeywordService.list((Wrapper)queryWrapper);
    }

    @Override
    public boolean checkEnCodeUnique(String enCode, String id) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(McBusinessEntity::getEnCode, (Object)enCode);
        queryWrapper.last("limit 1");
        McBusinessEntity entity = (McBusinessEntity)this.getOne((Wrapper)queryWrapper);
        return !ObjectUtil.isNotNull((Object)entity) || !StringUtils.isEmpty((String)id) && entity.getId().equals(id);
    }

    @Override
    public boolean checkFullNameUnique(String fullName, String id) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(McBusinessEntity::getFullName, (Object)fullName);
        queryWrapper.last("limit 1");
        McBusinessEntity entity = (McBusinessEntity)this.getOne((Wrapper)queryWrapper);
        return !ObjectUtil.isNotNull((Object)entity) || !StringUtils.isEmpty((String)id) && entity.getId().equals(id);
    }
}

