/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgcenter.util;

import com.bringspring.common.util.ParameterUtil;
import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.Credential;
import com.tencentcloudapi.common.profile.ClientProfile;
import com.tencentcloudapi.common.profile.HttpProfile;
import com.tencentcloudapi.sms.v20210111.SmsClient;
import com.tencentcloudapi.sms.v20210111.models.DescribeSmsTemplateListRequest;
import com.tencentcloudapi.sms.v20210111.models.DescribeSmsTemplateListResponse;
import com.tencentcloudapi.sms.v20210111.models.DescribeTemplateListStatus;
import com.tencentcloudapi.sms.v20210111.models.SendSmsRequest;
import com.tencentcloudapi.sms.v20210111.models.SendSmsResponse;
import com.tencentcloudapi.sms.v20210111.models.SendStatus;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmsTenCentCloudSentUtil {
    private static final Logger log = LoggerFactory.getLogger(SmsTenCentCloudSentUtil.class);
    private static final String SMS_SEND_FAILURE_MESSAGE = "\u53d1\u9001\u77ed\u4fe1\u5931\u8d25\uff1a";

    private SmsTenCentCloudSentUtil() {
        throw new UnsupportedOperationException("\u5de5\u5177\u7c7b\u4e0d\u5141\u8bb8\u5b9e\u4f8b\u5316");
    }

    private static SmsClient createClient(String accessKeyId, String accessKeySecret, String endpoint, String region) {
        SmsClient smsClient = null;
        try {
            Credential cred = new Credential(accessKeyId, accessKeySecret);
            HttpProfile httpProfile = new HttpProfile();
            httpProfile.setEndpoint(endpoint);
            ClientProfile clientProfile = new ClientProfile();
            clientProfile.setHttpProfile(httpProfile);
            smsClient = new SmsClient(cred, region, clientProfile);
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u5ba2\u6237\u7aef\u5931\u8d25\uff1a" + e.getMessage());
        }
        return smsClient;
    }

    public static List<String> querySmsTemplateRequest(String accessKeyId, String accessKeySecret, String endpoint, String region, String templateId) {
        try {
            DescribeTemplateListStatus[] describeTemplateStatusSet;
            SmsClient smsClient = SmsTenCentCloudSentUtil.createClient(accessKeyId, accessKeySecret, endpoint, region);
            DescribeSmsTemplateListRequest req = new DescribeSmsTemplateListRequest();
            req.setTemplateIdSet(new Long[]{Long.valueOf(templateId)});
            req.setInternational(Long.valueOf(0L));
            DescribeSmsTemplateListResponse resp = smsClient.DescribeSmsTemplateList(req);
            System.out.println(DescribeSmsTemplateListResponse.toJsonString((AbstractModel)resp));
            DescribeTemplateListStatus[] describeTemplateListStatusArray = describeTemplateStatusSet = resp.getDescribeTemplateStatusSet();
            int n = describeTemplateListStatusArray.length;
            int n2 = 0;
            if (n2 < n) {
                DescribeTemplateListStatus describeTemplateListStatus = describeTemplateListStatusArray[n2];
                String templateContent = describeTemplateListStatus.getTemplateContent();
                ArrayList<String> list = new ArrayList<String>();
                ParameterUtil.parse((String)"{", (String)"}", (String)templateContent, list);
                return list;
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u77ed\u4fe1\u6a21\u677f\u53c2\u6570\u5931\u8d25\uff1a" + e.getMessage());
        }
        return null;
    }

    public static String querySmsTemplateContent(String accessKeyId, String accessKeySecret, String endpoint, String region, String templateId) {
        try {
            DescribeTemplateListStatus[] describeTemplateStatusSet;
            SmsClient smsClient = SmsTenCentCloudSentUtil.createClient(accessKeyId, accessKeySecret, endpoint, region);
            DescribeSmsTemplateListRequest req = new DescribeSmsTemplateListRequest();
            req.setTemplateIdSet(new Long[]{Long.valueOf(templateId)});
            req.setInternational(Long.valueOf(0L));
            DescribeSmsTemplateListResponse resp = smsClient.DescribeSmsTemplateList(req);
            System.out.println(DescribeSmsTemplateListResponse.toJsonString((AbstractModel)resp));
            DescribeTemplateListStatus[] describeTemplateListStatusArray = describeTemplateStatusSet = resp.getDescribeTemplateStatusSet();
            int n = describeTemplateListStatusArray.length;
            int n2 = 0;
            if (n2 < n) {
                DescribeTemplateListStatus describeTemplateListStatus = describeTemplateListStatusArray[n2];
                String templateContent = describeTemplateListStatus.getTemplateContent();
                return templateContent;
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u77ed\u4fe1\u6a21\u677f\u53c2\u6570\u5931\u8d25\uff1a" + e.getMessage());
        }
        return null;
    }

    public static String sentSms(String accessKeyId, String accessKeySecret, String endpoint, String region, String phoneNumbers, String appId, String signContent, String templateId, Map<String, Object> map) {
        try {
            SendStatus[] sendStatusSet;
            SmsClient client = SmsTenCentCloudSentUtil.createClient(accessKeyId, accessKeySecret, endpoint, region);
            SendSmsRequest req = new SendSmsRequest();
            String[] split = phoneNumbers.split(",");
            req.setPhoneNumberSet(split);
            req.setSmsSdkAppId(appId);
            req.setTemplateId(templateId);
            req.setSignName(signContent);
            ArrayList<String> list = new ArrayList<String>();
            for (String key : map.keySet()) {
                String value = map.get(key) != null ? String.valueOf(map.get(key)) : "";
                list.add(value);
            }
            req.setTemplateParamSet(list.toArray(new String[list.size()]));
            SendSmsResponse resp = client.SendSms(req);
            SendStatus[] sendStatusArray = sendStatusSet = resp.getSendStatusSet();
            int n = sendStatusArray.length;
            int n2 = 0;
            if (n2 < n) {
                SendStatus sendStatus = sendStatusArray[n2];
                String code = sendStatus.getCode();
                if ("Ok".equalsIgnoreCase(code)) {
                    return "Ok";
                }
                log.error(SMS_SEND_FAILURE_MESSAGE + sendStatus.getMessage());
                return SMS_SEND_FAILURE_MESSAGE + sendStatus.getMessage();
            }
        }
        catch (Exception e) {
            log.error(SMS_SEND_FAILURE_MESSAGE + e.getMessage());
            return SMS_SEND_FAILURE_MESSAGE + e.getMessage();
        }
        return null;
    }
}

