

package com.bringspring.system.base.controller;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.base.entity.BaseUserBsbEntity;
import com.bringspring.system.base.model.baseuserbsb.*;
import com.bringspring.system.base.service.BaseUserBsbService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.io.IOException;
import java.util.List;

/**
 * 荣科币
 *
 * @版本： V1.0.0
 * @版权： 荣科科技股份有限公司
 * @作者： RKKJ开发平台组
 * @日期： 2023-04-04
 */
@Slf4j
@RestController
@Api(tags = "荣科币", value = "system")
@RequestMapping("/api/system/BaseUserBsb")
public class BaseUserBsbController {

    @Autowired
    private BaseDataUtil baseDataUtil;


    @Autowired
    private UserProvider userProvider;

    @Autowired
    private BaseUserBsbService baseUserBsbService;


    /**
     * 列表
     *
     * @param baseUserBsbPagination
     * @return
     */
    @PostMapping("/getList")
    public ActionResult list(@RequestBody BaseUserBsbPagination baseUserBsbPagination) throws IOException {
        List<BaseUserBsbEntity> list = baseUserBsbService.getList(baseUserBsbPagination);
        //处理id字段转名称，若无需转或者为空可删除

        List<BaseUserBsbListVO> listVO = JsonUtil.getJsonToList(list, BaseUserBsbListVO.class);
        for (BaseUserBsbListVO baseUserBsbVO : listVO) {
            baseUserBsbVO.setUserId(baseDataUtil.userSelectValue(baseUserBsbVO.getUserId()));
        }


        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = JsonUtil.getJsonToBean(baseUserBsbPagination, PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success(vo);
    }


    /**
     * 创建
     *
     * @param baseUserBsbCrForm
     * @return
     */
    @PostMapping
    public ActionResult create(@RequestBody @Valid BaseUserBsbCrForm baseUserBsbCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = userProvider.get();
        BaseUserBsbEntity entity = JsonUtil.getJsonToBean(baseUserBsbCrForm, BaseUserBsbEntity.class);
        entity.setId(mainId);
        entity.setCreatorTime(DateUtil.getNowDate());
        entity.setEnabledMark(10);
        baseUserBsbService.save(entity);


        return ActionResult.success("创建成功");
    }


    /**
     * 信息
     *
     * @param id
     * @return
     */
    @GetMapping("/{id}")
    public ActionResult<BaseUserBsbInfoVO> info(@PathVariable("id") String id) {
        BaseUserBsbEntity entity = baseUserBsbService.getInfo(id);
        BaseUserBsbInfoVO vo = JsonUtil.getJsonToBean(entity, BaseUserBsbInfoVO.class);
        vo.setUserId(baseDataUtil.userSelectValue(vo.getUserId()));
        //子表
        //副表
        return ActionResult.success(vo);
    }

    /**
     * 表单信息(详情页)
     *
     * @param id
     * @return
     */
    @GetMapping("/detail/{id}")
    public ActionResult<BaseUserBsbInfoVO> detailInfo(@PathVariable("id") String id) {
        BaseUserBsbEntity entity = baseUserBsbService.getInfo(id);
        BaseUserBsbInfoVO vo = JsonUtil.getJsonToBean(entity, BaseUserBsbInfoVO.class);
        vo.setUserId(baseDataUtil.userSelectValue(vo.getUserId()));
        //子表数据转换

        //附表数据转换


        return ActionResult.success(vo);
    }


    /**
     * 更新
     *
     * @param id
     * @return
     */
    @PutMapping("/{id}")
    public ActionResult update(@PathVariable("id") String id, @RequestBody @Valid BaseUserBsbUpForm baseUserBsbUpForm) throws DataException {
        UserInfo userInfo = userProvider.get();
        BaseUserBsbEntity entity = baseUserBsbService.getInfo(id);
        if (entity != null) {
            BaseUserBsbEntity subentity = JsonUtil.getJsonToBean(baseUserBsbUpForm, BaseUserBsbEntity.class);

            baseUserBsbService.update(id, subentity);
            return ActionResult.success("更新成功");
        } else {
            return ActionResult.fail("更新失败，数据不存在");
        }
    }


    /**
     * 删除
     *
     * @param id
     * @return
     */
    @DeleteMapping("/{id}")
    public ActionResult delete(@PathVariable("id") String id) {
        BaseUserBsbEntity entity = baseUserBsbService.getInfo(id);
        if (entity != null) {
            baseUserBsbService.delete(entity);

        }
        return ActionResult.success("删除成功");
    }

    /**
     * 加减积分方法
     */
    @PostMapping("/updateIntegral")
    public ActionResult updateIntegral(@RequestBody BaseUserBsbCrForm baseUserBsbCrForm) throws DataException {
        BaseUserBsbEntity one = baseUserBsbService.getOne(Wrappers.<BaseUserBsbEntity>lambdaQuery().eq(BaseUserBsbEntity::getUserId, baseUserBsbCrForm.getUserId()));
        //判断当前用户是否为空，为空则先创建！
        if (ObjectUtil.isNull(one)) {
            baseUserBsbCrForm.setUserId(baseUserBsbCrForm.getUserId());
            baseUserBsbCrForm.setBsbNum(String.valueOf(100 + Integer.valueOf(baseUserBsbCrForm.getBsbNum())));
            this.create(baseUserBsbCrForm);

        } else {
            one.setBsbNum(one.getBsbNum() + Integer.valueOf(baseUserBsbCrForm.getBsbNum()));
            BaseUserBsbUpForm baseUserBsbUpForm = JsonUtil.getJsonToBean(one, BaseUserBsbUpForm.class);
            this.update(one.getId(), baseUserBsbUpForm);
        }
        return ActionResult.success();
    }
}
