package com.bringspring.system.base.model.systemconfig;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/12 15:31
 */
@Data
public class SysConfigModel {
    @NotBlank(message = "必填")
    @ApiModelProperty(value = "系统名称")
    private String sysName;
    @NotBlank(message = "必填")
    @ApiModelProperty(value = "pc端地址")
    private String sysComputerUrl;
    @NotBlank(message = "必填")
    @ApiModelProperty(value = "手机端地址")
    private String sysMobileUrl;
    @NotBlank(message = "必填")
    @ApiModelProperty(value = "系统描述")
    private String sysDescription;
    @NotBlank(message = "必填")
    @ApiModelProperty(value = "系统版本")
    private String sysVersion;
    @NotBlank(message = "必填")
    @ApiModelProperty(value = "版权信息")
    private String copyright;
    @NotBlank(message = "必填")
    @ApiModelProperty(value = "公司名称")
    private String companyName;
    @NotBlank(message = "必填")
    @ApiModelProperty(value = "公司简称")
    private String companyCode;
    @NotBlank(message = "必填")
    @ApiModelProperty(value = "公司地址")
    private String companyAddress;
    @NotBlank(message = "必填")
    @ApiModelProperty(value = "公司法人")
    private String companyContacts;
    @NotBlank(message = "必填")
    @ApiModelProperty(value = "公司电话")
    private String companyTelePhone;
    @NotBlank(message = "必填")
    @ApiModelProperty(value = "公司邮箱")
    private String companyEmail;
    /**
     * 登录图标
     */
    private String loginIcon;

    /**
     * 导航图标
     */
    private String navigationIcon;
    /**
     * logo图标
     */
    private String logoIcon;
    /**
     * App图标
     */
    private String appIcon;

    /**
     * 1--后登陆踢出先登录
     * 2--同时登陆
     */
    @NotBlank(message = "必填")
    @ApiModelProperty(value = "单一登录方式")
    private Integer singleLogin;

    /**
     * 默认密码
     */
    @ApiModelProperty(value = "默认密码")
    @NotNull(message = "必填")
    private String defaultPassword;
    /**
     * 密码错误次数
     */
    @ApiModelProperty(value = "密码错误次数")
    @NotNull(message = "必填")
    private Integer passwordErrorsNumber;
    /**
     * 错误策略  1--账号锁定  2--延时登录
     */
    @ApiModelProperty(value = "错误策略")
    private Integer lockType;
    /**
     * 延时登录时间
     */
    @ApiModelProperty(value = "延时登录时间")
    private Integer lockTime;
    /**
     * 是否开启验证码
     */
    @ApiModelProperty(value = "是否开启验证码")
    private Integer enableVerificationCode;
    /**
     * 验证码位数
     */
    @ApiModelProperty(value = "验证码位数")
    private Integer verificationCodeNumber;


    @NotBlank(message = "必填")
    @ApiModelProperty(value = "超出登出")
    private String tokenTimeout;
    @NotBlank(message = "必填")
    @ApiModelProperty(value = "是否开启上次登录提醒")
    private Integer lastLoginTimeSwitch;
    @NotBlank(message = "必填")
    @ApiModelProperty(value = "是否开启白名单验证")
    private Integer whitelistSwitch;
    @NotBlank(message = "必填")
    @ApiModelProperty(value = "白名单")
    private String whiteListIp;
    @NotBlank(message = "必填")
    @ApiModelProperty(value = "POP3服务主机地址")
    private String emailPop3Host;
    @NotBlank(message = "必填")
    @ApiModelProperty(value = "POP3服务端口")
    private String emailPop3Port;
    @NotBlank(message = "必填")
    @ApiModelProperty(value = "SMTP服务主机地址")
    private String emailSmtpHost;
    @NotBlank(message = "必填")
    @ApiModelProperty(value = "邮件显示名称")
    private String emailSmtpPort;
    @NotBlank(message = "必填")
    @ApiModelProperty(value = "系统名称")
    private String emailSenderName;
    @NotBlank(message = "必填")
    @ApiModelProperty(value = "邮箱账户")
    private String emailAccount;
    @NotBlank(message = "必填")
    @ApiModelProperty(value = "邮箱密码")
    private String emailPassword;
    @NotBlank(message = "必填")
    @ApiModelProperty(value = "是否开启SSL服务登录")
    private Integer emailSsl;


    @NotBlank(message = "必填")
    @ApiModelProperty(value = "授权密钥")
    private String registerKey;
    private String lastLoginTime;
    private String pageSize;
    private String sysTheme;
    private String isLog;

    // 短信配置
    /**
     * 阿里
     */
    private String aliAccessKey;
    private String aliSecret;

    /**
     * 腾讯
     */
    private String tencentSecretId;
    private String tencentSecretKey;
    private String tencentAppId;
    private String tencentAppKey;
    // End 短信配置

    /**
     * 企业微信配置
     */
    /**
     * 发消息
     */
    private String qyhCorpId;
    private String qyhAgentId;
    private String qyhAgentSecret;
    /**
     * 同步消息
     */
    private String qyhCorpSecret;
    /**
     * 电脑端访问URL
     */
    private String qyhComputerUrl;
    /**
     * 移动端访问URL
     */
    private String qyhMobileUrl;

    private Integer qyhIsSynOrg;
    private Integer qyhIsSynUser;

    /**
     * 钉钉 发消息
     */
    private String dingSynAppKey;
    private String dingSynAppSecret;
    private String dingAgentId;
    private Integer dingSynIsSynOrg;
    private Integer dingSynIsSynUser;


    private String weCom;

    private String dingCom;

    /**
     * 消息中心 接收人黑名单
     */
    private String mcBlacklist;
    /**
     * 消息中心 敏感词库
     */
    private String mcSensitive;
}
