package com.bringspring.system.base.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.*;
import com.bringspring.system.base.constants.MessageConstants;
import com.bringspring.system.base.entity.BaseVersionEntity;
import com.bringspring.system.base.enums.BaseVersionSendMarkEnum;
import com.bringspring.system.base.enums.EnabledMarkEnum;
import com.bringspring.system.base.mapper.BaseVersionMapper;
import com.bringspring.system.base.model.baseversion.BaseVersionCrForm;
import com.bringspring.system.base.model.baseversion.BaseVersionPagination;
import com.bringspring.system.base.model.baseversion.BaseVersionUpForm;
import com.bringspring.system.base.service.BaseVersionService;
import com.bringspring.system.msgcenter.enums.TermTypeEnum;
import com.bringspring.system.msgcenter.model.CustomKeysLink;
import com.bringspring.system.msgcenter.model.LinkMsgKeys;
import com.bringspring.system.msgcenter.model.TaskMsg;
import com.bringspring.system.msgcenter.util.SendTaskMsgUtils;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.RangeService;
import com.bringspring.system.permission.service.UserService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 系统版本管理
 * 版本： V1.0.0
 * 版权： 荣科科技股份有限公司
 * 作者： RKKJ开发平台组
 * 日期： 2025-01-13
 */
@Service
@Slf4j
public class BaseVersionServiceImpl extends ServiceImpl<BaseVersionMapper, BaseVersionEntity> implements BaseVersionService {


    @Autowired
    private UserProvider userProvider;

    @Autowired
    private AuthorizeService authorizeService;

    @Autowired
    private RangeService rangeService;

    @Autowired
    private SendTaskMsgUtils sendTaskMsgUtils;

    @Autowired
    private UserService userService;
    /**
     * 系统版本管理列表分页查询
     *
     * @param baseVersionPagination 查询参数
     * @return List<BaseVersionEntity>
     */
    @Override
    public List<BaseVersionEntity> getList(BaseVersionPagination baseVersionPagination) {
        String userId = userProvider.get().getUserId();
        List<String> AllIdList = new ArrayList();
        int total = 0;
        int baseVersionNum = 0;
        QueryWrapper<BaseVersionEntity> baseVersionQueryWrapper = new QueryWrapper<>();
        if (StringUtils.isNotEmpty(baseVersionPagination.getTitle())) {
            baseVersionNum++;
            baseVersionQueryWrapper.lambda().like(BaseVersionEntity::getTitle, baseVersionPagination.getTitle());
        }

        if (StringUtils.isNotEmpty(baseVersionPagination.getVersion())) {
            baseVersionNum++;
            baseVersionQueryWrapper.lambda().like(BaseVersionEntity::getVersion, baseVersionPagination.getVersion());
        }

        if (StringUtils.isNotEmpty(baseVersionPagination.getSendType())) {
            baseVersionNum++;
            baseVersionQueryWrapper.lambda().eq(BaseVersionEntity::getSendType, baseVersionPagination.getSendType());
        }

        if (StringUtils.isNotEmpty(baseVersionPagination.getSendRange())) {
            baseVersionNum++;
            baseVersionQueryWrapper.lambda().like(BaseVersionEntity::getSendRange, baseVersionPagination.getSendRange());
        }

        if (StringUtils.isNotEmpty(baseVersionPagination.getDescription())) {
            baseVersionNum++;
            baseVersionQueryWrapper.lambda().like(BaseVersionEntity::getDescription, baseVersionPagination.getDescription());
        }

        if (StringUtils.isNotEmpty(baseVersionPagination.getEnabledMark())) {
            baseVersionNum++;
            baseVersionQueryWrapper.lambda().eq(BaseVersionEntity::getEnabledMark, baseVersionPagination.getEnabledMark());
        }

        if (AllIdList.size() > 0) {
            baseVersionQueryWrapper.lambda().in(BaseVersionEntity::getId, AllIdList);
        }
        //排序
        if (StringUtils.isEmpty(baseVersionPagination.getSidx())) {
            baseVersionQueryWrapper.lambda().orderByDesc(BaseVersionEntity::getId);
        } else {
            try {
                String sidx = baseVersionPagination.getSidx();
                BaseVersionEntity baseVersionEntity = new BaseVersionEntity();
                Field declaredField = baseVersionEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                baseVersionQueryWrapper = "asc".equals(baseVersionPagination.getSort().toLowerCase()) ? baseVersionQueryWrapper.orderByAsc(value) : baseVersionQueryWrapper.orderByDesc(value);
            } catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ((total > 0 && AllIdList.size() > 0) || total == 0) {
            Page<BaseVersionEntity> page = new Page<>(baseVersionPagination.getCurrentPage(), baseVersionPagination.getPageSize());
            IPage<BaseVersionEntity> userIPage = this.page(page, baseVersionQueryWrapper);
            return baseVersionPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        } else {
            List<BaseVersionEntity> list = new ArrayList();
            return baseVersionPagination.setData(list, list.size());
        }
    }

    /**
     * 系统版本管理列表分页查询（导出使用）
     *
     * @param baseVersionPagination 查询参数
     * @param dataType              0-当前页；非0-当前查询条件所有数据
     * @return List<BaseVersionEntity>
     */
    @Override
    public List<BaseVersionEntity> getTypeList(BaseVersionPagination baseVersionPagination, String dataType) {
        String userId = userProvider.get().getUserId();
        List<String> AllIdList = new ArrayList();
        int total = 0;
        int baseVersionNum = 0;
        QueryWrapper<BaseVersionEntity> baseVersionQueryWrapper = new QueryWrapper<>();
        if (StringUtils.isNotEmpty(baseVersionPagination.getTitle())) {
            baseVersionNum++;
            baseVersionQueryWrapper.lambda().like(BaseVersionEntity::getTitle, baseVersionPagination.getTitle());
        }

        if (StringUtils.isNotEmpty(baseVersionPagination.getVersion())) {
            baseVersionNum++;
            baseVersionQueryWrapper.lambda().like(BaseVersionEntity::getVersion, baseVersionPagination.getVersion());
        }

        if (StringUtils.isNotEmpty(baseVersionPagination.getSendType())) {
            baseVersionNum++;
            baseVersionQueryWrapper.lambda().eq(BaseVersionEntity::getSendType, baseVersionPagination.getSendType());
        }

        if (StringUtils.isNotEmpty(baseVersionPagination.getSendRange())) {
            baseVersionNum++;
            baseVersionQueryWrapper.lambda().like(BaseVersionEntity::getSendRange, baseVersionPagination.getSendRange());
        }

        if (StringUtils.isNotEmpty(baseVersionPagination.getDescription())) {
            baseVersionNum++;
            baseVersionQueryWrapper.lambda().like(BaseVersionEntity::getDescription, baseVersionPagination.getDescription());
        }

        if (StringUtils.isNotEmpty(baseVersionPagination.getEnabledMark())) {
            baseVersionNum++;
            baseVersionQueryWrapper.lambda().eq(BaseVersionEntity::getEnabledMark, baseVersionPagination.getEnabledMark());
        }

        if (AllIdList.size() > 0) {
            baseVersionQueryWrapper.lambda().in(BaseVersionEntity::getId, AllIdList);
        }
        //排序
        if (StringUtils.isEmpty(baseVersionPagination.getSidx())) {
            baseVersionQueryWrapper.lambda().orderByDesc(BaseVersionEntity::getId);
        } else {
            try {
                String sidx = baseVersionPagination.getSidx();
                BaseVersionEntity baseVersionEntity = new BaseVersionEntity();
                Field declaredField = baseVersionEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                baseVersionQueryWrapper = "asc".equals(baseVersionPagination.getSort().toLowerCase()) ? baseVersionQueryWrapper.orderByAsc(value) : baseVersionQueryWrapper.orderByDesc(value);
            } catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if ((total > 0 && AllIdList.size() > 0) || total == 0) {
                Page<BaseVersionEntity> page = new Page<>(baseVersionPagination.getCurrentPage(), baseVersionPagination.getPageSize());
                IPage<BaseVersionEntity> userIPage = this.page(page, baseVersionQueryWrapper);
                return baseVersionPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            } else {
                List<BaseVersionEntity> list = new ArrayList();
                return baseVersionPagination.setData(list, list.size());
            }
        } else {
            return this.list(baseVersionQueryWrapper);
        }
    }

    /**
     * 获取系统版本管理详细信息
     *
     * @param id 主键
     * @return BaseVersionEntity
     */
    @Override
    public BaseVersionEntity getInfo(String id) {
        QueryWrapper<BaseVersionEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(BaseVersionEntity::getId, id);
        return this.getOne(queryWrapper);
    }

    /**
     * 创建系统版本管理操作
     *
     * @param baseVersionCrForm 主键
     * @return boolean 是否成功
     */
    @Override
    @DSTransactional
    public void create(BaseVersionCrForm baseVersionCrForm) {
        String mainId = RandomUtil.uuId();
        BaseVersionEntity entity = JsonUtil.getJsonToBean(baseVersionCrForm, BaseVersionEntity.class);
        entity.setId(mainId);
        this.save(entity);

    }

    /**
     * 更新系统版本管理操作
     *
     * @param id                主键
     * @param baseVersionUpForm 主键
     * @return boolean 是否成功
     */
    @Override
    @DSTransactional
    public void update(String id, BaseVersionUpForm baseVersionUpForm) {
        UserInfo userInfo = userProvider.get();
        BaseVersionEntity entity = this.getInfo(id);
        if (entity != null) {
            BaseVersionEntity subentity = JsonUtil.getJsonToBean(baseVersionUpForm, BaseVersionEntity.class);
            this.updateById(subentity);
        }
    }

    @Override
    public ActionResult release(String id) {
        UserInfo userInfo = userProvider.get();
        BaseVersionEntity entity = this.getInfo(id);
        entity.setId(id);
        entity.setEnabledMark(EnabledMarkEnum.RELEASED.getStatus());
        entity.setSendTime(new Date());
        entity.setSendUserId(userInfo.getUserId());
        if(entity.getSendType().equals("1")||entity.getSendType().equals("2")){
            send(entity);
        }
        this.updateById(entity);
        return ActionResult.success("发布成功");

    }

    @Override
    public void send(BaseVersionEntity entity) {
        entity.setIsSend(BaseVersionSendMarkEnum.SEND.getStatus());
        entity.setSendUserId(userProvider.get().getUserId());
        String taskCode = MessageConstants.MESSAGE_TEMPLATE_TASKCODE;
        String sendCode = MessageConstants.MESSAGE_TEMPLATE_SENDCODE;
        HashMap<String, String> keys = MapUtil.newHashMap();
        keys.put("title", entity.getTitle());
        keys.put("tip", "（版本：V" + entity.getVersion() + "）");
        keys.put("content", "更新内容：\n" + entity.getContent());
        keys.put("tag", "更新日期：" + cn.hutool.core.date.DateUtil.today());
        keys.put("sendUser", entity.getSendUserId());
        keys.put("sendTime", DateUtil.getNow());
        keys.put("isNewDialog", "1");
        //接收人
        List<String> toUserIds = CollectionUtil.list(false);
        if (entity.getSendType().equals("1")) {
            //全部发送
            toUserIds = userService.getListId();
        }else if (entity.getSendType().equals("2")) {
            //指定范围发送
            String sendRange = entity.getSendRange();
            List<UserEntity> rangeUserList = rangeService.getRangeUserList(sendRange);
            toUserIds = rangeUserList.stream().map(UserEntity::getId).collect(Collectors.toList());
        }
        sendMessageNew(taskCode, sendCode, keys, null, null,
                null, CollectionUtil.join(toUserIds, ","), TermTypeEnum.TERM_APP_PC.getCode(), null);
    }

    @Override
    public BaseVersionEntity getVersion() {
        return baseMapper.selectList(new LambdaQueryWrapper<BaseVersionEntity>()
                .orderByDesc(BaseVersionEntity::getCreatorTime)
                .last("LIMIT 1")).stream().findFirst().orElse(null);
    }


    public void sendMessageNew(String taskCode, String sendCode, HashMap<String, String> keys, String linkUrl, String appUrl, String pcUrl, String userId,String termType,String typeDesc) {
        log.info("code:{},接收人:{}",sendCode,userId);
        TaskMsg taskMsg = new TaskMsg();
        taskMsg.setTaskCode(taskCode);
        taskMsg.setSendCode(sendCode);
        LinkMsgKeys linkMsgKeys = new LinkMsgKeys();
        linkMsgKeys.setKeys(keys);

        linkMsgKeys.setLinkUrl("");
        CustomKeysLink customKeysLink = new CustomKeysLink();
        //消息链接多端类型 1:支持app端;2:支持pc端;3:支持app和pc端
        customKeysLink.setTermType(termType);
//       消息链接多端类型 提示内容
        customKeysLink.setTermTypeDesc(typeDesc);
        customKeysLink.setPcUrl(pcUrl);
        customKeysLink.setAppUrl(appUrl);
        taskMsg.setCustomKey(customKeysLink);
        taskMsg.setBusinessKey(linkMsgKeys);
        taskMsg.setToUserIds(userId);
        try {
            sendTaskMsgUtils.sendTaskMsg(taskMsg);
        } catch (Exception e) {
            log.error("发送消息异常:" + e.getMessage());
            e.printStackTrace();
        }
    }

    /**
     * 删除系统版本管理操作
     *
     * @param entity
     * @return
     */
    @Override
    @DSTransactional
    public void delete(BaseVersionEntity entity) {
        if (entity != null) {
            this.removeById(entity.getId());
        }
    }
    //子表方法


}