package com.bringspring.system.external.config.mutil;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.config.ProxyConfigProperties;
import com.bringspring.system.msgcenter.entity.McMsgAccountEntity;
import com.bringspring.system.msgcenter.service.McMsgAccountService;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.common.error.WxRuntimeException;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.api.impl.WxMpServiceImpl;
import me.chanjar.weixin.mp.config.impl.WxMpDefaultConfigImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.bringspring.system.msgcenter.enums.ChannelTypeEnum.WX_MP;

/**
 * @author <a href="https://github.com/binarywang">Binary Wang</a>
 */
@Slf4j
@Component
public class WxMpConfiguration {

    @Autowired
    private McMsgAccountService mcMsgAccountService;

    @Autowired
    private ProxyConfigProperties proxyConfigProperties;

    private Map<String, McMsgAccountEntity> accounts = Maps.newHashMap();

    private WxMpService wxMpService;

    public WxMpConfiguration(){
        this.wxMpService =  new WxMpServiceImpl();
    }

    public WxMpService getWxMpService(String appId) {
//        if (!wxMpService.switchover(appId)) {
            initWxMpService();
            if (!wxMpService.switchover(appId)) {
                throw new IllegalArgumentException(String.format("未找到对应appid=[%s]的配置，请核实！", appId));
            }
//        }
        return wxMpService;
    }

    public McMsgAccountEntity getAccount(String appId) {
        McMsgAccountEntity account = accounts.get(appId);
        if (ObjectUtil.isEmpty(account)) {
            initWxMpService();
            account = accounts.get(appId);
        }
        return account;
    }

    public void initWxMpService() {
        List<McMsgAccountEntity> account = mcMsgAccountService.getAccountByCategory(WX_MP.getCode());
        if (CollectionUtil.isEmpty(account)) {
            throw new WxRuntimeException("未添加微信公众号相关账号配置！");
        }
        wxMpService.setMultiConfigStorages(
                account.stream()
                        .map(a -> {
                            WxMpDefaultConfigImpl config = new WxMpDefaultConfigImpl();
                            config.setAppId(a.getAppId());
                            config.setSecret(a.getAppSecret());
                            config.setToken(a.getAgentId());
                            config.setAesKey(a.getBearer());
                            //是否设置代理
                            if (proxyConfigProperties.isEnabled()) {
                                config.setHttpProxyHost(proxyConfigProperties.getHost());
                                config.setHttpProxyPort(proxyConfigProperties.getPort());
                                config.setHttpProxyUsername(proxyConfigProperties.getUsername());
                                config.setHttpProxyPassword(proxyConfigProperties.getPassword());
                            }
                            return config;
                        }).collect(Collectors.toMap(WxMpDefaultConfigImpl::getAppId, a -> a, (o, n) -> o)));

        account.stream().forEach(a -> {
            accounts.put(a.getAppId(), a);
        });
    }


}
