package com.bringspring.system.msgcenter.constant;


/**
 * 消息中心-字典类型枚举
 */
public enum DictType {

    /** WebHook渠道分类 */
    WEB_HOOK_TYPE("msgWebHookSendType"),

    /** 短信渠道分类 */
    SMS_TYPE("smsSendType"),

    /** 消息渠道分类 */
    MSG_TYPE("msgSendType"),

    /** 消息分类 */
    MESSAGE_TYPE("msgType"),

    /** 业务系统 */
    TASK_CODE("taskCode");

    private final String code;

    DictType(String code) {
        this.code = code;
    }

    public String getCode() {
        return code;
    }
}
