package com.bringspring.system.msgcenter.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.bringspring.system.msgcenter.entity.McMsgAccountEntity;
import com.bringspring.system.msgcenter.model.mcmsgaccount.McMsgAccountCrForm;
import com.bringspring.system.msgcenter.model.mcmsgaccount.McMsgAccountPagination;
import com.bringspring.system.msgcenter.model.mcmsgaccount.McMsgAccountUpForm;

import java.util.List;

/**
 * 账号配置表
 * 版本： V1.0.0
 * 版权： 荣科科技股份有限公司
 * 作者： RKKJ开发平台组
 * 日期： 2024-06-03
 */
public interface McMsgAccountService extends IService<McMsgAccountEntity> {

    List<McMsgAccountEntity> getList(McMsgAccountPagination mcMsgAccountPagination);

    List<McMsgAccountEntity> getTypeList(McMsgAccountPagination mcMsgAccountPagination, String dataType);

    List<McMsgAccountEntity> getAccountByCategory(String category);

    McMsgAccountEntity getInfo(String id);

    void delete(McMsgAccountEntity entity);

    void create(McMsgAccountCrForm mcMsgAccountCrForm);

    boolean update(String id, McMsgAccountUpForm mcMsgAccountUpForm);

    /**
     * 校验编码code的唯一
     *
     * @return 结果
     */
    boolean checkEnCodeUnique(String enCode, String id);
    /**
     * 校验名称的唯一
     *
     * @return 结果
     */
    boolean checkFullNameUnique(String fullName, String id);
}
