package com.bringspring.system.permission.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 操作权限
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月26日 上午9:18
 */
@Data
@TableName("BASE_AUTHORIZE")
public class AuthorizeEntity implements Serializable {
    /**
     * 权限主键
     */
    @TableId("ID")
    private String id;

    /**
     * 项目类型
     */
    @TableField("ITEM_TYPE")
    private String itemType;

    /**
     * 项目主键
     */
    @TableField("ITEM_ID")
    private String itemId;

    /**
     * 对象类型
     */
    @TableField("OBJECT_TYPE")
    private String objectType;

    /**
     * 对象主键
     */
    @TableField("OBJECT_ID")
    private String objectId;

    /**
     * 排序码
     */
    @TableField("SORT_CODE")
    private Long sortCode;

    /**
     * 创建时间
     */
    @TableField(value = "CREATOR_TIME",fill = FieldFill.INSERT)
    private Date creatorTime;

    /**
     * 创建用户
     */
    @TableField(value = "CREATOR_USER_ID",fill = FieldFill.INSERT)
    private String creatorUserId;
}
