package com.bringspring.system.permission.mcp;

import com.alibaba.fastjson.JSONObject;
import com.bringspring.ai.service.McpBaseServer;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.UserSimple;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import org.noear.solon.ai.annotation.ToolMapping;
import org.noear.solon.ai.mcp.client.McpClientProvider;
import org.noear.solon.ai.mcp.server.annotation.McpServerEndpoint;
import org.noear.solon.annotation.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.Map;

/**
 * 权限MCP服务端实现类
 * */
@Service
@McpServerEndpoint(name="permission", sseEndpoint = "/mcp/permission")
public class PermissionMcpServiceImpl implements McpBaseServer {

    @Autowired
    private UserProvider userProvider;

    /**
     * 获取当前登陆人信息
     *
     * @param token 登录token
     * @return 当前登陆人信息
     * */
    @ToolMapping(name = "getUserSimple", description = "获取当前登陆人信息")
    public String getUserSimple(@Param(name = "token", description = "登录token", required = true) String token) {
        UserInfo userInfo = userProvider.get(token);
        UserSimple userSimple = JsonUtil.getJsonToBean(userInfo, UserSimple.class);
        return JSONObject.toJSONString(userSimple);
    }
    public static void main(String[] args) {
        McpClientProvider toolProvider = McpClientProvider.builder()
                .apiUrl("http://localhost:30000/mcp/permission")
                .build();
        //工具
        Map<String, Object> map = Collections.singletonMap("token", "bearer eyJhbGciOiJSUzI1NiIsInR5cCI6IkpXVCJ9.eyJ1c2VyX25hbWUiOiJhZG1pbiIsInNjb3BlIjpbImFsbCJdLCJzaW5nbGVMb2dpbiI6MiwiZXhwIjoxNzU0NDg3Njc0LCJqdGkiOiIzdDJSbFpRTXd4ek5OamlhN0VRaERLNzdoRFEiLCJjbGllbnRfaWQiOiJhZG1pbiIsInRva2VuIjoibG9naW5fdG9rZW5fNzIyNzEyNDM3NTM4Njg0OTMzIn0.AhT7FeR_G228mq543kyDy86_fuRRod8yXJHMUihOAV7-x2mfMDEWGOd-cpIOnL0GKkH2P1zRXJc7YqnunNnHTKzh0otV3o0kyhDF7Jj8IGuQFReuMPkH_IEpeJkYXQpS1fc6eidFaaTS6lOo6dUTplZ1xG9ywalGaKgCwqnxNdQspK0VQ_0UdRSTTVFc5sLU2lCYTpgr3vW_e_jspUC1QaAszkQFLdAl6tjR8tY4Idfz814_L6KRU4Yp8PcT6KrVy1TVlpaYxjK-vp38I5fYm22WByyrhb2dCUe3xZXdW54mVhv_RYbIbrIwp-FjYAxIj701V1mdTP5RRm4Z6fGDOQ");
        String rst = toolProvider.callToolAsText("getUserSimple", map).getContent();
        System.out.println(rst);
    }
}