package com.bringspring.system.permission.service.strategy;

import com.alibaba.fastjson.JSON;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.enums.AuthorizeConditionEnum;
import com.bringspring.common.util.enums.DateFormatEnum;
import com.bringspring.common.util.enums.SearchMethodEnum;
import org.springframework.stereotype.Component;

import java.util.*;

import static com.bringspring.common.util.enums.SearchMethodEnum.*;

/**
 * This class is used to handle the DatePickerNumberStrategy.
 */
@Component
public class ContentPickerDate extends FieldContentDateStrategy {

    public ContentPickerDate() {
        super();
        this.order = 10;
        this.conditionOptions = new ArrayList<>();
        conditionOptions.add(new HashMap<String, Object>() {{
            put("value", AuthorizeConditionEnum.DATATIME.getCondition());
            put("label", AuthorizeConditionEnum.DATATIME.getMessage());
        }});
        this.formatOptions = DateFormatEnum.getFormatOptions();
        this.symbolOptions = SearchMethodEnum.getSymbolOptionsDateNum();
    }

    @Override
    public Object convertFieldContent(String fieldContent, String symbol, String format) {
        List<String> validSymbols = Arrays.asList(
                Equal.getSymbol(),
                NotEqual.getSymbol(),
                GreaterThan.getSymbol(),
                LessThan.getSymbol(),
                GreaterThanOrEqual.getSymbol(),
                LessThanOrEqual.getSymbol()
        );
        // 符号为==、<>、>、<、>=、<=时，字段内容直接格式化
        if (validSymbols.contains(symbol)) {
            // 日期格式化
            return DateUtil.format(new Date(Long.parseLong(fieldContent)), format);
//            value = valueLabel;
        } else if (Between.getSymbol().equals(symbol)) {
            // 日期格式化
            List<Long> formatDates = JSON.parseArray(fieldContent, Long.class);
            String formatDate1 = DateUtil.format(new Date(formatDates.get(0)), format);
            String formatDate2 = DateUtil.format(new Date(formatDates.get(1)), format);
            return Arrays.asList(formatDate1, formatDate2);
            // 日期格式化
//            String[] formatDates = valueLabel.split(PART_COMMA);
//            // 设置tw的查询条件
//            tw.between(fieldName, formatDates[0], formatDates[1]);

        } else {
            return fieldContent;
        }
    }
}
