package com.bringspring.system.permission.util;

import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.permission.model.authorize.AuthorizeDataReturnModel;

import java.util.*;

/**
 * 树结构数组深度去重工具
 */
public class RecursiveRemovalUtil {
    public static void main(String[] args) {
        // 假设这是你的原始数据
//        String jsonInput = "[{\"id\":\"444023864675010437\",\"fullName\":\"固定资产系统\",\"icon\":\"el-icon-s-order\",\"sortCode\":20,\"children\":\n" +
//                "[{\"id\":\"445967278584890757\",\"fullName\":\"固定资产设置\",\"icon\":\"icon-ym icon-ym-report-icon-configuration\",\"sortCode\":99,\"children\":[{\"id\":\"445966331020313989\",\"fullName\":\"固定资产字典\",\"icon\":\"ym-custom ym-custom-view-module\",\"sortCode\":99,\"children\":[{\"id\":\"445966332937110917\",\"fullName\":\"新增\",\"icon\":\"el-icon-plus\",\"sortCode\":0}]}]}]},\n" +
//                "{\"id\":\"444023864675010437\",\"fullName\":\"固定资产系统\",\"icon\":\"el-icon-s-order\",\"sortCode\":20,\"children\":\n" +
//                "[{\"id\":\"445967278584890757\",\"fullName\":\"固定资产设置\",\"icon\":\"icon-ym icon-ym-report-icon-configuration\",\"sortCode\":99,\"children\":[{\"id\":\"445966331020313989\",\"fullName\":\"固定资产字典\",\"icon\":\"ym-custom ym-custom-view-module\",\"sortCode\":99,\"children\":[{\"id\":\"4459663329371109115\",\"fullName\":\"删除\",\"icon\":\"el-icon-plus\",\"sortCode\":0}]}]}]},\n" +
//                "{\"id\":\"444023864675010434\",\"fullName\":\"人事管理\",\"icon\":\"el-icon-s-order\",\"sortCode\":20,\"children\":\n" +
//                "[{\"id\":\"445967278584890751\",\"fullName\":\"人事设置\",\"icon\":\"icon-ym icon-ym-report-icon-configuration\",\"sortCode\":99,\"children\":[{\"id\":\"445966331020313981\",\"fullName\":\"人事字典\",\"icon\":\"ym-custom ym-custom-view-module\",\"sortCode\":99,\"children\":[{\"id\":\"4459663329371109111\",\"fullName\":\"删除\",\"icon\":\"el-icon-plus\",\"sortCode\":0}]}]}]}]";
//        List<AuthorizeDataReturnModel> originalList = JsonUtil.getJsonToList(jsonInput,AuthorizeDataReturnModel.class);
        String jsonInput = "[{\"id\":\"444023864675010437\",\"fullName\":\"固定资产系统\",\"icon\":\"el-icon-s-order\",\"sortCode\":20,\"children\":\n" +
                "[{\"id\":\"445967278584890757\",\"fullName\":\"固定资产设置\",\"icon\":\"icon-ym icon-ym-report-icon-configuration\",\"sortCode\":99,\"children\":[{\"id\":\"445966331020313989\",\"fullName\":\"固定资产字典\",\"icon\":\"ym-custom ym-custom-view-module\",\"sortCode\":99,\"children\":[{\"id\":\"445966332937110917\",\"fullName\":\"新增\",\"icon\":\"el-icon-plus\",\"sortCode\":0}]}]}]},\n" +
                "{\"id\":\"444023864675010437\",\"fullName\":\"固定资产系统\",\"icon\":\"el-icon-s-order\",\"sortCode\":20,\"children\":\n" +
                "[{\"id\":\"445967278584890757\",\"fullName\":\"固定资产设置\",\"icon\":\"icon-ym icon-ym-report-icon-configuration\",\"sortCode\":99,\"children\":[{\"id\":\"445966331020313989\",\"fullName\":\"固定资产字典\",\"icon\":\"ym-custom ym-custom-view-module\",\"sortCode\":99,\"children\":[{\"id\":\"4459663329371109115\",\"fullName\":\"删除\",\"icon\":\"el-icon-plus\",\"sortCode\":0}]}]}]},\n" +
                "{\"id\":\"444023864675010437\",\"fullName\":\"固定资产系统\",\"icon\":\"el-icon-s-order\",\"sortCode\":20,\"children\":\n" +
                "[{\"id\":\"4459672785848907571\",\"fullName\":\"固定资产设置1\",\"icon\":\"icon-ym icon-ym-report-icon-configuration\",\"sortCode\":99,\"children\":[{\"id\":\"4459663310203139891\",\"fullName\":\"固定资产字典1\",\"icon\":\"ym-custom ym-custom-view-module\",\"sortCode\":99,\"children\":[{\"id\":\"4459663329371109115\",\"fullName\":\"删除\",\"icon\":\"el-icon-plus\",\"sortCode\":0}]}]}]},\n" +
                "{\"id\":\"444023864675010434\",\"fullName\":\"人事管理\",\"icon\":\"el-icon-s-order\",\"sortCode\":20,\"children\":\n" +
                "[{\"id\":\"445967278584890751\",\"fullName\":\"人事设置\",\"icon\":\"icon-ym icon-ym-report-icon-configuration\",\"sortCode\":99,\"children\":[{\"id\":\"445966331020313981\",\"fullName\":\"人事字典\",\"icon\":\"ym-custom ym-custom-view-module\",\"sortCode\":99,\"children\":[{\"id\":\"4459663329371109111\",\"fullName\":\"删除\",\"icon\":\"el-icon-plus\",\"sortCode\":0}]}]}]}]";
        List<AuthorizeDataReturnModel> originalList = JsonUtil.getJsonToList(jsonInput,AuthorizeDataReturnModel.class);
        //去重合并
        List<AuthorizeDataReturnModel> authorizeDataReturnModels = deduplicateAndMerge(originalList);
        List<AuthorizeDataReturnModel> authorizeDataReturnModelList = new ArrayList<>();
        //循环得到有根节点的数据
        for (int i =0;i<authorizeDataReturnModels.size();i++) {
            AuthorizeDataReturnModel authorizeDataReturnModel =authorizeDataReturnModels.get(i);
            if(StringUtils.isNotEmpty(authorizeDataReturnModel.getType())){
                authorizeDataReturnModelList.add(authorizeDataReturnModel);
            }
        }
        //验证是否还存在重复数据
        String str = JsonUtil.getListToJsonArray(authorizeDataReturnModelList).toJSONString();
        //如果第一次去重之后存在重复数据，进行深度递归去重处理
        if(str.contains("$ref")){
            authorizeDataReturnModelList = deduplicateAndKeepDeepest(authorizeDataReturnModelList);
        }
        System.out.println(JsonUtil.getListToJsonArray(authorizeDataReturnModelList).toJSONString());
    }

    /**
     * 深度递归比较节点深度保留数据最全的去重方法
      */

    public static List<AuthorizeDataReturnModel> deduplicateAndKeepDeepest(List<AuthorizeDataReturnModel> list) {
        Map<String, AuthorizeDataReturnModel> idNodeMap = new HashMap<>();
        List<AuthorizeDataReturnModel> result = new ArrayList<>();

        for (AuthorizeDataReturnModel node : list) {
            String nodeId = node.getId();

            // 如果当前节点已经在map中，则比较并更新
            if (idNodeMap.containsKey(nodeId)) {
                AuthorizeDataReturnModel existingNode = idNodeMap.get(nodeId);
                if (isDeepest(node, existingNode)) {
                    idNodeMap.put(nodeId, node);
                }
            } else {
                // 如果不在map中，则添加到map和结果列表中
                idNodeMap.put(nodeId, node);
                result.add(node);
            }

            // 递归处理子节点
            if (node.getChildren() != null) {
                node.setChildren(deduplicateAndKeepDeepest(node.getChildren()));
            }
        }

        return result;
    }

    /**
     * 辅助方法，用于比较两个节点的深度
      */

    private static boolean isDeepest(AuthorizeDataReturnModel newNode, AuthorizeDataReturnModel existingNode) {
        if (newNode.getChildren() == null || existingNode.getChildren() == null) {
            return newNode.getChildren() == null && existingNode.getChildren() == null;
        }

        int newNodeDepth = countChildrenDepth(newNode);
        int existingNodeDepth = countChildrenDepth(existingNode);

        return newNodeDepth > existingNodeDepth;
    }

    /**
     * 辅助方法，用于计算节点的深度（子节点的数量）
      */

    private static int countChildrenDepth(AuthorizeDataReturnModel node) {
        if (node.getChildren() == null) {
            return 0;
        }

        int depth = 1;
        for (AuthorizeDataReturnModel child : node.getChildren()) {
            depth += countChildrenDepth(child);
        }

        return depth;
    }

    /**
     * 主要的去重和合并方法
      */

    public static List<AuthorizeDataReturnModel> deduplicateAndMerge(List<AuthorizeDataReturnModel> list) {
        Map<String, AuthorizeDataReturnModel> nodeMap = new HashMap<>();
        List<AuthorizeDataReturnModel> result = new ArrayList<>();

        for (AuthorizeDataReturnModel node : list) {
            String nodeId = node.getId();

            // 如果当前节点已经在map中，则合并
            if (nodeMap.containsKey(nodeId)) {
                AuthorizeDataReturnModel existingNode = nodeMap.get(nodeId);
                existingNode = mergeNodes(existingNode, node);
                nodeMap.put(nodeId, existingNode); // 更新map中的节点
            } else {
                // 如果不在map中，则添加到map和结果列表中
                nodeMap.put(nodeId, node);
                node.setType("root");
                result.add(node);
            }

            // 递归处理子节点
            if (node.getChildren() != null) {
                for (AuthorizeDataReturnModel childNode : node.getChildren()) {
                    deduplicateAndMerge(Collections.singletonList(childNode), nodeMap, result);
                }
            }
        }

        return result;
    }
    /**
     * 用于合并两个节点的方法
      */

    private static AuthorizeDataReturnModel mergeNodes(AuthorizeDataReturnModel node1, AuthorizeDataReturnModel node2) {


        // 合并children列表
        if(StringUtils.isNotEmpty(node2.getChildren())){
            node1.getChildren().addAll(node2.getChildren());
        }


        return node1;
    }
    /**
     * 递归辅助方法，用于处理子节点的去重和合并
      */
    private static void deduplicateAndMerge(List<AuthorizeDataReturnModel> children, Map<String, AuthorizeDataReturnModel> nodeMap, List<AuthorizeDataReturnModel> result) {
        for (AuthorizeDataReturnModel childNode : children) {
            String childNodeId = childNode.getId();

            if (nodeMap.containsKey(childNodeId)) {
                AuthorizeDataReturnModel mergedChild = mergeNodes(nodeMap.get(childNodeId), childNode);
                nodeMap.put(childNodeId, mergedChild); // 更新map中的子节点
            }
            else {
                nodeMap.put(childNodeId, childNode);
                result.add(childNode);
            }

            // 如果子节点还有子节点，继续递归处理
            if (childNode.getChildren() != null) {
                deduplicateAndMerge(childNode.getChildren(), nodeMap, result);
            }
        }
    }
}
