package com.bringspring.system.print.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 打印模板-实体类
 *
 * @author RKKJ开发平台组 YY
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月30日
 */
@Data
@EqualsAndHashCode
@TableName("BASE_PRINT_DEV")
public class PrintDevEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 主键_id
     */
    @TableId("ID")
    private String id;

    /**
     * 名称
     */
    @TableField("FULL_NAME")
    private String fullName;

    /**
     * 编码
     */
    @TableField("ENCODE")
    private String enCode;

    /**
     * 分类
     */
    @TableField("CATEGORY")
    private String category;

    /**
     * 类型
     */
    @TableField("TYPE")
    private Integer type;

    /**
     * 连接数据 _id
     */
    @TableField("DB_LINK_ID")
    private String dbLinkId;

    /**
     * sql语句
     */
    @TableField("SQL_TEMPLATE")
    private String sqlTemplate;

    /**
     * 左侧字段
     */
    @TableField("LEFT_FIELDS")
    private String leftFields;

    /**
     * 打印模板
     */
    @TableField("PRINT_TEMPLATE")
    private String printTemplate;
    /**
     * 描述
     */
    @TableField("DESCRIPTION")
    private String description;

    /**
     * 排序码
     */
    @TableField("SORT_CODE")
    private Long sortCode;

    /**
     * 有效标志
     */
    @TableField("ENABLED_MARK")
    private Integer enabledMark;

    /**
     * 创建时间
     */
    @TableField(value = "CREATOR_TIME",fill = FieldFill.INSERT)
    private Date creatorTime;

    /**
     * 创建用户_id
     */
    @TableField(value = "CREATOR_USER_ID",fill = FieldFill.INSERT)
    private String creatorUserId;

    /**
     * 修改时间
     */
    @TableField(value = "LAST_MODIFY_TIME",fill = FieldFill.UPDATE)
    private Date lastModifyTime;

    /**
     * 修改用户_id
     */
    @TableField(value = "LAST_MODIFY_USER_ID",fill = FieldFill.UPDATE)
    private String lastModifyUserId;

    /**
     * 删除标志
     */
    @TableField("DELETE_MARK")
    private Integer deleteMark;

    /**
     * 删除时间
     */
    @TableField("DELETE_TIME")
    private Date deleteTime;

    /**
     * 删除用户_id
     */
    @TableField("DELETE_USER_ID")
    private String deleteUserId;



}
