/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.controller;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.model.login.BaseSystemInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.treeutil.newtreeutil.TreeDotUtils;
import com.bringspring.system.base.listener.DIngStream;
import com.bringspring.system.base.model.dingding.DingDeptModel;
import com.bringspring.system.base.model.dingding.DingUserIdModel;
import com.bringspring.system.base.model.dingding.DingUserModel;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.message.model.message.OraganizeListVO;
import com.bringspring.system.message.service.SynThirdDingTalkService;
import com.bringspring.system.message.service.SynThirdInfoService;
import com.bringspring.system.message.service.SynThirdQyService;
import com.bringspring.system.message.util.SynDingTalkUtil;
import com.bringspring.system.message.util.SynThirdTotal;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.RoleEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.model.organize.OrganizeModel;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.PositionService;
import com.bringspring.system.permission.service.RoleService;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.request.OapiGettokenRequest;
import com.dingtalk.api.request.OapiUserListidRequest;
import com.dingtalk.api.request.OapiV2UserGetRequest;
import com.dingtalk.api.response.OapiGettokenResponse;
import com.dingtalk.api.response.OapiUserListidResponse;
import com.dingtalk.api.response.OapiV2UserGetResponse;
import com.dingtalk.open.app.api.GenericEventListener;
import com.dingtalk.open.app.api.OpenDingTalkStreamClientBuilder;
import com.dingtalk.open.app.api.message.GenericOpenDingTalkEvent;
import com.dingtalk.open.app.api.security.AuthClientCredential;
import com.dingtalk.open.app.api.security.DingTalkCredential;
import com.dingtalk.open.app.stream.protocol.event.EventAckStatus;
import com.taobao.api.TaobaoRequest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.chanjar.weixin.cp.api.WxCpService;
import org.apdplat.word.tagging.PinyinTagging;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7b2c\u4e09\u65b9\u4fe1\u606f\u540c\u6b65"}, value="SynThirdInfo")
@RestController
@RequestMapping(value={"/api/system/SynThirdInfo"})
public class SynThirdInfoController {
    private static final Logger log = LoggerFactory.getLogger(SynThirdInfoController.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private SynThirdInfoService synThirdInfoService;
    @Autowired
    private SynThirdQyService synThirdQyService;
    @Autowired
    private SynThirdDingTalkService synThirdDingTalkService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    PositionService positionService;
    @Autowired
    private UserService userService;
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private DIngStream dIngStream;
    private WxCpService wxCpService;

    @ApiOperation(value="\u83b7\u53d6\u7b2c\u4e09\u65b9(\u5982\uff1a\u4f01\u4e1a\u5fae\u4fe1\u3001\u9489\u9489)\u7684\u7ec4\u7ec7\u4e0e\u7528\u6237\u540c\u6b65\u7edf\u8ba1\u4fe1\u606f")
    @GetMapping(value={"/getSynThirdTotal/{thirdType}"})
    public ActionResult getSynThirdTotal(@PathVariable(value="thirdType") String thirdType) {
        ArrayList<SynThirdTotal> synTotalList = new ArrayList<SynThirdTotal>();
        synTotalList.add(this.synThirdInfoService.getSynTotal(thirdType, "1"));
        synTotalList.add(this.synThirdInfoService.getSynTotal(thirdType, "2"));
        return ActionResult.success(synTotalList);
    }

    @ApiOperation(value="\u83b7\u53d6\u7b2c\u4e09\u65b9(\u5982\uff1a\u4f01\u4e1a\u5fae\u4fe1\u3001\u9489\u9489)\u7684\u7ec4\u7ec7\u6216\u7528\u6237\u540c\u6b65\u7edf\u8ba1\u4fe1\u606f")
    @GetMapping(value={"/getSynThirdTotal/{thirdType}/{dataType}"})
    public SynThirdTotal getSynThirdTotal(@PathVariable(value="thirdType") String thirdType, @PathVariable(value="dataType") String dataType) {
        SynThirdTotal synThirdTotal = this.synThirdInfoService.getSynTotal(thirdType, dataType);
        return synThirdTotal;
    }

    @ApiOperation(value="\u672c\u5730\u6240\u6709\u7ec4\u7ec7\u4fe1\u606f(\u5305\u542b\u516c\u53f8\u548c\u90e8\u95e8)\u540c\u6b65\u5230\u9489\u9489")
    @PostMapping(value={"/synAllOrganizeSysToDing"})
    public ActionResult synAllOrganizeSysToDing(@RequestBody BaseSystemInfo config) {
        JSONObject retMsg = new JSONObject();
        String corpId = config.getClientId();
        String corpSecret = config.getClientSecrent();
        try {
            JSONObject tokenObject = SynDingTalkUtil.getAccessToken(corpId, corpSecret);
            if (!tokenObject.getBoolean("code").booleanValue()) {
                return ActionResult.fail((String)"\u83b7\u53d6\u9489\u9489\u7684access_token\u5931\u8d25");
            }
            String access_token = tokenObject.getString("access_token");
            List<SynThirdInfoEntity> synThirdInfoList = this.synThirdInfoService.getList("2", "1");
            List<OrganizeEntity> organizeList = this.organizeService.getList();
            List organizeModelList = JsonUtil.getJsonToList(organizeList, OrganizeModel.class);
            List trees = TreeDotUtils.convertListToTreeDot((List)organizeModelList);
            List listVO = JsonUtil.getJsonToList((Object)trees, OraganizeListVO.class);
            ArrayList<OrganizeEntity> listByOrder = new ArrayList<OrganizeEntity>();
            for (OraganizeListVO organizeVo : listVO) {
                OrganizeEntity entity = organizeList.stream().filter(t -> t.getId().equals(organizeVo.getId())).findFirst().orElse(null);
                listByOrder.add(entity);
                SynDingTalkUtil.getOrganizeTreeToList(organizeVo, organizeList, listByOrder);
            }
            for (SynThirdInfoEntity synThirdInfoEntity : synThirdInfoList) {
                if (organizeList.stream().filter(t -> t.getId().equals(synThirdInfoEntity.getSystemObjectId())).count() != 0L) continue;
                retMsg = this.synThirdDingTalkService.deleteDepartmentSysToDing(true, synThirdInfoEntity.getSystemObjectId(), access_token);
            }
            synThirdInfoList = this.synThirdInfoService.getList("2", "1");
            for (OrganizeEntity organizeEntity : listByOrder) {
                if (synThirdInfoList.stream().filter(t -> t.getSystemObjectId().equals(organizeEntity.getId())).count() > 0L) {
                    retMsg = this.synThirdDingTalkService.updateDepartmentSysToDing(true, organizeEntity, access_token);
                    continue;
                }
                retMsg = this.synThirdDingTalkService.createDepartmentSysToDing(true, organizeEntity, access_token);
            }
        }
        catch (Exception e) {
            ActionResult.fail((String)e.toString());
        }
        SynThirdTotal synThirdTotal = this.synThirdInfoService.getSynTotal("2", "1");
        return ActionResult.success((Object)synThirdTotal);
    }

    @ApiOperation(value="\u672c\u5730\u6240\u6709\u7528\u6237\u4fe1\u606f\u540c\u6b65\u5230\u9489\u9489")
    @PostMapping(value={"/synAllUserSysToDing"})
    public ActionResult synAllUserSysToDing(@RequestBody BaseSystemInfo config) throws ParseException {
        JSONObject retMsg = new JSONObject();
        String corpId = config.getClientId();
        String corpSecret = config.getClientSecrent();
        try {
            JSONObject tokenObject = SynDingTalkUtil.getAccessToken(corpId, corpSecret);
            if (!tokenObject.getBoolean("code").booleanValue()) {
                return ActionResult.success((String)"\u83b7\u53d6\u9489\u9489\u7684access_token\u5931\u8d25");
            }
            String access_token = tokenObject.getString("access_token");
            List<SynThirdInfoEntity> synThirdInfoList = this.synThirdInfoService.getList("2", "2");
            List<UserEntity> userList = this.userService.getList();
            for (SynThirdInfoEntity synThirdInfoEntity : synThirdInfoList) {
                if (userList.stream().filter(t -> t.getId().equals(synThirdInfoEntity.getSystemObjectId())).count() != 0L) continue;
                retMsg = this.synThirdDingTalkService.deleteUserSysToDing(true, synThirdInfoEntity.getSystemObjectId(), access_token);
            }
            for (UserEntity userEntity : userList) {
                if (synThirdInfoList.stream().filter(t -> t.getSystemObjectId().equals(userEntity.getId())).count() == 0L) {
                    retMsg = this.synThirdDingTalkService.createUserSysToDing(true, userEntity, access_token);
                    continue;
                }
                retMsg = this.synThirdDingTalkService.updateUserSysToDing(true, userEntity, access_token);
            }
        }
        catch (Exception e) {
            ActionResult.fail((String)e.toString());
        }
        SynThirdTotal synThirdTotal = this.synThirdInfoService.getSynTotal("2", "2");
        return ActionResult.success((Object)synThirdTotal);
    }

    public static void main(String[] args) throws Exception {
        OpenDingTalkStreamClientBuilder.custom().credential((DingTalkCredential)new AuthClientCredential("dingqgbtl0pzm45qbonu", "299RRMGBuD-Hsw9LE76DzJi-ApKmq3MABXm-tS8-plFFt189RrSJi_qB0U7tAot1")).registerAllEventListener(new GenericEventListener(){

            public EventAckStatus onEvent(GenericOpenDingTalkEvent event) {
                try {
                    String eventId = event.getEventId();
                    String eventType = event.getEventType();
                    Long bornTime = event.getEventBornTime();
                    JSONObject bizData = event.getData();
                    PinyinTagging.process((List)((List)bizData));
                    return EventAckStatus.SUCCESS;
                }
                catch (Exception e) {
                    return EventAckStatus.LATER;
                }
            }
        }).build().start();
    }

    @ApiOperation(value="\u9489\u9489\u6240\u6709\u7ec4\u7ec7\u4fe1\u606f(\u5305\u542b\u516c\u53f8\u548c\u90e8\u95e8)\u540c\u6b65\u5230\u672c\u5730")
    @PostMapping(value={"/synDingToAllOrganizeSys"})
    public ActionResult synDingToAllOrganizeSys(@RequestBody BaseSystemInfo config) throws Exception {
        DefaultDingTalkClient clientToken = new DefaultDingTalkClient("https://oapi.dingtalk.com/gettoken");
        OapiGettokenRequest req = new OapiGettokenRequest();
        req.setAppkey(config.getQyhCorpId());
        req.setAppsecret(config.getQyhCorpSecret());
        req.setHttpMethod("GET");
        OapiGettokenResponse rsp = (OapiGettokenResponse)clientToken.execute((TaobaoRequest)req);
        System.out.println(rsp.getBody());
        Map stringObjectMap = JsonUtil.stringToMap((String)rsp.getBody());
        if (!stringObjectMap.containsKey("access_token")) {
            throw new Exception("\u83b7\u53d6\u9489\u9489access_token\u5931\u8d25");
        }
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/v2/department/listsub");
        OapiGettokenResponse execute = (OapiGettokenResponse)client.execute((TaobaoRequest)req, String.valueOf(stringObjectMap.get("access_token")));
        System.out.println(execute.getBody());
        List resultDepart = JsonUtil.getJsonToList((String)String.valueOf(JsonUtil.stringToMap((String)execute.getBody()).get("result")), DingDeptModel.class);
        return this.dIngStream.orgAOD(resultDepart, config.getQyhCorpId());
    }

    @ApiOperation(value="\u9489\u9489\u6240\u6709\u7528\u6237\u540c\u6b65\u5230\u672c\u5730")
    @PostMapping(value={"/synDingToAllUserSys"})
    public ActionResult synDingToAllUserSys(@RequestBody BaseSystemInfo config) throws Exception {
        String qyhCorpId = config.getQyhCorpId();
        DefaultDingTalkClient clientToken = new DefaultDingTalkClient("https://oapi.dingtalk.com/gettoken");
        OapiGettokenRequest req = new OapiGettokenRequest();
        req.setAppkey(qyhCorpId);
        req.setAppsecret(config.getQyhCorpSecret());
        req.setHttpMethod("GET");
        OapiGettokenResponse rsp = (OapiGettokenResponse)clientToken.execute((TaobaoRequest)req);
        System.out.println(rsp.getBody());
        Map stringObjectMap = JsonUtil.stringToMap((String)rsp.getBody());
        if (!stringObjectMap.containsKey("access_token")) {
            throw new Exception("\u83b7\u53d6\u9489\u9489access_token\u5931\u8d25");
        }
        String accessToken = String.valueOf(stringObjectMap.get("access_token"));
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/v2/department/listsub");
        OapiGettokenResponse execute = (OapiGettokenResponse)client.execute((TaobaoRequest)req, accessToken);
        System.out.println(execute.getBody());
        ArrayList<DingDeptModel> resultDepart = new ArrayList<DingDeptModel>();
        DingDeptModel dingDeptModelPar = new DingDeptModel();
        dingDeptModelPar.setDept_id("1");
        resultDepart.add(dingDeptModelPar);
        resultDepart.addAll(JsonUtil.getJsonToList((String)String.valueOf(JsonUtil.stringToMap((String)execute.getBody()).get("result")), DingDeptModel.class));
        ArrayList<DingUserModel> resultUserList = new ArrayList<DingUserModel>();
        List<RoleEntity> listByEnCode = this.roleService.getListByEnCode("SimpleUser");
        List<SynThirdInfoEntity> listThird = this.synThirdInfoService.getList("1", "2");
        UserInfo userInfo = this.userProvider.get();
        if (!ObjectUtil.isEmpty(resultDepart)) {
            for (int i = 0; i < resultDepart.size(); ++i) {
                DingDeptModel dingDeptModel = (DingDeptModel)resultDepart.get(i);
                DefaultDingTalkClient clientUserId = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/user/listid");
                OapiUserListidRequest reqUserId = new OapiUserListidRequest();
                reqUserId.setDeptId(Long.valueOf(dingDeptModel.getDept_id()));
                OapiUserListidResponse rspUserId = (OapiUserListidResponse)clientUserId.execute((TaobaoRequest)reqUserId, accessToken);
                System.out.println(rspUserId.getBody());
                DingUserIdModel resultId = (DingUserIdModel)JsonUtil.getJsonToBean((String)String.valueOf(JsonUtil.stringToMap((String)rspUserId.getBody()).get("result")), DingUserIdModel.class);
                if (ObjectUtil.isEmpty((Object)resultId)) continue;
                DefaultDingTalkClient clientUser = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/v2/user/get");
                OapiV2UserGetRequest reqUser = new OapiV2UserGetRequest();
                reqUser.setUserid("141410123526265934");
                OapiV2UserGetResponse rspUser = (OapiV2UserGetResponse)clientUser.execute((TaobaoRequest)reqUser, accessToken);
                DingUserModel resultUser = (DingUserModel)JsonUtil.getJsonToBean((String)String.valueOf(JsonUtil.stringToMap((String)rspUser.getBody()).get("result")), DingUserModel.class);
                resultUser.setDepartmentId(dingDeptModel.getDept_id());
                System.out.println(rsp.getBody());
                this.dIngStream.userAOD(resultUser.getUserid(), qyhCorpId);
                resultUserList.add(resultUser);
            }
        }
        SynThirdTotal synThirdTotal = this.synThirdInfoService.getSynTotal("2", "1");
        return ActionResult.success((Object)synThirdTotal);
    }
}

