/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.util;

import com.bringspring.common.base.MailAccount;
import com.bringspring.common.base.MailFile;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.system.base.entity.EmailReceiveEntity;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class Pop3Util {
    private static final Logger log = LoggerFactory.getLogger(Pop3Util.class);
    @Autowired
    private ConfigValueUtil configValueUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String checkConnected(MailAccount mailAccount) {
        String string;
        block6: {
            Properties props = this.getProperties(mailAccount.getSsl());
            Session session = this.getSession(props);
            Store store = this.getStore(session, mailAccount);
            try {
                string = "true";
                if (Collections.singletonList(store).get(0) == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (Collections.singletonList(store).get(0) != null) {
                        store.close();
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                    return e.getMessage();
                }
            }
            store.close();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public Map<String, Object> popMail(MailAccount mailAccount) {
        List<Object> entity = new ArrayList();
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        try {
            Properties props = this.getProperties(mailAccount.getSsl());
            Session session = this.getSession(props);
            Store store = this.getStore(session, mailAccount);
            try {
                HashMap<String, Object> hashMap;
                block10: {
                    Folder folder = this.getFolder(store);
                    try {
                        int receiveCount = folder.getMessageCount();
                        Message[] messages = folder.getMessages();
                        entity = this.parseMessage(messages);
                        map.put("receiveCount", receiveCount);
                        map.put("mailList", entity);
                        hashMap = map;
                        if (Collections.singletonList(folder).get(0) == null) break block10;
                    }
                    catch (Throwable throwable) {
                        if (Collections.singletonList(folder).get(0) != null) {
                            folder.close();
                        }
                        throw throwable;
                    }
                    folder.close();
                }
                return hashMap;
            }
            finally {
                if (Collections.singletonList(store).get(0) != null) {
                    store.close();
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMessage(MailAccount mailAccount, String mid) {
        try {
            Properties props = this.getProperties(false);
            Session session = this.getSession(props);
            Store store = this.getStore(session, mailAccount);
            try {
                Folder folder = this.getFolder(store);
                try {
                    Message[] messages = folder.getMessages();
                    this.deleteMessage(messages, mid);
                }
                finally {
                    if (Collections.singletonList(folder).get(0) != null) {
                        folder.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(store).get(0) != null) {
                    store.close();
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    private Properties getProperties(boolean ssl) {
        Properties props = new Properties();
        props.setProperty("mail.store.protocol", "pop3");
        props.setProperty("mail.pop3.auth", "true");
        props.put("mail.pop3.connectiontimeout", "35000");
        props.put("mail.pop3.timeout", "10000");
        props.put("mail.pop3.writetimeout", "10000");
        if (ssl) {
            props.put("mail.pop3.ssl.enable", "true");
            props.put("mail.pop3.socketFactory.fallback", "false");
            props.setProperty("mail.pop3.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        }
        return props;
    }

    private Session getSession(Properties props) {
        Session session = Session.getInstance((Properties)props);
        session.setDebug(true);
        return session;
    }

    private Store getStore(Session session, MailAccount mailAccount) throws Exception {
        Store store = session.getStore();
        store.connect(mailAccount.getPop3Host(), mailAccount.getPop3Port(), mailAccount.getAccount(), mailAccount.getPassword());
        return store;
    }

    private Folder getFolder(Store store) throws Exception {
        Folder folder = store.getFolder("INBOX");
        folder.open(1);
        return folder;
    }

    private List<EmailReceiveEntity> parseMessage(Message ... messages) throws MessagingException, IOException {
        ArrayList<EmailReceiveEntity> receiveEntity = new ArrayList<EmailReceiveEntity>();
        if (messages == null || messages.length < 1) {
            throw new MessagingException("\u672a\u627e\u5230\u8981\u89e3\u6790\u7684\u90ae\u4ef6!");
        }
        List<Object> mailFiles = new ArrayList();
        String mailfiles = "";
        int count = messages.length;
        for (int i = 0; i < count; ++i) {
            MimeMessage msg = (MimeMessage)messages[i];
            mailfiles = null;
            boolean isContainerAttachment = this.isContainAttachment((Part)msg);
            if (isContainerAttachment) {
                mailFiles = this.saveAttachment((Part)msg, this.configValueUtil.getEmailFilePath());
                mailfiles = JsonUtil.getObjectToString(mailFiles);
            } else {
                mailfiles = "[]";
            }
            StringBuffer content = new StringBuffer(30);
            this.getMailTextContent((Part)msg, content);
            EmailReceiveEntity entity = new EmailReceiveEntity();
            entity.setId(RandomUtil.uuId());
            entity.setMAccount(this.getReceiveAddress(msg, null));
            entity.setMId(this.getMessageId(msg));
            if (this.getFrom(msg) == null) {
                entity.setSender("00000");
                entity.setSenderName("\u533f\u540d");
            } else {
                entity.setSender(this.getFrom(msg).split("_")[0]);
                entity.setSenderName(this.getFrom(msg).split("_")[1]);
            }
            entity.setSubject(this.getSubject(msg));
            entity.setBodyText(content.toString());
            entity.setAttachment(mailfiles);
            entity.setFdate(msg.getSentDate());
            entity.setIsRead(0);
            receiveEntity.add(entity);
        }
        return receiveEntity;
    }

    private void deleteMessage(Message[] messages, String mid) throws MessagingException {
        if (messages == null || messages.length < 1) {
            throw new MessagingException("\u672a\u627e\u5230\u8981\u89e3\u6790\u7684\u90ae\u4ef6!");
        }
        for (int i = 0; i < messages.length; ++i) {
            Message message = messages[i];
            MimeMessage msg = (MimeMessage)messages[i];
            if (!this.deleteMessageId(msg, mid)) continue;
            message.setFlag(Flags.Flag.DELETED, true);
        }
    }

    private boolean deleteMessageId(MimeMessage msg, String mid) throws MessagingException {
        String messageId = msg.getMessageID();
        messageId = messageId.replace("<", "");
        return (messageId = messageId.replace(">", "")).equals(mid);
    }

    private String getSubject(MimeMessage msg) throws UnsupportedEncodingException, MessagingException {
        return MimeUtility.decodeText((String)msg.getSubject());
    }

    private String getFrom(MimeMessage msg) throws MessagingException, UnsupportedEncodingException {
        String from = "";
        Address[] froms = msg.getFrom();
        InternetAddress address = (InternetAddress)froms[0];
        String person = address.getPersonal();
        person = person != null ? MimeUtility.decodeText((String)person) + " " : "";
        from = person + "_" + address.getAddress();
        return from;
    }

    private String getMessageId(MimeMessage msg) throws MessagingException {
        String messageId = msg.getMessageID();
        messageId = messageId.replace("<", "");
        messageId = messageId.replace(">", "");
        return messageId;
    }

    private String getReceiveAddress(MimeMessage msg, Message.RecipientType type) throws MessagingException {
        StringBuffer receiveAddress = new StringBuffer();
        Address[] addresss = null;
        addresss = type == null ? msg.getAllRecipients() : msg.getRecipients(type);
        if (addresss == null || addresss.length < 1) {
            return null;
        }
        for (Address address : addresss) {
            InternetAddress internetAddress = (InternetAddress)address;
            receiveAddress.append(internetAddress.toUnicodeString()).append(",");
        }
        receiveAddress.deleteCharAt(receiveAddress.length() - 1);
        return receiveAddress.toString();
    }

    private String getSentDate(MimeMessage msg, String pattern) throws MessagingException {
        Date receivedDate = msg.getSentDate();
        if (receivedDate == null) {
            return "";
        }
        if (pattern == null || "".equals(pattern)) {
            pattern = "yyyy\u5e74MM\u6708dd\u65e5 E HH:mm ";
        }
        return new SimpleDateFormat(pattern).format(receivedDate);
    }

    private boolean isContainAttachment(Part part) throws MessagingException, IOException {
        boolean flag = false;
        if (part.isMimeType("multipart/*")) {
            MimeMultipart multipart = (MimeMultipart)part.getContent();
            int partCount = multipart.getCount();
            for (int i = 0; i < partCount; ++i) {
                BodyPart bodyPart = multipart.getBodyPart(i);
                String disp = bodyPart.getDisposition();
                if (disp != null && (disp.equalsIgnoreCase("attachment") || disp.equalsIgnoreCase("inline"))) {
                    flag = true;
                } else if (bodyPart.isMimeType("multipart/*")) {
                    flag = this.isContainAttachment((Part)bodyPart);
                } else {
                    String contentType = bodyPart.getContentType();
                    if (contentType.contains("application")) {
                        flag = true;
                    }
                    if (contentType.contains("name")) {
                        flag = true;
                    }
                }
                if (!flag) {
                    continue;
                }
                break;
            }
        } else if (part.isMimeType("message/rfc822")) {
            flag = this.isContainAttachment((Part)part.getContent());
        }
        return flag;
    }

    private boolean isSeen(MimeMessage msg) throws MessagingException {
        return msg.getFlags().contains(Flags.Flag.SEEN);
    }

    private boolean isReplySign(MimeMessage msg) throws MessagingException {
        boolean replySign = false;
        String[] headers = msg.getHeader("Disposition-Notification-To");
        if (headers != null) {
            replySign = true;
        }
        return replySign;
    }

    private String getPriority(MimeMessage msg) throws MessagingException {
        String priority = "\u666e\u901a";
        String[] headers = msg.getHeader("X-Priority");
        if (headers != null) {
            String headerPriority = headers[0];
            priority = headerPriority.indexOf("1") != -1 || headerPriority.indexOf("High") != -1 ? "\u7d27\u6025" : (headerPriority.indexOf("5") != -1 || headerPriority.indexOf("Low") != -1 ? "\u4f4e" : "\u666e\u901a");
        }
        return priority;
    }

    private void getMailTextContent(Part part, StringBuffer content) throws MessagingException, IOException {
        boolean isContainTextAttach;
        boolean bl = isContainTextAttach = part.getContentType().indexOf("name") > 0;
        if (part.isMimeType("text/html") && !isContainTextAttach) {
            content.append(part.getContent().toString());
        } else if (part.isMimeType("message/rfc822")) {
            this.getMailTextContent((Part)part.getContent(), content);
        } else if (part.isMimeType("multipart/*")) {
            Multipart multipart = (Multipart)part.getContent();
            int partCount = multipart.getCount();
            for (int i = 0; i < partCount; ++i) {
                BodyPart bodyPart = multipart.getBodyPart(i);
                this.getMailTextContent((Part)bodyPart, content);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MailFile> saveAttachment(Part part, String destDir) throws UnsupportedEncodingException, MessagingException, FileNotFoundException, IOException {
        ArrayList<MailFile> mailFiles = new ArrayList<MailFile>();
        if (part.isMimeType("multipart/*")) {
            Multipart multipart = (Multipart)part.getContent();
            int partCount = multipart.getCount();
            for (int i = 0; i < partCount; ++i) {
                BodyPart bodyPart = multipart.getBodyPart(i);
                String disp = bodyPart.getDisposition();
                if (disp != null && (disp.equalsIgnoreCase("attachment") || disp.equalsIgnoreCase("inline"))) {
                    MailFile mailFile = new MailFile();
                    InputStream is = bodyPart.getInputStream();
                    try {
                        String fileName = MimeUtility.decodeText((String)bodyPart.getFileName());
                        String fileType = fileName.split("\\.")[1];
                        mailFile.setFileId(RandomUtil.uuId() + "." + fileType);
                        this.saveFile(is, destDir, this.decodeText(mailFile.getFileId()));
                        File file = new File(destDir + this.decodeText(fileName));
                        mailFile.setFileName(fileName);
                        mailFile.setFileSize(String.valueOf(file.length()));
                        mailFile.setFileState("-1");
                        mailFile.setFileTime(DateUtil.getNow());
                        mailFiles.add(mailFile);
                        continue;
                    }
                    finally {
                        if (Collections.singletonList(is).get(0) != null) {
                            is.close();
                        }
                    }
                }
                if (bodyPart.isMimeType("multipart/*")) {
                    this.saveAttachment((Part)bodyPart, destDir);
                    continue;
                }
                String contentType = bodyPart.getContentType();
                if (contentType.indexOf("name") == -1 && contentType.indexOf("application") == -1) continue;
                this.saveFile(bodyPart.getInputStream(), destDir, this.decodeText(bodyPart.getFileName()));
                File file = new File(destDir + this.decodeText(bodyPart.getFileName()));
                MailFile mailFile = new MailFile();
                mailFile.setFileId(RandomUtil.uuId());
                mailFile.setFileName(file.getName());
                mailFile.setFileSize(String.valueOf(file.length()));
                mailFile.setFileState("-1");
                mailFile.setFileTime(DateUtil.getNow());
                mailFiles.add(mailFile);
            }
        } else if (part.isMimeType("message/rfc822")) {
            this.saveAttachment((Part)part.getContent(), destDir);
        }
        return mailFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveFile(InputStream is, String destDir, String fileName) throws FileNotFoundException, IOException {
        BufferedInputStream bis = new BufferedInputStream(is);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(new File(destDir + fileName));
            try {
                BufferedOutputStream bos = new BufferedOutputStream(fileOutputStream);
                try {
                    int len = -1;
                    while ((len = bis.read()) != -1) {
                        bos.write(len);
                        bos.flush();
                    }
                }
                finally {
                    if (Collections.singletonList(bos).get(0) != null) {
                        bos.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(fileOutputStream).get(0) != null) {
                    fileOutputStream.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(bis).get(0) != null) {
                bis.close();
            }
        }
    }

    private String decodeText(String encodeText) throws UnsupportedEncodingException {
        if (encodeText == null || "".equals(encodeText)) {
            return "";
        }
        return MimeUtility.decodeText((String)encodeText);
    }
}

