/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.external.util;

import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.message.model.message.DingTalkDeptModel;
import com.bringspring.system.message.model.message.DingTalkUserModel;
import com.bringspring.system.message.model.message.OraganizeListVO;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.request.OapiGettokenRequest;
import com.dingtalk.api.request.OapiV2DepartmentCreateRequest;
import com.dingtalk.api.request.OapiV2DepartmentDeleteRequest;
import com.dingtalk.api.request.OapiV2DepartmentGetRequest;
import com.dingtalk.api.request.OapiV2DepartmentListsubRequest;
import com.dingtalk.api.request.OapiV2DepartmentUpdateRequest;
import com.dingtalk.api.request.OapiV2UserCreateRequest;
import com.dingtalk.api.request.OapiV2UserDeleteRequest;
import com.dingtalk.api.request.OapiV2UserListRequest;
import com.dingtalk.api.request.OapiV2UserUpdateRequest;
import com.dingtalk.api.response.OapiGettokenResponse;
import com.dingtalk.api.response.OapiV2DepartmentCreateResponse;
import com.dingtalk.api.response.OapiV2DepartmentDeleteResponse;
import com.dingtalk.api.response.OapiV2DepartmentGetResponse;
import com.dingtalk.api.response.OapiV2DepartmentListsubResponse;
import com.dingtalk.api.response.OapiV2DepartmentUpdateResponse;
import com.dingtalk.api.response.OapiV2UserCreateResponse;
import com.dingtalk.api.response.OapiV2UserDeleteResponse;
import com.dingtalk.api.response.OapiV2UserListResponse;
import com.dingtalk.api.response.OapiV2UserUpdateResponse;
import com.taobao.api.ApiException;
import com.taobao.api.TaobaoRequest;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.List;

public class DingTalkSynUtil {
    public static final String TOKEN = "https://oapi.dingtalk.com/gettoken";
    public static final String TOPAPI = "https://oapi.dingtalk.com/topapi";
    public static final String CREATE_DEPARTMENT = "/v2/department/create";
    public static final String UPDATE_DEPARTMENT = "/v2/department/update";
    public static final String DELETE_DEPARTMENT = "/v2/department/delete";
    public static final String GET_DEPARTMENT_LIST = "/v2/department/listsub";
    public static final String GET_DEPARTMENT_INFO = "/v2/department/get";
    public static final String CREATE_USER = "/v2/user/create";
    public static final String UPDATE_USER = "/v2/user/update";
    public static final String DELETE_USER = "/v2/user/delete";
    public static final String GET_USER_LIST = "/user/listsimple";
    public static final String GET_USER_LISTID = "/user/listid";
    public static final String GET_USER_DETAIL_LIST = "/v2/user/list";
    public static final String GET_SINGLE_USER = "/v2/user/get";

    public static JSONObject getAccessToken(String appkey, String appsecret, Proxy proxy) {
        JSONObject retMsg = new JSONObject();
        retMsg.put("code", (Object)true);
        try {
            DefaultDingTalkClient client = new DefaultDingTalkClient(TOKEN);
            client.setProxy(proxy);
            OapiGettokenRequest req = new OapiGettokenRequest();
            req.setAppkey(appkey);
            req.setAppsecret(appsecret);
            req.setHttpMethod("GET");
            OapiGettokenResponse rsp = (OapiGettokenResponse)client.execute((TaobaoRequest)req);
            retMsg.put("access_token", (Object)rsp.getAccessToken());
            if (!rsp.isSuccess()) {
                retMsg.put("code", (Object)false);
                retMsg.put("access_token", (Object)"");
            }
        }
        catch (ApiException e) {
            retMsg.put("code", (Object)false);
            retMsg.put("access_token", (Object)"");
        }
        return retMsg;
    }

    public static JSONObject createDepartment(DingTalkDeptModel deptModel, String accessToken, Proxy proxy) {
        JSONObject retMsg = new JSONObject();
        boolean codeFlag = true;
        String errorMsg = "";
        String deptId = "0";
        try {
            DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/v2/department/create");
            client.setProxy(proxy);
            OapiV2DepartmentCreateRequest req = new OapiV2DepartmentCreateRequest();
            req.setParentId(deptModel.getParentId());
            req.setName(deptModel.getName());
            req.setOrder(deptModel.getOrder());
            req.setCreateDeptGroup(deptModel.getCreateDeptGroup());
            OapiV2DepartmentCreateResponse rsp = (OapiV2DepartmentCreateResponse)client.execute((TaobaoRequest)req, accessToken);
            if (rsp.isSuccess()) {
                codeFlag = true;
                JSONObject bodyObject = JSONObject.parseObject((String)rsp.getBody());
                bodyObject = JSONObject.parseObject((String)bodyObject.getString("result"));
                deptId = bodyObject.getLong("dept_id").toString();
            } else {
                codeFlag = false;
                errorMsg = rsp.getErrmsg();
            }
        }
        catch (ApiException e) {
            codeFlag = false;
            errorMsg = e.toString();
        }
        retMsg.put("code", (Object)codeFlag);
        retMsg.put("error", (Object)errorMsg);
        retMsg.put("retDeptId", (Object)deptId);
        return retMsg;
    }

    public static JSONObject updateDepartment(DingTalkDeptModel deptModel, String accessToken, Proxy proxy) {
        JSONObject retMsg = new JSONObject();
        boolean codeFlag = true;
        String errorMsg = "";
        try {
            OapiV2DepartmentUpdateResponse rsp;
            DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/v2/department/update");
            client.setProxy(proxy);
            OapiV2DepartmentUpdateRequest req = new OapiV2DepartmentUpdateRequest();
            req.setDeptId(deptModel.getDeptId());
            req.setParentId(deptModel.getParentId());
            req.setOrder(deptModel.getOrder());
            req.setName(deptModel.getName());
            if (StringUtils.isNotEmpty((String)deptModel.getDeptManagerUseridList())) {
                req.setDeptManagerUseridList(deptModel.getDeptManagerUseridList());
            }
            if (!(rsp = (OapiV2DepartmentUpdateResponse)client.execute((TaobaoRequest)req, accessToken)).isSuccess()) {
                codeFlag = false;
                errorMsg = rsp.getErrmsg();
            }
        }
        catch (ApiException e) {
            codeFlag = false;
            errorMsg = e.toString();
        }
        retMsg.put("code", (Object)codeFlag);
        retMsg.put("error", (Object)errorMsg);
        return retMsg;
    }

    public static JSONObject deleteDepartment(Long id, String accessToken, Proxy proxy) {
        JSONObject retMsg = new JSONObject();
        boolean codeFlag = true;
        String errorMsg = "";
        try {
            DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/v2/department/delete");
            client.setProxy(proxy);
            OapiV2DepartmentDeleteRequest req = new OapiV2DepartmentDeleteRequest();
            req.setDeptId(id);
            OapiV2DepartmentDeleteResponse rsp = (OapiV2DepartmentDeleteResponse)client.execute((TaobaoRequest)req, accessToken);
            if (!rsp.isSuccess()) {
                codeFlag = false;
                errorMsg = rsp.getErrmsg();
            }
        }
        catch (ApiException e) {
            codeFlag = false;
            errorMsg = e.toString();
        }
        retMsg.put("code", (Object)codeFlag);
        retMsg.put("error", (Object)errorMsg);
        return retMsg;
    }

    public static JSONObject getDepartmentList(Long id, String accessToken, Proxy proxy) {
        JSONObject retMsg = new JSONObject();
        boolean codeFlag = true;
        String errorMsg = "";
        ArrayList<OapiV2DepartmentListsubResponse.DeptBaseResponse> departmentAllList = new ArrayList<OapiV2DepartmentListsubResponse.DeptBaseResponse>();
        retMsg = DingTalkSynUtil.getDepartmentListSub(id, accessToken, departmentAllList, proxy);
        if (!retMsg.getBoolean("code").booleanValue()) {
            codeFlag = false;
            errorMsg = "\u83b7\u53d6\u9489\u9489\u6240\u6709\u90e8\u95e8\u5217\u8868\u5931\u8d25";
        }
        retMsg.put("code", (Object)codeFlag);
        retMsg.put("error", (Object)errorMsg);
        retMsg.put("department", departmentAllList);
        return retMsg;
    }

    private static JSONObject getDepartmentListSub(Long id, String accessToken, List<OapiV2DepartmentListsubResponse.DeptBaseResponse> departmentAllList, Proxy proxy) {
        String errorMsg;
        boolean codeFlag;
        JSONObject retMsg;
        block4: {
            retMsg = new JSONObject();
            codeFlag = true;
            errorMsg = "";
            List departmentList = new ArrayList();
            try {
                DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/v2/department/listsub");
                OapiV2DepartmentListsubRequest req = new OapiV2DepartmentListsubRequest();
                req.setDeptId(id);
                OapiV2DepartmentListsubResponse rsp = (OapiV2DepartmentListsubResponse)client.execute((TaobaoRequest)req, accessToken);
                if (!rsp.isSuccess()) {
                    retMsg.put("code", (Object)false);
                    retMsg.put("error", (Object)rsp.getErrmsg());
                    return retMsg;
                }
                departmentList = rsp.getResult();
                if (departmentList.size() <= 0) break block4;
                for (OapiV2DepartmentListsubResponse.DeptBaseResponse deptEntity : departmentList) {
                    departmentAllList.add(deptEntity);
                    retMsg = DingTalkSynUtil.getDepartmentListSub(deptEntity.getDeptId(), accessToken, departmentAllList, proxy);
                    if (retMsg.getBoolean("code").booleanValue()) continue;
                    codeFlag = false;
                    errorMsg = rsp.getErrmsg();
                    break;
                }
            }
            catch (ApiException e) {
                codeFlag = false;
                errorMsg = e.toString();
            }
        }
        retMsg.put("code", (Object)codeFlag);
        retMsg.put("error", (Object)errorMsg);
        return retMsg;
    }

    public static JSONObject getDepartmentInfo(Long deptId, String accessToken, Proxy proxy) {
        JSONObject retMsg = new JSONObject();
        boolean codeFlag = true;
        String errorMsg = "";
        OapiV2DepartmentGetResponse.DeptGetResponse departmentInfo = new OapiV2DepartmentGetResponse.DeptGetResponse();
        try {
            DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/v2/department/get");
            client.setProxy(proxy);
            OapiV2DepartmentGetRequest req = new OapiV2DepartmentGetRequest();
            req.setDeptId(deptId);
            OapiV2DepartmentGetResponse rsp = (OapiV2DepartmentGetResponse)client.execute((TaobaoRequest)req, accessToken);
            if (!rsp.isSuccess()) {
                codeFlag = false;
                errorMsg = rsp.getErrmsg();
            } else {
                departmentInfo = rsp.getResult();
            }
        }
        catch (ApiException e) {
            codeFlag = false;
            errorMsg = e.toString();
        }
        retMsg.put("code", (Object)codeFlag);
        retMsg.put("error", (Object)errorMsg);
        retMsg.put("departmentInfo", (Object)departmentInfo);
        return retMsg;
    }

    public static JSONObject createUser(DingTalkUserModel userModel, String accessToken, Proxy proxy) {
        JSONObject retMsg = new JSONObject();
        boolean codeFlag = true;
        String errorMsg = "";
        try {
            DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/v2/user/create");
            OapiV2UserCreateRequest req = new OapiV2UserCreateRequest();
            req.setUserid(userModel.getUserid());
            req.setName(userModel.getName());
            req.setMobile(userModel.getMobile());
            req.setTelephone(userModel.getTelephone());
            req.setJobNumber(userModel.getJobNumber());
            req.setTitle(userModel.getTitle());
            req.setEmail(userModel.getEmail());
            req.setWorkPlace(userModel.getWorkPlace());
            req.setDeptIdList(userModel.getDeptIdList());
            req.setHiredDate(userModel.getHiredDate());
            OapiV2UserCreateResponse rsp = (OapiV2UserCreateResponse)client.execute((TaobaoRequest)req, accessToken);
            if (!rsp.isSuccess()) {
                codeFlag = false;
                errorMsg = rsp.getErrmsg();
            }
        }
        catch (ApiException e) {
            codeFlag = false;
            errorMsg = e.toString();
        }
        retMsg.put("code", (Object)codeFlag);
        retMsg.put("error", (Object)errorMsg);
        return retMsg;
    }

    public static JSONObject updateUser(DingTalkUserModel userModel, String accessToken, Proxy proxy) {
        JSONObject retMsg = new JSONObject();
        boolean codeFlag = true;
        String errorMsg = "";
        try {
            DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/v2/user/update");
            OapiV2UserUpdateRequest req = new OapiV2UserUpdateRequest();
            req.setUserid(userModel.getUserid());
            req.setName(userModel.getName());
            req.setMobile(userModel.getMobile());
            req.setTelephone(userModel.getTelephone());
            req.setJobNumber(userModel.getJobNumber());
            req.setTitle(userModel.getTitle());
            req.setEmail(userModel.getEmail());
            req.setWorkPlace(userModel.getWorkPlace());
            req.setDeptIdList(userModel.getDeptIdList());
            req.setHiredDate(userModel.getHiredDate());
            OapiV2UserUpdateResponse rsp = (OapiV2UserUpdateResponse)client.execute((TaobaoRequest)req, accessToken);
            if (!rsp.isSuccess()) {
                codeFlag = false;
                errorMsg = rsp.getErrmsg();
            }
        }
        catch (ApiException e) {
            codeFlag = false;
            errorMsg = e.toString();
        }
        retMsg.put("code", (Object)codeFlag);
        retMsg.put("error", (Object)errorMsg);
        return retMsg;
    }

    public static JSONObject deleteUser(String userId, String accessToken, Proxy proxy) {
        JSONObject retMsg = new JSONObject();
        boolean codeFlag = true;
        String errorMsg = "";
        try {
            DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/v2/user/delete");
            client.setProxy(proxy);
            OapiV2UserDeleteRequest req = new OapiV2UserDeleteRequest();
            req.setUserid(userId);
            OapiV2UserDeleteResponse rsp = (OapiV2UserDeleteResponse)client.execute((TaobaoRequest)req, accessToken);
            if (!rsp.isSuccess()) {
                codeFlag = false;
                errorMsg = rsp.getErrmsg();
            }
        }
        catch (ApiException e) {
            codeFlag = false;
            errorMsg = e.toString();
        }
        retMsg.put("code", (Object)codeFlag);
        retMsg.put("error", (Object)errorMsg);
        return retMsg;
    }

    public static JSONObject getUserList(List<DingTalkDeptModel> departmentList, String accessToken, Proxy proxy) {
        JSONObject retMsg = new JSONObject();
        boolean codeFlag = true;
        String errorMsg = "";
        ArrayList<OapiV2UserListResponse.ListUserResponse> userAllList = new ArrayList<OapiV2UserListResponse.ListUserResponse>();
        retMsg = DingTalkSynUtil.getUserListSub(1L, 0L, 100L, accessToken, userAllList, proxy);
        if (!retMsg.getBoolean("code").booleanValue()) {
            codeFlag = false;
            errorMsg = "\u83b7\u53d6\u9489\u9489\u6240\u6709\u7528\u6237\u5217\u8868\u5931\u8d25";
        }
        if (departmentList.size() > 0 && retMsg.getBoolean("code").booleanValue()) {
            for (DingTalkDeptModel deptEntity : departmentList) {
                retMsg = DingTalkSynUtil.getUserListSub(deptEntity.getDeptId(), 0L, 100L, accessToken, userAllList, proxy);
                if (retMsg.getBoolean("code").booleanValue()) continue;
                codeFlag = false;
                errorMsg = "\u83b7\u53d6\u9489\u9489\u6240\u6709\u7528\u6237\u5217\u8868\u5931\u8d25";
                break;
            }
        }
        retMsg.put("code", (Object)codeFlag);
        retMsg.put("error", (Object)errorMsg);
        retMsg.put("userlist", userAllList);
        return retMsg;
    }

    public static JSONObject getUserListSub(Long deptId, Long cursor, Long size, String accessToken, List<OapiV2UserListResponse.ListUserResponse> userAllList, Proxy proxy) {
        JSONObject retMsg = new JSONObject();
        List userList = new ArrayList();
        OapiV2UserListResponse.PageResult pageResult = new OapiV2UserListResponse.PageResult();
        try {
            DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/v2/user/list");
            client.setProxy(proxy);
            OapiV2UserListRequest req = new OapiV2UserListRequest();
            req.setDeptId(deptId);
            req.setCursor(cursor);
            req.setSize(size);
            OapiV2UserListResponse rsp = (OapiV2UserListResponse)client.execute((TaobaoRequest)req, accessToken);
            if (rsp.isSuccess()) {
                pageResult = rsp.getResult();
                userList = pageResult.getList();
                for (OapiV2UserListResponse.ListUserResponse userEntity : userList) {
                    userAllList.add(userEntity);
                }
                if (pageResult.getHasMore().booleanValue() && !(retMsg = DingTalkSynUtil.getUserListSub(deptId, pageResult.getNextCursor(), size, accessToken, userAllList, proxy)).getBoolean("code").booleanValue()) {
                    retMsg.put("code", (Object)false);
                    retMsg.put("error", (Object)rsp.getErrmsg());
                    return retMsg;
                }
            }
        }
        catch (ApiException e) {
            retMsg.put("code", (Object)false);
            retMsg.put("error", (Object)e.toString());
            return retMsg;
        }
        retMsg.put("code", (Object)true);
        retMsg.put("error", (Object)"");
        return retMsg;
    }

    public static void getOrganizeTreeToList(OraganizeListVO selectorVO, List<OrganizeEntity> organizeList, List<OrganizeEntity> listByOrder) {
        if (selectorVO.isHasChildren()) {
            List<OraganizeListVO> voChildren = selectorVO.getChildren();
            for (OraganizeListVO organizeSelectorVO : voChildren) {
                OrganizeEntity entity = organizeList.stream().filter(t -> t.getId().equals(organizeSelectorVO.getId())).findFirst().orElse(null);
                listByOrder.add(entity);
                if (!organizeSelectorVO.isHasChildren()) continue;
                DingTalkSynUtil.getOrganizeTreeToList(organizeSelectorVO, organizeList, listByOrder);
            }
        }
    }
}

