/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgcenter.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.system.msgcenter.constant.Constants;
import com.bringspring.system.msgcenter.constant.DictType;
import com.bringspring.system.msgcenter.entity.McMsgTemplateEntity;
import com.bringspring.system.msgcenter.entity.McMsgTemplateFieldEntity;
import com.bringspring.system.msgcenter.model.mcbusiness.McBusinessInfoVO;
import com.bringspring.system.msgcenter.model.mcmsgtemplate.McMsgTemplateCrForm;
import com.bringspring.system.msgcenter.model.mcmsgtemplate.McMsgTemplateInfoVO;
import com.bringspring.system.msgcenter.model.mcmsgtemplate.McMsgTemplateListVO;
import com.bringspring.system.msgcenter.model.mcmsgtemplate.McMsgTemplatePagination;
import com.bringspring.system.msgcenter.model.mcmsgtemplate.McMsgTemplatePaginationExportModel;
import com.bringspring.system.msgcenter.model.mcmsgtemplate.McMsgTemplateSelector;
import com.bringspring.system.msgcenter.model.mcmsgtemplate.McMsgTemplateUpForm;
import com.bringspring.system.msgcenter.model.mcmsgtemplatefield.McMsgTemplateFieldModel;
import com.bringspring.system.msgcenter.service.McBusinessService;
import com.bringspring.system.msgcenter.service.McMsgSendTemplateService;
import com.bringspring.system.msgcenter.service.McMsgTemplateFieldService;
import com.bringspring.system.msgcenter.service.McMsgTemplateService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u6d88\u606f\u6a21\u677f\u8868"}, value="mcMsgTemplate")
@RequestMapping(value={"/api/msgCenter/mcMsgTemplate"})
public class McMsgTemplateController {
    private static final Logger log = LoggerFactory.getLogger(McMsgTemplateController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private McMsgTemplateService mcMsgTemplateService;
    @Autowired
    private McMsgTemplateFieldService mcMsgTemplateFieldService;
    @Autowired
    private McBusinessService mcBusinessService;
    @Autowired
    private McMsgSendTemplateService mcMsgSendTemplateService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody McMsgTemplatePagination mcmsgtemplatePagination) throws IOException {
        List<McMsgTemplateEntity> list = this.mcMsgTemplateService.getList(mcmsgtemplatePagination);
        List listVO = JsonUtil.getJsonToList(list, McMsgTemplateListVO.class);
        Iterator iterator = listVO.iterator();
        while (iterator.hasNext()) {
            McMsgTemplateListVO vo;
            McBusinessInfoVO business = this.mcBusinessService.getInfoByEnCode((vo = (McMsgTemplateListVO)iterator.next()).getMessageSource());
            vo.setMessageSource(business != null ? business.getFullName() : null);
            vo.setMessageType(this.baseDataUtil.getDictName(vo.getMessageType(), DictType.MSG_TYPE.getCode()));
            vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
            vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)mcmsgtemplatePagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    public ActionResult create(@RequestBody @Valid McMsgTemplateCrForm mcMsgTemplateCrForm) throws DataException {
        if (!this.mcMsgTemplateService.checkEnCodeUnique(mcMsgTemplateCrForm.getEnCode(), null)) {
            return ActionResult.fail((String)"\u7f16\u7801\u5df2\u5b58\u5728");
        }
        if (!this.mcMsgTemplateService.checkFullNameUnique(mcMsgTemplateCrForm.getFullName(), null)) {
            return ActionResult.fail((String)"\u540d\u79f0\u5df2\u5b58\u5728");
        }
        if (!this.mcMsgTemplateFieldService.checkThirdFieldUnique(mcMsgTemplateCrForm.getFieldList())) {
            return ActionResult.fail((String)"\u53d8\u91cf\u91cd\u590d");
        }
        this.mcMsgTemplateService.create(mcMsgTemplateCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<McMsgTemplateInfoVO> info(@PathVariable(value="id") String id) {
        McMsgTemplateInfoVO vo;
        McMsgTemplateEntity entity = this.mcMsgTemplateService.getInfo(id);
        McBusinessInfoVO business = this.mcBusinessService.getInfoByEnCode((vo = (McMsgTemplateInfoVO)JsonUtil.getJsonToBean((Object)entity, McMsgTemplateInfoVO.class)).getMessageSource());
        vo.setMessageSourceName(business != null ? business.getFullName() : null);
        vo.setKeywordList(business != null ? business.getKeywordList() : null);
        List<McMsgTemplateFieldEntity> fieldList = this.mcMsgTemplateService.getMcMsgTemplateFieldList(id);
        vo.setFieldList(JsonUtil.getJsonToList(fieldList, McMsgTemplateFieldModel.class));
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<McMsgTemplateInfoVO> detailInfo(@PathVariable(value="id") String id) {
        McMsgTemplateEntity entity = this.mcMsgTemplateService.getInfo(id);
        McMsgTemplateInfoVO vo = (McMsgTemplateInfoVO)JsonUtil.getJsonToBean((Object)entity, McMsgTemplateInfoVO.class);
        List<McMsgTemplateFieldEntity> fieldList = this.mcMsgTemplateService.getMcMsgTemplateFieldList(id);
        List fieldModelList = JsonUtil.getJsonToList(fieldList, McMsgTemplateFieldModel.class);
        vo.setFieldList(fieldModelList);
        McBusinessInfoVO business = this.mcBusinessService.getInfoByEnCode(vo.getMessageSource());
        vo.setMessageSource(business != null ? business.getFullName() : null);
        vo.setMessageType(this.baseDataUtil.getDictName(vo.getMessageType(), DictType.MSG_TYPE.getCode()));
        vo.setEnabledMark(this.baseDataUtil.switchSelectValue(vo.getEnabledMark(), Constants.EnableStatus.ENABLED.getDisplay(), Constants.EnableStatus.DISABLED.getDisplay()));
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid McMsgTemplateUpForm mcMsgTemplateUpForm) throws DataException {
        if (!this.mcMsgTemplateService.checkEnCodeUnique(mcMsgTemplateUpForm.getEnCode(), id)) {
            return ActionResult.fail((String)"\u7f16\u7801\u5df2\u5b58\u5728");
        }
        if (!this.mcMsgTemplateService.checkFullNameUnique(mcMsgTemplateUpForm.getFullName(), id)) {
            return ActionResult.fail((String)"\u540d\u79f0\u5df2\u5b58\u5728");
        }
        if (!this.mcMsgTemplateFieldService.checkThirdFieldUnique(mcMsgTemplateUpForm.getFieldList())) {
            return ActionResult.fail((String)"\u53d8\u91cf\u91cd\u590d");
        }
        McMsgTemplateEntity entity = this.mcMsgTemplateService.getInfo(id);
        if (ObjectUtil.isNotNull((Object)entity)) {
            this.mcMsgTemplateService.update(id, mcMsgTemplateUpForm);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        McMsgTemplateEntity entity = this.mcMsgTemplateService.getInfo(id);
        if (ObjectUtil.isNotNull((Object)entity)) {
            if (this.mcMsgSendTemplateService.getCountByTemplateId(entity.getId()) > 0L) {
                return ActionResult.fail((String)"\u53d1\u9001\u914d\u7f6e\u5df2\u5173\u8054\u6a21\u677f\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
            }
            this.mcMsgTemplateService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u6d88\u606f\u6a21\u677f\u4e0b\u62c9\u6846")
    @GetMapping(value={"/Selector"})
    public ActionResult<PageListVO<McMsgTemplateSelector>> selector(McMsgTemplatePagination pagination) {
        List<McMsgTemplateEntity> list = this.mcMsgTemplateService.getList(pagination);
        List listSelector = JsonUtil.getJsonToList(list, McMsgTemplateSelector.class);
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)pagination), PaginationVO.class);
        return ActionResult.page((List)listSelector, (PaginationVO)paginationVO);
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(McMsgTemplatePaginationExportModel mcmsgtemplatePaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)mcmsgtemplatePaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        McMsgTemplatePagination mcmsgtemplatePagination = (McMsgTemplatePagination)((Object)JsonUtil.getJsonToBean((Object)((Object)mcmsgtemplatePaginationExportModel), McMsgTemplatePagination.class));
        List<McMsgTemplateEntity> list = this.mcMsgTemplateService.getTypeList(mcmsgtemplatePagination, mcmsgtemplatePaginationExportModel.getDataType());
        List listVO = JsonUtil.getJsonToList(list, McMsgTemplateListVO.class);
        Iterator iterator = listVO.iterator();
        while (iterator.hasNext()) {
            McMsgTemplateListVO vo;
            McBusinessInfoVO business = this.mcBusinessService.getInfoByEnCode((vo = (McMsgTemplateListVO)iterator.next()).getMessageSource());
            vo.setMessageSource(business != null ? business.getFullName() : null);
            vo.setMessageType(this.baseDataUtil.getDictName(vo.getMessageType(), DictType.MSG_TYPE.getCode()));
            vo.setEnabledMark(this.baseDataUtil.switchSelectValue(vo.getEnabledMark(), Constants.EnableStatus.ENABLED.getDisplay(), Constants.EnableStatus.DISABLED.getDisplay()));
            vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
            vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
            vo.setDeleteUserId(this.baseDataUtil.userSelectValue(vo.getDeleteUserId()));
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)mcmsgtemplatePaginationExportModel.getSelectKey()) ? mcmsgtemplatePaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block54: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "fullName": {
                        entitys.add(new ExcelExportEntity("\u540d\u79f0", (Object)"fullName"));
                        continue block54;
                    }
                    case "enCode": {
                        entitys.add(new ExcelExportEntity("\u7f16\u7801", (Object)"enCode"));
                        continue block54;
                    }
                    case "templateType": {
                        entitys.add(new ExcelExportEntity("\u6a21\u677f\u7c7b\u578b", (Object)"templateType"));
                        continue block54;
                    }
                    case "messageSource": {
                        entitys.add(new ExcelExportEntity("\u6d88\u606f\u6765\u6e90", (Object)"messageSource"));
                        continue block54;
                    }
                    case "messageType": {
                        entitys.add(new ExcelExportEntity("\u6d88\u606f\u6e20\u9053", (Object)"messageType"));
                        continue block54;
                    }
                    case "sortCode": {
                        entitys.add(new ExcelExportEntity("\u6392\u5e8f", (Object)"sortCode"));
                        continue block54;
                    }
                    case "enabledMark": {
                        entitys.add(new ExcelExportEntity("\u72b6\u6001", (Object)"enabledMark"));
                        continue block54;
                    }
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u8bf4\u660e", (Object)"description"));
                        continue block54;
                    }
                    case "title": {
                        entitys.add(new ExcelExportEntity("\u6807\u9898", (Object)"title"));
                        continue block54;
                    }
                    case "content": {
                        entitys.add(new ExcelExportEntity("\u5185\u5bb9", (Object)"content"));
                        continue block54;
                    }
                    case "templateCode": {
                        entitys.add(new ExcelExportEntity("\u6a21\u677f\u7f16\u53f7", (Object)"templateCode"));
                        continue block54;
                    }
                    case "wxSkip": {
                        entitys.add(new ExcelExportEntity("\u8df3\u8f6c\u65b9\u5f0f", (Object)"wxSkip"));
                        continue block54;
                    }
                    case "xcxAppId": {
                        entitys.add(new ExcelExportEntity("\u5173\u8054\u5c0f\u7a0b\u5e8fID", (Object)"xcxAppId"));
                        continue block54;
                    }
                    case "subscriberType": {
                        entitys.add(new ExcelExportEntity("\u8ba2\u9605\u7c7b\u578b", (Object)"subscriberType"));
                        continue block54;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u65f6\u95f4", (Object)"creatorTime"));
                        continue block54;
                    }
                    case "creatorUserId": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u7528\u6237", (Object)"creatorUserId"));
                        continue block54;
                    }
                    case "lastModifyTime": {
                        entitys.add(new ExcelExportEntity("\u4fee\u6539\u65f6\u95f4", (Object)"lastModifyTime"));
                        continue block54;
                    }
                    case "lastModifyUserId": {
                        entitys.add(new ExcelExportEntity("\u4fee\u6539\u7528\u6237", (Object)"lastModifyUserId"));
                        continue block54;
                    }
                    case "deleteTime": {
                        entitys.add(new ExcelExportEntity("\u5220\u9664\u65f6\u95f4", (Object)"deleteTime"));
                        continue block54;
                    }
                    case "deleteUserId": {
                        entitys.add(new ExcelExportEntity("\u5220\u9664\u7528\u6237", (Object)"deleteUserId"));
                        continue block54;
                    }
                    case "deleteMark": {
                        entitys.add(new ExcelExportEntity("\u6709\u6548\u6807\u5fd7", (Object)"deleteMark"));
                        continue block54;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }
}

