/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgcenter.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.msgcenter.entity.McMsgAccountEntity;
import com.bringspring.system.msgcenter.entity.McMsgSendEntity;
import com.bringspring.system.msgcenter.entity.McMsgSendTemplateEntity;
import com.bringspring.system.msgcenter.entity.McMsgTemplateEntity;
import com.bringspring.system.msgcenter.mapper.McMsgSendMapper;
import com.bringspring.system.msgcenter.model.mcmsgsend.McMsgSendCrForm;
import com.bringspring.system.msgcenter.model.mcmsgsend.McMsgSendInfoVO;
import com.bringspring.system.msgcenter.model.mcmsgsend.McMsgSendPagination;
import com.bringspring.system.msgcenter.model.mcmsgsend.McMsgSendUpForm;
import com.bringspring.system.msgcenter.model.mcmsgsendtemplate.McMsgSendTemplateModel;
import com.bringspring.system.msgcenter.service.McMsgAccountService;
import com.bringspring.system.msgcenter.service.McMsgSendService;
import com.bringspring.system.msgcenter.service.McMsgSendTemplateService;
import com.bringspring.system.msgcenter.service.McMsgTemplateService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class McMsgSendServiceImpl
extends ServiceImpl<McMsgSendMapper, McMsgSendEntity>
implements McMsgSendService {
    @Autowired
    private McMsgSendTemplateService mcMsgSendTemplateService;
    @Autowired
    private McMsgTemplateService mcMsgTemplateService;
    @Autowired
    private McMsgAccountService mcMsgAccountService;
    private final String limitSql = "limit 1";

    @Override
    public List<McMsgSendEntity> getList(McMsgSendPagination pagination) {
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)pagination.getKeyword())) {
            ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().like(McMsgSendEntity::getFullName, (Object)pagination.getKeyword())).or()).like(McMsgSendEntity::getEnCode, (Object)pagination.getKeyword());
        }
        if (StringUtils.isNotEmpty((String)pagination.getFullName())) {
            queryWrapper.lambda().like(McMsgSendEntity::getFullName, (Object)pagination.getFullName());
        }
        if (StringUtils.isNotEmpty((String)pagination.getEnCode())) {
            queryWrapper.lambda().like(McMsgSendEntity::getEnCode, (Object)pagination.getEnCode());
        }
        if (StringUtils.isNotEmpty((String)pagination.getTaskCode())) {
            queryWrapper.lambda().eq(McMsgSendEntity::getTaskCode, (Object)pagination.getTaskCode());
        }
        if (StringUtils.isNotEmpty((String)pagination.getTemplateType())) {
            queryWrapper.lambda().eq(McMsgSendEntity::getTemplateType, (Object)pagination.getTemplateType());
        }
        if (StringUtils.isNotEmpty((String)pagination.getMessageSource())) {
            queryWrapper.lambda().eq(McMsgSendEntity::getMessageSource, (Object)pagination.getMessageSource());
        }
        if (AllIdList.size() > 0) {
            queryWrapper.lambda().in(McMsgSendEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)pagination.getSidx())) {
            queryWrapper.lambda().orderByDesc(McMsgSendEntity::getCreatorTime);
        } else {
            try {
                String sidx = pagination.getSidx();
                Field declaredField = McMsgSendEntity.class.getDeclaredField(sidx);
                String value = declaredField.getAnnotation(TableField.class).value();
                queryWrapper = "asc".equals(pagination.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)value) : (QueryWrapper)queryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)queryWrapper);
            return pagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return pagination.setData(list, list.size());
    }

    @Override
    public List<McMsgSendEntity> getListAll(McMsgSendPagination pagination) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)pagination.getKeyword())) {
            ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().like(McMsgSendEntity::getFullName, (Object)pagination.getKeyword())).or()).like(McMsgSendEntity::getEnCode, (Object)pagination.getKeyword());
        }
        if (StringUtils.isNotEmpty((String)pagination.getFullName())) {
            queryWrapper.lambda().like(McMsgSendEntity::getFullName, (Object)pagination.getFullName());
        }
        if (StringUtils.isNotEmpty((String)pagination.getEnCode())) {
            queryWrapper.lambda().like(McMsgSendEntity::getEnCode, (Object)pagination.getEnCode());
        }
        if (StringUtils.isNotEmpty((String)pagination.getTaskCode())) {
            queryWrapper.lambda().eq(McMsgSendEntity::getTaskCode, (Object)pagination.getTaskCode());
        }
        if (StringUtils.isNotEmpty((String)pagination.getTemplateType())) {
            queryWrapper.lambda().eq(McMsgSendEntity::getTemplateType, (Object)pagination.getTemplateType());
        }
        if (StringUtils.isNotEmpty((String)pagination.getMessageSource())) {
            queryWrapper.lambda().eq(McMsgSendEntity::getMessageSource, (Object)pagination.getMessageSource());
        }
        if (StringUtils.isEmpty((String)pagination.getSidx())) {
            queryWrapper.lambda().orderByDesc(McMsgSendEntity::getCreatorTime);
        } else {
            try {
                String sidx = pagination.getSidx();
                Field declaredField = McMsgSendEntity.class.getDeclaredField(sidx);
                String value = declaredField.getAnnotation(TableField.class).value();
                queryWrapper = "asc".equals(pagination.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)value) : (QueryWrapper)queryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<McMsgSendEntity> getTypeList(McMsgSendPagination pagination, String dataType) {
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)pagination.getFullName())) {
            queryWrapper.lambda().like(McMsgSendEntity::getFullName, (Object)pagination.getFullName());
        }
        if (StringUtils.isNotEmpty((String)pagination.getEnCode())) {
            queryWrapper.lambda().like(McMsgSendEntity::getEnCode, (Object)pagination.getEnCode());
        }
        if (StringUtils.isNotEmpty((String)pagination.getTaskCode())) {
            queryWrapper.lambda().eq(McMsgSendEntity::getTaskCode, (Object)pagination.getTaskCode());
        }
        if (StringUtils.isNotEmpty((String)pagination.getTemplateType())) {
            queryWrapper.lambda().eq(McMsgSendEntity::getTemplateType, (Object)pagination.getTemplateType());
        }
        if (StringUtils.isNotEmpty((String)pagination.getMessageSource())) {
            queryWrapper.lambda().eq(McMsgSendEntity::getMessageSource, (Object)pagination.getMessageSource());
        }
        if (AllIdList.size() > 0) {
            queryWrapper.lambda().in(McMsgSendEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)pagination.getSidx())) {
            queryWrapper.lambda().orderByDesc(McMsgSendEntity::getCreatorTime);
        } else {
            try {
                String sidx = pagination.getSidx();
                Field declaredField = McMsgSendEntity.class.getDeclaredField(sidx);
                String value = declaredField.getAnnotation(TableField.class).value();
                queryWrapper = "asc".equals(pagination.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)value) : (QueryWrapper)queryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)queryWrapper);
                return pagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return pagination.setData(list, list.size());
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public McMsgSendEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(McMsgSendEntity::getId, (Object)id);
        return (McMsgSendEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public McMsgSendEntity getEntityByEnCode(String enCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(McMsgSendEntity::getEnCode, (Object)enCode);
        queryWrapper.last("limit 1");
        McMsgSendEntity one = (McMsgSendEntity)this.getOne((Wrapper)queryWrapper);
        return one;
    }

    @Override
    public McMsgSendInfoVO getInfoByEnCode(String enCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(McMsgSendEntity::getEnCode, (Object)enCode);
        queryWrapper.last("limit 1");
        McMsgSendEntity one = (McMsgSendEntity)this.getOne((Wrapper)queryWrapper);
        McMsgSendInfoVO infoVO = (McMsgSendInfoVO)JsonUtil.getJsonToBean((Object)one, McMsgSendInfoVO.class);
        List<McMsgSendTemplateEntity> mcMsgSendTemplateList = this.getMcMsgSendTemplateList(infoVO.getId(), 1);
        List modelList = JsonUtil.getJsonToList(mcMsgSendTemplateList, McMsgSendTemplateModel.class);
        Iterator iterator = modelList.iterator();
        while (iterator.hasNext()) {
            McMsgSendTemplateModel templateEntity;
            McMsgTemplateEntity templateInfo = this.mcMsgTemplateService.getInfo((templateEntity = (McMsgSendTemplateModel)iterator.next()).getTemplateId());
            templateEntity.setTemplateName(templateInfo != null ? templateInfo.getFullName() : null);
            templateEntity.setTemplateEnCode(templateInfo != null ? templateInfo.getEnCode() : null);
            McMsgAccountEntity accountInfo = this.mcMsgAccountService.getInfo(templateEntity.getAccountConfigId());
            templateEntity.setAccountName(accountInfo != null ? accountInfo.getFullName() : null);
            templateEntity.setAccountEnCode(accountInfo != null ? accountInfo.getEnCode() : null);
        }
        infoVO.setSendTemplateList(modelList);
        return infoVO;
    }

    @Override
    public McMsgSendEntity getValidInfo(String enCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(McMsgSendEntity::getEnabledMark, (Object)1);
        queryWrapper.lambda().and(t -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.eq(McMsgSendEntity::getId, (Object)enCode)).or()).eq(McMsgSendEntity::getEnCode, (Object)enCode);
        });
        return (McMsgSendEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public void create(McMsgSendCrForm mcMsgSendCrForm) {
        String mainId = RandomUtil.uuId();
        McMsgSendEntity entity = (McMsgSendEntity)JsonUtil.getJsonToBean((Object)mcMsgSendCrForm, McMsgSendEntity.class);
        entity.setId(mainId);
        this.save(entity);
        List sendTemplateList = JsonUtil.getJsonToList(mcMsgSendCrForm.getSendTemplateList(), McMsgSendTemplateEntity.class);
        for (McMsgSendTemplateEntity entitys : sendTemplateList) {
            entitys.setId(RandomUtil.uuId());
            entitys.setSendConfigId(entity.getId());
            this.mcMsgSendTemplateService.save(entitys);
        }
    }

    @Override
    @DSTransactional
    public boolean update(String id, McMsgSendUpForm mcMsgSendUpForm) {
        McMsgSendEntity entity = (McMsgSendEntity)JsonUtil.getJsonToBean((Object)mcMsgSendUpForm, McMsgSendEntity.class);
        entity.setId(id);
        QueryWrapper sendTemplatequeryWrapper = new QueryWrapper();
        sendTemplatequeryWrapper.lambda().eq(McMsgSendTemplateEntity::getSendConfigId, (Object)entity.getId());
        this.mcMsgSendTemplateService.remove((Wrapper)sendTemplatequeryWrapper);
        List sendTemplateList = JsonUtil.getJsonToList(mcMsgSendUpForm.getSendTemplateList(), McMsgSendTemplateEntity.class);
        for (McMsgSendTemplateEntity entitys : sendTemplateList) {
            entitys.setId(RandomUtil.uuId());
            entitys.setSendConfigId(entity.getId());
            this.mcMsgSendTemplateService.save(entitys);
        }
        return this.updateById(entity);
    }

    @Override
    @DSTransactional
    public void delete(McMsgSendEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
            QueryWrapper queryWrapperMcMsgSendTemplate = new QueryWrapper();
            queryWrapperMcMsgSendTemplate.lambda().eq(McMsgSendTemplateEntity::getSendConfigId, (Object)entity.getId());
            this.mcMsgSendTemplateService.remove((Wrapper)queryWrapperMcMsgSendTemplate);
        }
    }

    @Override
    public List<McMsgSendTemplateEntity> getMcMsgSendTemplateList(String id) {
        return this.getMcMsgSendTemplateList(id, null);
    }

    @Override
    public List<McMsgSendTemplateEntity> getMcMsgSendTemplateList(String id, Integer enabledMark) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(McMsgSendTemplateEntity::getSendConfigId, (Object)id);
        if (ObjectUtil.isNotEmpty((Object)enabledMark)) {
            queryWrapper.lambda().eq(McMsgSendTemplateEntity::getEnabledMark, (Object)enabledMark);
        }
        return this.mcMsgSendTemplateService.list((Wrapper)queryWrapper);
    }

    @Override
    public List<McMsgSendTemplateEntity> getMcMsgSendTemplateList(String sendId, String templateId, Integer enabledMark) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(McMsgSendTemplateEntity::getSendConfigId, (Object)sendId);
        queryWrapper.lambda().eq(McMsgSendTemplateEntity::getTemplateId, (Object)templateId);
        queryWrapper.lambda().eq(McMsgSendTemplateEntity::getEnabledMark, (Object)enabledMark);
        return this.mcMsgSendTemplateService.list((Wrapper)queryWrapper);
    }

    @Override
    public boolean checkEnCodeUnique(String enCode, String id) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(McMsgSendEntity::getEnCode, (Object)enCode);
        queryWrapper.last("limit 1");
        McMsgSendEntity entity = (McMsgSendEntity)this.getOne((Wrapper)queryWrapper);
        return !ObjectUtil.isNotNull((Object)entity) || !StringUtils.isEmpty((String)id) && entity.getId().equals(id);
    }

    @Override
    public boolean checkFullNameUnique(String fullName, String id) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(McMsgSendEntity::getFullName, (Object)fullName);
        queryWrapper.last("limit 1");
        McMsgSendEntity entity = (McMsgSendEntity)this.getOne((Wrapper)queryWrapper);
        return !ObjectUtil.isNotNull((Object)entity) || !StringUtils.isEmpty((String)id) && entity.getId().equals(id);
    }

    @Override
    public long getCountByMessageSource(String messageSource) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(McMsgSendEntity::getMessageSource, (Object)messageSource);
        return this.count((Wrapper)queryWrapper);
    }
}

