/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgcenter.service.strategy;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.message.service.SynThirdInfoService;
import com.bringspring.system.msgcenter.constant.Constants;
import com.bringspring.system.msgcenter.entity.McMsgAccountEntity;
import com.bringspring.system.msgcenter.entity.McMsgTemplateEntity;
import com.bringspring.system.msgcenter.entity.McMsgTemplateFieldEntity;
import com.bringspring.system.msgcenter.entity.McTaskMsgContentEntity;
import com.bringspring.system.msgcenter.entity.McTaskMsgEntity;
import com.bringspring.system.msgcenter.entity.McTaskMsgReceiveEntity;
import com.bringspring.system.msgcenter.enums.ChannelTypeEnum;
import com.bringspring.system.msgcenter.model.mcbusiness.McBusinessInfoVO;
import com.bringspring.system.msgcenter.model.mctaskmsgcontent.ContentData;
import com.bringspring.system.msgcenter.service.McBusinessService;
import com.bringspring.system.msgcenter.service.McMsgAccountService;
import com.bringspring.system.msgcenter.service.McMsgTemplateService;
import com.bringspring.system.msgcenter.service.context.TaskMsgReceiveMetadata;
import com.bringspring.system.msgcenter.service.strategy.MessageChannelStrategy;
import com.bringspring.system.msgcenter.util.SensitiveWordUtil;
import com.bringspring.system.msgcenter.util.UrlUtils;
import com.bringspring.system.permission.entity.UserEntity;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.text.StringSubstitutor;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractMessageChannelStrategy
implements MessageChannelStrategy {
    @Autowired
    protected McBusinessService mcBusinessService;
    @Autowired
    private McMsgTemplateService mcMsgTemplateService;
    @Autowired
    protected McMsgAccountService mcMsgAccountService;
    @Autowired
    protected SynThirdInfoService synThirdInfoService;
    private final String PIC_URL_KEY = "picUrl";
    private final String PENDING_STATUS_DESC = "\u521b\u5efa\uff0c\u8bbe\u7f6e\u4e0b\u53d1\u72b6\u6001\u4e3a\u2018\u5f85\u4e0b\u53d1\u2019";

    public abstract ChannelTypeEnum getChannelType();

    protected McTaskMsgContentEntity getTaskMsgContent(String templateId, String channelType, McTaskMsgEntity taskMsg, McMsgTemplateEntity msgTemplate, McMsgAccountEntity account) {
        String taskMsgId = taskMsg.getId();
        McBusinessInfoVO businessInfoVO = this.mcBusinessService.getInfoByEnCode(msgTemplate.getMessageSource());
        Map businessKeyMap = JsonUtil.stringToMap((String)taskMsg.getBusinessKey());
        ContentData contentData = this.processTemplateData(msgTemplate, businessKeyMap, account, taskMsgId, channelType);
        return this.buildContentEntity(contentData, taskMsg, channelType, templateId, account, businessInfoVO, msgTemplate);
    }

    private ContentData processTemplateData(McMsgTemplateEntity msgTemplate, Map<String, Object> businessKeyMap, McMsgAccountEntity account, String taskMsgId, String channelType) {
        ContentData data = new ContentData();
        if (MapUtil.isEmpty(businessKeyMap)) {
            return data;
        }
        data.setTitle(this.replacePlaceholder(msgTemplate.getTitle(), businessKeyMap, "title"));
        data.setContent(this.replacePlaceholder(msgTemplate.getContent(), businessKeyMap, "content"));
        data.setDescription(Optional.ofNullable(businessKeyMap.get("desc")).map(Object::toString).orElseGet(() -> this.truncateContent(data.getContent())));
        data.setLinkUrl(this.packLinkUrl(channelType, businessKeyMap, account, taskMsgId));
        data.setPicUrl(Optional.ofNullable(businessKeyMap.get("picUrl")).map(Object::toString).orElse(null));
        return data;
    }

    private String replacePlaceholder(String template, Map<String, Object> params, String fallbackKey) {
        if (StringUtils.isNotEmpty((String)template)) {
            return new StringSubstitutor(params, "{", "}").replace(template);
        }
        return String.valueOf(params.get(fallbackKey));
    }

    private String truncateContent(String content) {
        return StringUtils.isEmpty((String)content) ? null : StringUtils.substring((String)content, (int)0, (int)200);
    }

    private McTaskMsgContentEntity buildContentEntity(ContentData contentData, McTaskMsgEntity taskMsg, String channelType, String templateId, McMsgAccountEntity account, McBusinessInfoVO businessInfoVO, McMsgTemplateEntity msgTemplate) {
        McTaskMsgContentEntity entity = new McTaskMsgContentEntity();
        entity.setId(RandomUtil.uuId());
        entity.setMsgId(taskMsg.getId());
        entity.setChannelType(channelType);
        entity.setTemplateId(templateId);
        entity.setMsgTemplateId(msgTemplate.getId());
        entity.setMsgAccountId(ObjectUtil.isEmpty((Object)account) ? null : account.getId());
        entity.setContentType(businessInfoVO.getCategory());
        this.setFilteredField(contentData.getTitle(), 50, entity::setTitle);
        this.setFilteredField(contentData.getContent(), null, entity::setContent);
        this.setFilteredField(contentData.getDescription(), null, entity::setDescription);
        Optional.ofNullable(contentData.getLinkUrl()).ifPresent(entity::setLinkUrl);
        Optional.ofNullable(contentData.getPicUrl()).ifPresent(entity::setPicUrl);
        return entity;
    }

    private void setFilteredField(String value, Integer maxLength, Consumer<String> setter) {
        if (StringUtils.isEmpty((String)value)) {
            return;
        }
        String filtered = SensitiveWordUtil.sensitiveFilter(value, true);
        if (maxLength != null && filtered.length() > maxLength) {
            filtered = StringUtils.substring((String)filtered, (int)0, (int)maxLength);
        }
        setter.accept(filtered);
    }

    protected McTaskMsgContentEntity getTaskMsgContentKey(String templateId, String channelType, McTaskMsgEntity taskMsg, McMsgTemplateEntity msgTemplate, McMsgAccountEntity account) {
        String taskMsgId = taskMsg.getId();
        McBusinessInfoVO businessInfoVO = this.mcBusinessService.getInfoByEnCode(msgTemplate.getMessageSource());
        String businessKey = taskMsg.getBusinessKey();
        Map businessKeyMap = JsonUtil.stringToMap((String)businessKey);
        McTaskMsgContentEntity taskMsgContentEntity = new McTaskMsgContentEntity();
        List<McMsgTemplateFieldEntity> fieldList = this.mcMsgTemplateService.getMcMsgTemplateFieldList(msgTemplate.getId());
        if (CollUtil.isNotEmpty(fieldList) && StringUtils.isNotEmpty((Map)businessKeyMap)) {
            HashMap fieldMap = new HashMap();
            for (McMsgTemplateFieldEntity field : fieldList) {
                fieldMap.put(field.getThirdField(), businessKeyMap.get(field.getKeywordCode()));
                if (field.getIsTitle() != 1) continue;
                taskMsgContentEntity.setTitle(businessKeyMap.get(field.getKeywordCode()).toString());
            }
            String content = JSON.toJSONString(fieldMap);
            if (StringUtils.isNotEmpty((String)content)) {
                content = SensitiveWordUtil.sensitiveFilter(content, true);
                taskMsgContentEntity.setContent(content);
            }
            taskMsgContentEntity.setLinkUrl(this.packLinkUrl(channelType, businessKeyMap, account, taskMsgId));
            if (businessKeyMap.containsKey("picUrl") && ObjectUtil.isNotEmpty(businessKeyMap.get("picUrl"))) {
                taskMsgContentEntity.setLinkUrl(String.valueOf(businessKeyMap.get("picUrl")));
            }
        }
        taskMsgContentEntity.setId(RandomUtil.uuId());
        taskMsgContentEntity.setMsgId(taskMsgId);
        taskMsgContentEntity.setChannelType(channelType);
        taskMsgContentEntity.setTemplateId(templateId);
        taskMsgContentEntity.setMsgTemplateId(msgTemplate.getId());
        taskMsgContentEntity.setMsgAccountId(ObjectUtil.isEmpty((Object)account) ? null : account.getId());
        taskMsgContentEntity.setContentType(businessInfoVO.getCategory());
        return taskMsgContentEntity;
    }

    protected List<McTaskMsgReceiveEntity> packThirdReceive(List<UserEntity> sysList, List<SynThirdInfoEntity> thirdList, TaskMsgReceiveMetadata metadata, List<McTaskMsgReceiveEntity> receiveList) {
        return CollUtil.isEmpty(receiveList) ? this.createNewReceives(sysList, thirdList, metadata) : this.updateExistingReceives(thirdList, metadata, receiveList);
    }

    private List<McTaskMsgReceiveEntity> createNewReceives(List<UserEntity> sysList, List<SynThirdInfoEntity> thirdList, TaskMsgReceiveMetadata metadata) {
        ArrayList<McTaskMsgReceiveEntity> receiveEntities = new ArrayList<McTaskMsgReceiveEntity>();
        for (UserEntity user : sysList) {
            McTaskMsgReceiveEntity baseReceive = this.createBaseReceive(metadata, user);
            this.processThirdInfoForUser(thirdList, user, receiveEntities, baseReceive);
        }
        return receiveEntities;
    }

    private McTaskMsgReceiveEntity createBaseReceive(TaskMsgReceiveMetadata metadata, UserEntity user) {
        McTaskMsgReceiveEntity entity = new McTaskMsgReceiveEntity();
        entity.setMsgId(metadata.getTaskMsgId());
        entity.setTemplateId(metadata.getTemplateId());
        entity.setMsgTemplateId(metadata.getMsgTemplateId());
        entity.setMsgAccountId(metadata.getMsgAccountId());
        entity.setContentId(metadata.getContentId());
        entity.setChannelType(metadata.getChannelType());
        entity.setSysUserId(user.getId());
        entity.setIsRead(Constants.ReadStatus.UNREAD.getCode());
        return entity;
    }

    private void processThirdInfoForUser(List<SynThirdInfoEntity> thirdList, UserEntity user, List<McTaskMsgReceiveEntity> receiveEntities, McTaskMsgReceiveEntity baseReceive) {
        List<SynThirdInfoEntity> userThirdInfos = thirdList.stream().filter(s -> user.getId().equals(s.getSystemObjectId())).collect(Collectors.toList());
        if (CollUtil.isEmpty(userThirdInfos)) {
            baseReceive.setEnabledMark(0);
            baseReceive.setDescription("\u521b\u5efa\uff0c\u8bbe\u7f6e\u4e0b\u53d1\u72b6\u6001\u4e3a\u2018\u5f85\u4e0b\u53d1\u2019");
            baseReceive.setId(RandomUtil.uuId());
            receiveEntities.add(baseReceive);
        } else {
            userThirdInfos.forEach(s -> {
                McTaskMsgReceiveEntity cloned = this.cloneAndSetThirdInfo(baseReceive, (SynThirdInfoEntity)s);
                receiveEntities.add(cloned);
            });
        }
    }

    private McTaskMsgReceiveEntity cloneAndSetThirdInfo(McTaskMsgReceiveEntity source, SynThirdInfoEntity thirdInfo) {
        McTaskMsgReceiveEntity cloned = new McTaskMsgReceiveEntity();
        BeanUtils.copyProperties((Object)source, (Object)cloned);
        cloned.setReceiveUserId(thirdInfo.getId());
        cloned.setEnabledMark(0);
        cloned.setDescription("\u521b\u5efa\uff0c\u8bbe\u7f6e\u4e0b\u53d1\u72b6\u6001\u4e3a\u2018\u5f85\u4e0b\u53d1\u2019");
        cloned.setId(RandomUtil.uuId());
        return cloned;
    }

    private List<McTaskMsgReceiveEntity> updateExistingReceives(List<SynThirdInfoEntity> thirdList, TaskMsgReceiveMetadata metadata, List<McTaskMsgReceiveEntity> receiveList) {
        for (SynThirdInfoEntity thirdInfo : thirdList) {
            receiveList.stream().filter(r -> thirdInfo.getSystemObjectId().equals(r.getSysUserId())).findFirst().ifPresent(existing -> this.updateOrCloneReceive((McTaskMsgReceiveEntity)existing, thirdInfo, metadata, receiveList));
        }
        return receiveList;
    }

    private void updateOrCloneReceive(McTaskMsgReceiveEntity existing, SynThirdInfoEntity thirdInfo, TaskMsgReceiveMetadata metadata, List<McTaskMsgReceiveEntity> receiveList) {
        if (StringUtils.isEmpty((String)existing.getReceiveUserId())) {
            existing.setReceiveUserId(thirdInfo.getId());
            existing.setTemplateId(metadata.getTemplateId());
            existing.setMsgTemplateId(metadata.getMsgTemplateId());
            existing.setMsgAccountId(metadata.getMsgAccountId());
            existing.setContentId(metadata.getContentId());
        } else {
            McTaskMsgReceiveEntity cloned = this.cloneAndUpdateReceive(existing, thirdInfo, metadata);
            receiveList.add(cloned);
        }
    }

    private McTaskMsgReceiveEntity cloneAndUpdateReceive(McTaskMsgReceiveEntity source, SynThirdInfoEntity thirdInfo, TaskMsgReceiveMetadata metadata) {
        McTaskMsgReceiveEntity cloned = new McTaskMsgReceiveEntity();
        BeanUtils.copyProperties((Object)source, (Object)cloned);
        cloned.setId(RandomUtil.uuId());
        cloned.setReceiveUserId(thirdInfo.getId());
        cloned.setTemplateId(metadata.getTemplateId());
        cloned.setMsgTemplateId(metadata.getMsgTemplateId());
        cloned.setMsgAccountId(metadata.getMsgAccountId());
        cloned.setContentId(metadata.getContentId());
        return cloned;
    }

    protected List<McTaskMsgReceiveEntity> packNonSystemReceive(Set<String> userSet, String taskMsgId, String templateId, String channelType, String msgTemplateId, String msgAccountId, String contentId) {
        ArrayList<McTaskMsgReceiveEntity> receiveEntities = new ArrayList<McTaskMsgReceiveEntity>();
        for (String openid : userSet) {
            McTaskMsgReceiveEntity thirdReceive = new McTaskMsgReceiveEntity();
            thirdReceive.setId(RandomUtil.uuId());
            thirdReceive.setMsgId(taskMsgId);
            thirdReceive.setTemplateId(templateId);
            thirdReceive.setMsgTemplateId(msgTemplateId);
            thirdReceive.setMsgAccountId(msgAccountId);
            thirdReceive.setContentId(contentId);
            thirdReceive.setChannelType(channelType);
            thirdReceive.setSysUserId(null);
            thirdReceive.setReceiveUserId(openid);
            thirdReceive.setEnabledMark(0);
            thirdReceive.setIsRead(Constants.ReadStatus.UNREAD.getCode());
            thirdReceive.setDescription("\u521b\u5efa\uff0c\u8bbe\u7f6e\u4e0b\u53d1\u72b6\u6001\u4e3a\u2018\u5f85\u4e0b\u53d1\u2019");
            receiveEntities.add(thirdReceive);
        }
        return receiveEntities;
    }

    protected String packLinkUrl(String channelType, Map<String, Object> businessKeyMap, McMsgAccountEntity account, String taskMsgId) {
        Object linkUrl;
        ChannelTypeEnum typeEnum = ChannelTypeEnum.getByCode(channelType);
        String urlKey = this.getUrlKeyByChannel(typeEnum);
        Object object = linkUrl = urlKey != null ? businessKeyMap.get(urlKey) : null;
        if (ObjectUtil.isEmpty((Object)linkUrl) && ObjectUtil.isNotEmpty((Object)account)) {
            linkUrl = account.getAddress();
        }
        return this.buildUrlWithParams(linkUrl, taskMsgId);
    }

    private String getUrlKeyByChannel(ChannelTypeEnum channel) {
        if (channel == null) {
            return null;
        }
        EnumMap<ChannelTypeEnum, String> keyMapping = new EnumMap<ChannelTypeEnum, String>(ChannelTypeEnum.class);
        keyMapping.put(ChannelTypeEnum.SYS_MSG, "linkUrl");
        keyMapping.put(ChannelTypeEnum.MAIL_MSG, "linkUrl2");
        keyMapping.put(ChannelTypeEnum.SMS_MSG, "linkUrl3");
        keyMapping.put(ChannelTypeEnum.DING_MSG, "linkUrl4");
        keyMapping.put(ChannelTypeEnum.QY_MSG, "linkUrl5");
        keyMapping.put(ChannelTypeEnum.WX_MINIAPP, "linkUrl6");
        keyMapping.put(ChannelTypeEnum.WX_MP, "linkUrl7");
        keyMapping.put(ChannelTypeEnum.WEBHOOK, "linkUrl8");
        return (String)keyMapping.get((Object)channel);
    }

    private String buildUrlWithParams(Object linkUrl, String taskMsgId) {
        if (ObjectUtil.isEmpty((Object)linkUrl)) {
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("msg_id", taskMsgId);
        return UrlUtils.addParameter(String.valueOf(linkUrl), params);
    }
}

