/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgcenter.util;

import com.aliyun.dysmsapi20170525.Client;
import com.aliyun.dysmsapi20170525.models.QuerySmsTemplateRequest;
import com.aliyun.dysmsapi20170525.models.QuerySmsTemplateResponse;
import com.aliyun.dysmsapi20170525.models.SendSmsRequest;
import com.aliyun.dysmsapi20170525.models.SendSmsResponse;
import com.aliyun.teaopenapi.models.Config;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.ParameterUtil;
import com.bringspring.common.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmsAliYunSentUtil {
    private static final Logger log = LoggerFactory.getLogger(SmsAliYunSentUtil.class);
    private static final String SMS_FAILURE_PREFIX = "\u53d1\u9001\u77ed\u4fe1\u5931\u8d25\uff1a";
    private static final String QUERY_TEMPLATE_ERROR = "\u67e5\u8be2\u963f\u91cc\u4e91\u77ed\u4fe1\u6a21\u677f\u9519\u8bef\uff1a";
    private static final String CREATE_CLIENT_ERROR = "\u521b\u5efa\u963f\u91cc\u4e91\u77ed\u4fe1\u5ba2\u6237\u7aef\u9519\u8bef\uff1a";

    private SmsAliYunSentUtil() {
        throw new UnsupportedOperationException("\u5de5\u5177\u7c7b\u4e0d\u5141\u8bb8\u5b9e\u4f8b\u5316");
    }

    private static Client createClient(String accessKeyId, String accessKeySecret, String endpoint) {
        try {
            Config config = new Config().setAccessKeyId(accessKeyId).setAccessKeySecret(accessKeySecret);
            config.endpoint = endpoint;
            return new Client(config);
        }
        catch (Exception e) {
            log.error(CREATE_CLIENT_ERROR + e.getMessage());
            return null;
        }
    }

    public static List<String> querySmsTemplateRequest(String accessKeyId, String accessKeySecret, String endpoint, String templateId) {
        try {
            Client client = SmsAliYunSentUtil.createClient(accessKeyId, accessKeySecret, endpoint);
            if (client == null) {
                return Collections.emptyList();
            }
            QuerySmsTemplateResponse response = client.querySmsTemplate(new QuerySmsTemplateRequest().setTemplateCode(templateId));
            String templateContent = response.getBody().templateContent;
            if (StringUtils.isNotEmpty((String)templateContent)) {
                ArrayList<String> parameters = new ArrayList<String>();
                ParameterUtil.parse((String)"${", (String)"}", (String)templateContent, parameters);
                return parameters;
            }
        }
        catch (Exception e) {
            log.error(QUERY_TEMPLATE_ERROR + e.getMessage());
        }
        return Collections.emptyList();
    }

    public static String querySmsTemplateContent(String accessKeyId, String accessKeySecret, String endpoint, String templateId) {
        try {
            Client client = SmsAliYunSentUtil.createClient(accessKeyId, accessKeySecret, endpoint);
            if (client == null) {
                return "";
            }
            QuerySmsTemplateResponse response = client.querySmsTemplate(new QuerySmsTemplateRequest().setTemplateCode(templateId));
            return response.getBody().templateContent;
        }
        catch (Exception e) {
            log.error(QUERY_TEMPLATE_ERROR + e.getMessage());
            return "";
        }
    }

    public static String sentSms(String accessKeyId, String accessKeySecret, String endpoint, String phoneNumbers, String signContent, String templateId, Map<String, Object> map) {
        try {
            Client client = SmsAliYunSentUtil.createClient(accessKeyId, accessKeySecret, endpoint);
            if (client == null) {
                return "\u53d1\u9001\u77ed\u4fe1\u5931\u8d25\uff1a\u5ba2\u6237\u7aef\u521d\u59cb\u5316\u5931\u8d25";
            }
            SendSmsRequest request = new SendSmsRequest().setPhoneNumbers(phoneNumbers).setSignName(signContent).setTemplateCode(templateId).setTemplateParam(JsonUtil.getObjectToString(map));
            SendSmsResponse response = client.sendSms(request);
            if (!"Ok".equalsIgnoreCase(response.body.code)) {
                String errorMsg = SMS_FAILURE_PREFIX + response.getBody().message;
                log.error(errorMsg);
                return errorMsg;
            }
            return "Ok";
        }
        catch (Exception e) {
            String errorMsg = SMS_FAILURE_PREFIX + e.getMessage();
            log.error(errorMsg);
            return errorMsg;
        }
    }
}

