/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.Pagination;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.base.entity.ModuleFormEntity;
import com.bringspring.system.base.mapper.ModuleFormMapper;
import com.bringspring.system.base.service.ModuleFormService;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ModuleFormServiceImpl
extends ServiceImpl<ModuleFormMapper, ModuleFormEntity>
implements ModuleFormService {
    @Autowired
    private UserProvider userProvider;

    @Override
    public List<ModuleFormEntity> getList() {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(ModuleFormEntity::getSortCode)).orderByDesc(ModuleFormEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<ModuleFormEntity> getEnabledMarkList(String enabledMark) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ModuleFormEntity::getEnabledMark, (Object)enabledMark);
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(ModuleFormEntity::getSortCode)).orderByDesc(ModuleFormEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<ModuleFormEntity> getList(String moduleId, Pagination pagination) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(ModuleFormEntity::getModuleId, (Object)moduleId)).orderByAsc(ModuleFormEntity::getSortCode)).orderByDesc(ModuleFormEntity::getCreatorTime);
        if (!StringUtils.isEmpty((String)pagination.getKeyword())) {
            queryWrapper.lambda().and(t -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(ModuleFormEntity::getEnCode, (Object)pagination.getKeyword())).or()).like(ModuleFormEntity::getFullName, (Object)pagination.getKeyword());
            });
        }
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(ModuleFormEntity::getSortCode)).orderByDesc(ModuleFormEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<ModuleFormEntity> getList(String moduleId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ModuleFormEntity::getModuleId, (Object)moduleId);
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(ModuleFormEntity::getSortCode)).orderByDesc(ModuleFormEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public ModuleFormEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ModuleFormEntity::getId, (Object)id);
        return (ModuleFormEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public boolean isExistByFullName(String moduleId, String fullName, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(ModuleFormEntity::getFullName, (Object)fullName)).eq(ModuleFormEntity::getModuleId, (Object)moduleId);
        if (!StringUtils.isEmpty((String)id)) {
            queryWrapper.lambda().ne(ModuleFormEntity::getId, (Object)id);
        }
        return this.count((Wrapper)queryWrapper) > 0L;
    }

    @Override
    public boolean isExistByEnCode(String moduleId, String enCode, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(ModuleFormEntity::getEnCode, (Object)enCode)).eq(ModuleFormEntity::getModuleId, (Object)moduleId);
        if (!StringUtils.isEmpty((String)id)) {
            queryWrapper.lambda().ne(ModuleFormEntity::getId, (Object)id);
        }
        return this.count((Wrapper)queryWrapper) > 0L;
    }

    @Override
    public void create(ModuleFormEntity entity) {
        if (entity.getId() == null) {
            entity.setId(RandomUtil.uuId());
        }
        this.save(entity);
    }

    @Override
    @DSTransactional
    public void create(List<ModuleFormEntity> entitys) {
        Long sortCode = RandomUtil.parses();
        String userId = this.userProvider.get().getUserId();
        for (ModuleFormEntity entity : entitys) {
            entity.setId(RandomUtil.uuId());
            Long l = sortCode;
            Long l2 = sortCode = Long.valueOf(sortCode + 1L);
            entity.setSortCode(l);
            entity.setEnabledMark("1".equals(String.valueOf(entity.getEnabledMark())) ? 0 : 1);
            entity.setCreatorUserId(userId);
            this.save(entity);
        }
    }

    @Override
    public boolean update(String id, ModuleFormEntity entity) {
        entity.setId(id);
        entity.setLastModifyTime(DateUtil.getNowDate());
        return this.updateById(entity);
    }

    @Override
    public void delete(ModuleFormEntity entity) {
        this.removeById((Serializable)((Object)entity.getId()));
    }
}

