/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.external.handler;

import com.bringspring.common.util.JsonUtil;
import com.bringspring.system.external.bean.WxCpDepartTreeNode;
import com.bringspring.system.external.builder.TextBuilder;
import com.bringspring.system.external.handler.AbstractHandler;
import com.bringspring.system.external.service.WxCpCorpService;
import com.bringspring.system.external.util.JsonUtils;
import java.util.ArrayList;
import java.util.Map;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.WxCpDepart;
import me.chanjar.weixin.cp.bean.WxCpUser;
import me.chanjar.weixin.cp.bean.message.WxCpXmlMessage;
import me.chanjar.weixin.cp.bean.message.WxCpXmlOutMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ContactChangeHandler
extends AbstractHandler {
    @Autowired
    private WxCpCorpService wxCpCorpService;

    public WxCpXmlOutMessage handle(WxCpXmlMessage wxMessage, Map<String, Object> context, WxCpService cpService, WxSessionManager sessionManager) {
        String content = "\u6536\u5230\u901a\u8baf\u5f55\u53d8\u66f4\u4e8b\u4ef6\uff0c\u5185\u5bb9\uff1a" + JsonUtils.toJson(wxMessage);
        this.logger.info(content);
        String changeType = wxMessage.getChangeType();
        try {
            String userId;
            String deptid;
            String corpId = cpService.getWxCpConfigStorage().getCorpId();
            if ("create_party".equals(changeType) || "update_party".equals(changeType)) {
                deptid = wxMessage.getId();
                WxCpDepart wxCpDepart = cpService.getDepartmentService().get(Long.valueOf(deptid));
                WxCpDepartTreeNode wxCpDepartTreeNode = (WxCpDepartTreeNode)((Object)JsonUtil.getJsonToBean((Object)wxCpDepart, WxCpDepartTreeNode.class));
                ArrayList<WxCpDepartTreeNode> wxCpDepartTreeNodes = new ArrayList<WxCpDepartTreeNode>();
                wxCpDepartTreeNodes.add(wxCpDepartTreeNode);
                this.wxCpCorpService.saveOrUpdateOrganizeList(wxCpDepartTreeNodes, corpId, null);
            }
            if ("delete_party".equals(changeType)) {
                deptid = wxMessage.getId();
                this.wxCpCorpService.deleteOrganize(corpId, deptid);
            }
            if ("create_user".equals(changeType) || "update_user".equals(changeType)) {
                userId = wxMessage.getUserId();
                WxCpUser wxCpUser = cpService.getUserService().getById(userId);
                ArrayList<WxCpUser> users = new ArrayList<WxCpUser>();
                users.add(wxCpUser);
                this.wxCpCorpService.saveOrUpdateUserList(users, cpService);
            }
            if ("delete_user".equals(changeType)) {
                userId = wxMessage.getUserId();
                this.wxCpCorpService.deleteUser(corpId, userId);
            }
        }
        catch (WxErrorException e) {
            e.printStackTrace();
        }
        return new TextBuilder().build(content, wxMessage, cpService);
    }
}

