/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.external.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.system.external.bean.linkedcorp.MyWxCpLinkedCorpUser;
import com.bringspring.system.external.service.MyWxCpLinkedCorpService;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.json.GsonParser;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.linkedcorp.WxCpLinkedCorpAgentPerm;
import me.chanjar.weixin.cp.bean.linkedcorp.WxCpLinkedCorpDepartment;
import me.chanjar.weixin.cp.bean.linkedcorp.WxCpLinkedCorpUser;
import me.chanjar.weixin.cp.util.json.WxCpGsonBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyWxCpLinkedCorpServiceImpl
implements MyWxCpLinkedCorpService {
    private static final Logger log = LoggerFactory.getLogger(MyWxCpLinkedCorpServiceImpl.class);
    WxCpService wxCpService;

    @Override
    public WxCpLinkedCorpAgentPerm getLinkedCorpAgentPerm() throws WxErrorException {
        String url = this.wxCpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/linkedcorp/agent/get_perm_list");
        JsonObject jsonObject = new JsonObject();
        String responseContent = this.wxCpService.post(url, jsonObject.toString());
        return (WxCpLinkedCorpAgentPerm)WxCpGsonBuilder.create().fromJson(responseContent, WxCpLinkedCorpAgentPerm.class);
    }

    @Override
    public List<WxCpLinkedCorpDepartment> getLinkedCorpDepartmentList(String departmentId) throws WxErrorException {
        String url = this.wxCpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/linkedcorp/department/list");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("department_id", departmentId);
        String responseContent = this.wxCpService.post(url, jsonObject.toString());
        JsonObject tmpJson = GsonParser.parse((String)responseContent);
        return (List)WxCpGsonBuilder.create().fromJson(tmpJson.get("department_list"), new TypeToken<List<WxCpLinkedCorpDepartment>>(){}.getType());
    }

    @Override
    public List<MyWxCpLinkedCorpUser> getLinkedCorpUserList(String departmentId) throws WxErrorException {
        String url = this.wxCpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/linkedcorp/user/list");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("department_id", departmentId);
        String responseContent = this.wxCpService.post(url, jsonObject.toString());
        JSONObject tmpJson = JSONObject.parseObject((String)responseContent);
        List userlist = JsonUtil.getJsonToList((String)tmpJson.getString("userlist"), MyWxCpLinkedCorpUser.class);
        return userlist;
    }

    @Override
    public MyWxCpLinkedCorpUser getLinkedCorpUser(String userId) throws WxErrorException {
        String url = this.wxCpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/linkedcorp/user/get");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("userid", userId);
        String responseContent = this.wxCpService.post(url, jsonObject.toString());
        Map tmpJson = JsonUtil.stringToMap((String)responseContent);
        String user_info = String.valueOf(tmpJson.get("user_info"));
        MyWxCpLinkedCorpUser myWxCpLinkedCorpUser = (MyWxCpLinkedCorpUser)JsonUtil.getJsonToBean((String)user_info, MyWxCpLinkedCorpUser.class);
        return myWxCpLinkedCorpUser;
    }

    @Override
    public List<WxCpLinkedCorpUser> getLinkedCorpSimpleUserList(String departmentId) throws WxErrorException {
        String url = this.wxCpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/linkedcorp/user/simplelist");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("department_id", departmentId);
        String responseContent = this.wxCpService.post(url, jsonObject.toString());
        JsonObject tmpJson = GsonParser.parse((String)responseContent);
        return (List)WxCpGsonBuilder.create().fromJson(tmpJson.get("userlist"), new TypeToken<List<WxCpLinkedCorpUser>>(){}.getType());
    }

    public void setWxCpService(WxCpService wxCpService) {
        this.wxCpService = wxCpService;
    }
}

