/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.message.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.PageModel;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.message.entity.ImContentEntity;
import com.bringspring.system.message.entity.ImReplyEntity;
import com.bringspring.system.message.mapper.ImContentMapper;
import com.bringspring.system.message.model.ImReplySavaModel;
import com.bringspring.system.message.model.ImUnreadNumModel;
import com.bringspring.system.message.service.ImContentService;
import com.bringspring.system.message.service.ImReplyService;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ImContentServiceImpl
extends ServiceImpl<ImContentMapper, ImContentEntity>
implements ImContentService {
    @Autowired
    private ImReplyService imReplyService;

    @Override
    public List<ImContentEntity> getMessageList(String sendUserId, String receiveUserId, PageModel pageModel) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (!StringUtils.isEmpty((String)sendUserId) && !StringUtils.isEmpty((String)receiveUserId)) {
            queryWrapper.lambda().and(wrapper -> {
                wrapper.eq(ImContentEntity::getSendUserId, (Object)sendUserId);
                wrapper.eq(ImContentEntity::getReceiveUserId, (Object)receiveUserId);
                ((LambdaQueryWrapper)wrapper.or()).eq(ImContentEntity::getSendUserId, (Object)receiveUserId);
                wrapper.eq(ImContentEntity::getReceiveUserId, (Object)sendUserId);
            });
        }
        if (pageModel != null && pageModel.getKeyword() != null) {
            queryWrapper.lambda().like(ImContentEntity::getContent, (Object)pageModel.getKeyword());
            pageModel.setSidx("F_SendTime");
        }
        if (StringUtils.isEmpty((String)pageModel.getSidx())) {
            queryWrapper.lambda().orderByDesc(ImContentEntity::getSendTime);
        } else {
            queryWrapper = "asc".equals(pageModel.getSord().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)pageModel.getSidx()) : (QueryWrapper)queryWrapper.orderByDesc((Object)pageModel.getSidx());
        }
        Page page = new Page((long)pageModel.getPage(), (long)pageModel.getRows());
        IPage iPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return pageModel.setData(iPage.getRecords(), page.getTotal());
    }

    @Override
    public List<ImUnreadNumModel> getUnreadList(String receiveUserId) {
        List<ImUnreadNumModel> list = ((ImContentMapper)this.baseMapper).getUnreadList(receiveUserId);
        List<ImUnreadNumModel> list1 = ((ImContentMapper)this.baseMapper).getUnreadLists(receiveUserId);
        for (ImUnreadNumModel item : list) {
            Optional<ImUnreadNumModel> first = list1.stream().filter(q -> q.getSendUserId().equals(item.getSendUserId())).findFirst();
            if (!first.isPresent()) continue;
            ImUnreadNumModel defaultItem = first.get();
            item.setDefaultMessage(defaultItem.getDefaultMessage());
            item.setDefaultMessageType(defaultItem.getDefaultMessageType());
            item.setDefaultMessageTime(defaultItem.getDefaultMessageTime());
        }
        return list;
    }

    @Override
    public int getUnreadCount(String sendUserId, String receiveUserId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(ImContentEntity::getSendUserId, (Object)sendUserId)).eq(ImContentEntity::getReceiveUserId, (Object)receiveUserId)).eq(ImContentEntity::getState, (Object)0);
        return (int)this.count((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public void sendMessage(String sendUserId, String receiveUserId, String message, String messageType) {
        ImContentEntity entity = new ImContentEntity();
        entity.setId(RandomUtil.uuId());
        entity.setSendUserId(sendUserId);
        entity.setSendTime(new Date());
        entity.setReceiveUserId(receiveUserId);
        entity.setState(0);
        entity.setContent(message);
        entity.setContentType(messageType);
        this.save(entity);
        ImReplySavaModel imReplySavaModel = new ImReplySavaModel(sendUserId, receiveUserId, entity.getSendTime());
        ImReplyEntity imReplyEntity = (ImReplyEntity)JsonUtil.getJsonToBean((Object)imReplySavaModel, ImReplyEntity.class);
        this.imReplyService.savaImReply(imReplyEntity);
    }

    @Override
    public void readMessage(String sendUserId, String receiveUserId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ImContentEntity::getSendUserId, (Object)sendUserId);
        queryWrapper.lambda().eq(ImContentEntity::getReceiveUserId, (Object)receiveUserId);
        queryWrapper.lambda().eq(ImContentEntity::getState, (Object)0);
        List list = this.list((Wrapper)queryWrapper);
        for (ImContentEntity entity : list) {
            entity.setState(1);
            entity.setReceiveTime(new Date());
            this.updateById(entity);
        }
    }
}

