/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgcenter.service.strategy.impl;

import cn.hutool.core.util.ObjectUtil;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.message.service.SynThirdInfoService;
import com.bringspring.system.msgcenter.entity.McMsgAccountEntity;
import com.bringspring.system.msgcenter.entity.McMsgTemplateEntity;
import com.bringspring.system.msgcenter.entity.McTaskMsgContentEntity;
import com.bringspring.system.msgcenter.entity.McTaskMsgEntity;
import com.bringspring.system.msgcenter.entity.McTaskMsgReceiveEntity;
import com.bringspring.system.msgcenter.enums.ChannelTypeEnum;
import com.bringspring.system.msgcenter.model.mcmsgsendtemplate.McMsgSendTemplateModel;
import com.bringspring.system.msgcenter.service.McMsgAccountService;
import com.bringspring.system.msgcenter.service.McMsgTemplateService;
import com.bringspring.system.msgcenter.service.context.TaskMsgReceiveMetadata;
import com.bringspring.system.msgcenter.service.strategy.AbstractMessageChannelStrategy;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.UserService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DingTalkStrategy
extends AbstractMessageChannelStrategy {
    @Autowired
    private SynThirdInfoService synThirdInfoService;
    @Autowired
    private McMsgTemplateService mcMsgTemplateService;
    @Autowired
    private McMsgAccountService mcMsgAccountService;
    @Autowired
    private UserService userService;

    @Override
    public ChannelTypeEnum getChannelType() {
        return ChannelTypeEnum.DING_MSG;
    }

    @Override
    public void processMessage(McTaskMsgEntity taskMsg, McMsgSendTemplateModel sendTemplate, Map<String, McTaskMsgContentEntity> contentMap, Map<String, List<McTaskMsgReceiveEntity>> receiveMap, Set<String> userSet) {
        McTaskMsgContentEntity ddContent;
        String taskMsgId = taskMsg.getId();
        String templateId = sendTemplate.getId();
        String channelType = sendTemplate.getMessageType();
        String msgTemplateId = sendTemplate.getTemplateId();
        String msgAccountId = sendTemplate.getAccountConfigId();
        McMsgAccountEntity account = this.mcMsgAccountService.getInfo(sendTemplate.getAccountConfigId());
        McMsgTemplateEntity msgTemplate = this.mcMsgTemplateService.getInfo(sendTemplate.getTemplateId());
        String dingContentKey = channelType + msgTemplateId + msgAccountId;
        String dingReceiveKey = channelType + msgTemplateId;
        if (!contentMap.containsKey(dingContentKey)) {
            ddContent = this.getTaskMsgContent(templateId, channelType, taskMsg, msgTemplate, account);
            contentMap.put(dingContentKey, ddContent);
        } else {
            ddContent = contentMap.get(dingContentKey);
        }
        if ("4".equals(taskMsg.getToType())) {
            if (!receiveMap.containsKey(dingContentKey)) {
                List<McTaskMsgReceiveEntity> ddReceiveList = this.packNonSystemReceive(userSet, taskMsgId, templateId, channelType, msgTemplateId, msgAccountId, ddContent.getId());
                receiveMap.put(dingContentKey, ddReceiveList);
            }
        } else {
            List<UserEntity> receiveUsers = this.userService.getUserByIds(new ArrayList<String>(userSet));
            String ddCrop = ObjectUtil.isEmpty((Object)account) ? null : account.getEnterpriseId();
            List<SynThirdInfoEntity> ddThirdList = this.synThirdInfoService.getThirdInfoList("2", "2", ddCrop, userSet);
            List<McTaskMsgReceiveEntity> receiveList = null;
            if (receiveMap.containsKey(dingReceiveKey)) {
                receiveList = receiveMap.get(dingReceiveKey);
            }
            TaskMsgReceiveMetadata metadata = TaskMsgReceiveMetadata.builder().taskMsgId(taskMsgId).templateId(templateId).channelType(channelType).msgTemplateId(msgTemplateId).msgAccountId(msgAccountId).contentId(ddContent.getId()).build();
            List<McTaskMsgReceiveEntity> ddReceiveList = this.packThirdReceive(receiveUsers, ddThirdList, metadata, receiveList);
            receiveMap.put(dingReceiveKey, ddReceiveList);
        }
    }
}

