/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgcenter.service.strategy.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.msgcenter.entity.McMsgAccountEntity;
import com.bringspring.system.msgcenter.entity.McTaskMsgContentEntity;
import com.bringspring.system.msgcenter.entity.McTaskMsgReceiveEntity;
import com.bringspring.system.msgcenter.enums.ChannelTypeEnum;
import com.bringspring.system.msgcenter.enums.EnabledMarkEnum;
import com.bringspring.system.msgcenter.model.mcmsgsendtemplate.McMsgSendTemplateModel;
import com.bringspring.system.msgcenter.service.context.SendMessageContext;
import com.bringspring.system.msgcenter.service.strategy.AbstractMessageSender;
import com.bringspring.system.msgcenter.util.WebHookUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MsgToWebhookService
extends AbstractMessageSender {
    private static final Logger log = LoggerFactory.getLogger(MsgToWebhookService.class);

    @Override
    protected int getBatchSize() {
        return 1000;
    }

    @Override
    public ChannelTypeEnum getChannelType() {
        return ChannelTypeEnum.WEBHOOK;
    }

    @Override
    protected void validateParameters(SendMessageContext context) {
        this.validateTemplate(context);
        this.validateAccount(context);
    }

    @Override
    protected void doSend(SendMessageContext context) {
        if (CollectionUtil.isNotEmpty(context.getValidList())) {
            List<McTaskMsgReceiveEntity> receiveList = context.getValidList();
            McTaskMsgContentEntity taskMsgContent = context.getTaskMsgContent();
            McMsgAccountEntity account = context.getMsgAccount();
            String approveType = String.valueOf(account.getApproveType());
            String webhookType = String.valueOf(account.getWebhookType());
            String webhookAddress = account.getWebhookAddress();
            String content = taskMsgContent.getContent();
            ArrayList<McTaskMsgReceiveEntity> validList = new ArrayList<McTaskMsgReceiveEntity>();
            ArrayList<McTaskMsgReceiveEntity> invalidList = new ArrayList<McTaskMsgReceiveEntity>();
            JSONObject retJson = new JSONObject();
            switch (webhookType) {
                case "1": {
                    if ("1".equals(approveType)) {
                        retJson = WebHookUtil.sendDDMessage(webhookAddress, content);
                        break;
                    }
                    if (!"2".equals(approveType)) break;
                    retJson = WebHookUtil.sendDingDing(webhookAddress, account.getBearer(), content);
                    break;
                }
                case "2": {
                    if (!"1".equals(approveType)) break;
                    retJson = WebHookUtil.callWeChatBot(webhookAddress, content);
                    break;
                }
            }
            if ("ok".equals(retJson.getString("errmsg"))) {
                receiveList.get(0).setEnabledMark(EnabledMarkEnum.SUCCESS.getCode());
                receiveList.get(0).setDescription(JSONObject.toJSONString((Object)retJson));
                validList.addAll(receiveList);
            } else {
                receiveList.get(0).setEnabledMark(EnabledMarkEnum.FAIL.getCode());
                receiveList.get(0).setDescription(JSONObject.toJSONString((Object)retJson));
                invalidList.addAll(receiveList);
            }
            context.getInvalidList().addAll(invalidList);
            context.setValidList(validList);
        }
    }

    @Override
    protected void sendBatchNonSystemUser(boolean isAgain, McMsgSendTemplateModel sendTemplate, McTaskMsgContentEntity taskMsgContent, List<McTaskMsgReceiveEntity> receiveListS, UserInfo currentUserInfo) {
        if (ObjectUtil.isEmpty((Object)taskMsgContent) || CollectionUtil.isEmpty(receiveListS)) {
            log.error("~\u00b7~\u00b7~\u00b7~\u8c03\u7528\u4e86 webhook\u6d88\u606f\u3010\u975e\u7cfb\u7edf\u7528\u6237\u3011\u4e0b\u53d1\uff0c\u4f46taskMsgContent\u4e3a\u7a7a \u6216 receiveList\u4e3a\u7a7a~\u00b7~\u00b7~\u00b7~");
        }
        this.sendBatch(isAgain, sendTemplate, taskMsgContent, receiveListS, currentUserInfo);
    }

    @Override
    protected void sendBatch(boolean isAgain, McMsgSendTemplateModel sendTemplate, McTaskMsgContentEntity taskMsgContent, List<McTaskMsgReceiveEntity> receiveListS, UserInfo currentUserInfo) {
        if (ObjectUtil.isEmpty((Object)taskMsgContent) || CollectionUtil.isEmpty(receiveListS)) {
            log.error("~\u00b7~\u00b7~\u00b7~\u8c03\u7528\u4e86 webhook\u6d88\u606f\u4e0b\u53d1\uff0c\u4f46taskMsgContent\u4e3a\u7a7a \u6216 receiveList\u4e3a\u7a7a~\u00b7~\u00b7~\u00b7~");
        }
        for (McTaskMsgReceiveEntity receive : receiveListS) {
            if (StringUtils.isNotEmpty((String)receive.getReceiveUserId())) {
                McMsgAccountEntity msgAccount = this.mcMsgAccountService.getInfo(receive.getReceiveUserId());
                if (ObjectUtil.isNotNull((Object)msgAccount)) {
                    String errMsg;
                    String approveType = String.valueOf(msgAccount.getApproveType());
                    String webhookType = String.valueOf(msgAccount.getWebhookType());
                    String webhookAddress = msgAccount.getWebhookAddress();
                    String content = taskMsgContent.getContent();
                    JSONObject retJson = new JSONObject();
                    switch (webhookType) {
                        case "1": {
                            if ("1".equals(approveType)) {
                                retJson = WebHookUtil.sendDDMessage(webhookAddress, content);
                                break;
                            }
                            if (!"2".equals(approveType)) break;
                            retJson = WebHookUtil.sendDingDing(webhookAddress, msgAccount.getBearer(), content);
                            break;
                        }
                        case "2": {
                            if (!"1".equals(approveType)) break;
                            retJson = WebHookUtil.callWeChatBot(webhookAddress, content);
                            break;
                        }
                    }
                    if ("ok".equals(retJson.getString("errmsg"))) {
                        errMsg = (isAgain ? "\u91cd\u53d1\u6210\u529f\uff1a" : "\u4e0b\u53d1\u6210\u529f\uff1a") + JSONObject.toJSONString((Object)retJson);
                        this.settingResult(isAgain, receive, 1, errMsg, currentUserInfo);
                        continue;
                    }
                    errMsg = (isAgain ? "\u91cd\u53d1\u5931\u8d25\uff1a" : "\u4e0b\u53d1\u5931\u8d25\uff1a") + JSONObject.toJSONString((Object)retJson);
                    this.settingResult(isAgain, receive, 2, errMsg, currentUserInfo);
                    continue;
                }
                String errMsg = (isAgain ? "\u91cd\u53d1\u5931\u8d25\uff1a" : "\u4e0b\u53d1\u5931\u8d25\uff1a") + "\u65e0\u6548\u7684\u63a5\u6536\u4eba\uff0c\u672a\u6307\u5b9a\u6709\u6548\u7684webhook\u914d\u7f6e";
                this.settingResult(isAgain, receive, 2, errMsg, currentUserInfo);
                continue;
            }
            String errMsg = (isAgain ? "\u91cd\u53d1\u5931\u8d25\uff1a" : "\u4e0b\u53d1\u5931\u8d25\uff1a") + "\u7a7a\u7684\u63a5\u6536\u4eba\uff0c\u672a\u6307\u5b9awebhook\u914d\u7f6e";
            this.settingResult(isAgain, receive, 2, errMsg, currentUserInfo);
        }
        this.mcTaskMsgReceiveService.updateBatchById(receiveListS);
    }

    private void settingResult(boolean isAgain, McTaskMsgReceiveEntity receive, Integer enabledMark, String remark, UserInfo currentUserInfo) {
        if (!isAgain) {
            receive.setEnabledMark(enabledMark);
            receive.setSendTime(new Date());
            receive.setSendUserId(currentUserInfo.getUserId());
            receive.setDescription(remark);
            receive.setAutoAgainNum(0);
        } else {
            receive.setEnabledMark(enabledMark);
            receive.setAgainTime(new Date());
            receive.setAgainUserId(currentUserInfo.getUserId());
            receive.setDescription(remark);
            if (ObjectUtil.isEmpty((Object)receive.getAutoAgainNum())) {
                receive.setAutoAgainNum(0);
            } else {
                receive.setAutoAgainNum(receive.getAutoAgainNum() + 1);
            }
        }
    }
}

