/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.permission.aop;

import com.bringspring.common.base.UserInfo;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.database.data.DataSourceContextHolder;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Order(value=1)
public class DataSourceBindAspect {
    private static final Logger log = LoggerFactory.getLogger(DataSourceBindAspect.class);
    @Autowired
    UserProvider userProvider;
    @Autowired
    private ConfigValueUtil configValueUtil;

    @Pointcut(value="((execution(* com.bringspring.*.controller.*.*(..))) && !execution(* com.bringspring.oauth.controller.LoginController.Login(..)))|| execution(* com.bringspring.system.message.websocket.WebSocket.*(..))")
    public void bindDataSource() {
    }

    @Around(value="bindDataSource() && !@annotation(com.bringspring.common.base.NoDataSourceBind)")
    public Object doAroundService(ProceedingJoinPoint pjp) throws Throwable {
        if (Boolean.parseBoolean(this.configValueUtil.getMultiTenancy())) {
            if ("true".equals(DataSourceContextHolder.getDatasourceName())) {
                return pjp.proceed();
            }
            UserInfo userInfo = this.userProvider.get();
            if (StringUtils.isNotEmpty((String)userInfo.getTenantDbConnectionString())) {
                DataSourceContextHolder.setDatasource((String)userInfo.getTenantId(), (String)userInfo.getTenantDbConnectionString());
                Object obj = pjp.proceed();
                return obj;
            }
            log.error("\u79df\u6237" + userInfo.getTenantId() + "\u6570\u636e\u5e93\u4e0d\u5b58\u5728");
            return null;
        }
        Object obj = pjp.proceed();
        return obj;
    }
}

