/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.permission.aop;

import com.bringspring.common.util.UserProvider;
import com.bringspring.system.permission.aop.PermissionAdminBase;
import com.bringspring.system.permission.model.organize.OrganizeCrForm;
import com.bringspring.system.permission.model.organize.OrganizeDepartCrForm;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.util.PermissionAspectUtil;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class PermissionOrgAspect
implements PermissionAdminBase {
    private static final Logger log = LoggerFactory.getLogger(PermissionOrgAspect.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OrganizeService organizeService;

    @Pointcut(value="@annotation(com.bringspring.common.annotation.OrganizePermission)")
    public void pointcut() {
    }

    @Around(value="pointcut()")
    public Object around(ProceedingJoinPoint pjp) throws Throwable {
        return PermissionAdminBase.permissionCommon(pjp, this.userProvider, this);
    }

    @Override
    public Boolean detailPermission(ProceedingJoinPoint pjp, String operatorUserId, String methodName) {
        switch (methodName) {
            case "create": {
                return PermissionAspectUtil.getPermitByOrgIds(((OrganizeCrForm)pjp.getArgs()[0]).getParentId(), operatorUserId, "create");
            }
            case "createDepartment": {
                return PermissionAspectUtil.getPermitByOrgIds(((OrganizeDepartCrForm)pjp.getArgs()[0]).getParentId(), operatorUserId, "create");
            }
            case "update": 
            case "updateDepartment": {
                return PermissionAspectUtil.getPermitByOrgIds(pjp.getArgs()[0].toString(), operatorUserId, "update");
            }
            case "delete": 
            case "deleteDepartment": {
                return PermissionAspectUtil.getPermitByOrgIds(pjp.getArgs()[0].toString(), operatorUserId, "delete");
            }
        }
        return false;
    }
}

