/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.print.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.FileUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.enums.ModuleTypeEnum;
import com.bringspring.common.util.file.FileExport;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.entity.DictionaryTypeEntity;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.base.service.DictionaryTypeService;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.print.entity.OperatorRecordEntity;
import com.bringspring.system.print.entity.PrintDevEntity;
import com.bringspring.system.print.model.PaginationPrint;
import com.bringspring.system.print.model.dto.PrintDevFormDTO;
import com.bringspring.system.print.model.query.PrintDevDataQuery;
import com.bringspring.system.print.model.query.PrintDevFieldsQuery;
import com.bringspring.system.print.model.vo.PrintDevListVO;
import com.bringspring.system.print.model.vo.PrintDevVO;
import com.bringspring.system.print.service.IPrintDevService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u6253\u5370\u6a21\u677f"}, value="print")
@RestController
@RequestMapping(value={"/api/system/printDev"})
public class PrintDevController {
    @Autowired
    private IPrintDevService iPrintDevService;
    @Autowired
    private FileExport fileExport;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private DictionaryTypeService dictionaryTypeService;
    @Autowired
    private UserService userService;

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping
    public ActionResult<PrintDevFormDTO> create(@RequestBody @Valid PrintDevFormDTO printDevForm) {
        QueryWrapper query0 = new QueryWrapper();
        query0.lambda().eq(PrintDevEntity::getFullName, (Object)printDevForm.getFullName());
        if (this.iPrintDevService.getOne((Wrapper)query0) != null) {
            return ActionResult.fail((String)MsgCode.EXIST003.get());
        }
        QueryWrapper query1 = new QueryWrapper();
        query1.lambda().eq(PrintDevEntity::getEnCode, (Object)printDevForm.getEnCode());
        if (this.iPrintDevService.getOne((Wrapper)query1) != null) {
            return ActionResult.fail((String)MsgCode.EXIST002.get());
        }
        PrintDevEntity printDevEntity = (PrintDevEntity)JsonUtil.getJsonToBean((Object)printDevForm, PrintDevEntity.class);
        printDevEntity.setId(RandomUtil.uuId());
        this.iPrintDevService.save(printDevEntity);
        return ActionResult.success((String)MsgCode.SU001.get());
    }

    @ApiOperation(value="\u590d\u5236")
    @PostMapping(value={"/{id}/Actions/Copy"})
    public ActionResult<PageListVO<PrintDevEntity>> copy(@PathVariable String id) {
        int randomNum = (int)(Math.random() * 100000.0);
        PrintDevEntity entity = (PrintDevEntity)this.iPrintDevService.getById((Serializable)((Object)id));
        entity.setEnCode(entity.getEnCode() + "." + randomNum);
        entity.setId(RandomUtil.uuId());
        entity.setEnabledMark(0);
        entity.setFullName(entity.getFullName() + ".\u526f\u672c" + randomNum);
        entity.setLastModifyTime(null);
        entity.setLastModifyUserId(null);
        entity.setId(RandomUtil.uuId());
        PrintDevEntity entityBean = (PrintDevEntity)JsonUtil.getJsonToBean((Object)entity, PrintDevEntity.class);
        this.iPrintDevService.save(entityBean);
        return ActionResult.success((String)MsgCode.SU007.get());
    }

    @ApiOperation(value="\u5220\u9664")
    @DeleteMapping(value={"/{id}"})
    public ActionResult<PrintDevFormDTO> delete(@PathVariable String id) {
        if (this.iPrintDevService.getById((Serializable)((Object)id)) != null) {
            this.iPrintDevService.removeById((Serializable)((Object)id));
            return ActionResult.success((String)MsgCode.SU003.get());
        }
        return ActionResult.fail((String)MsgCode.FA003.get());
    }

    @ApiOperation(value="\u7f16\u8f91")
    @PutMapping(value={"/{id}"})
    public ActionResult<PrintDevFormDTO> update(@PathVariable String id, @RequestBody @Valid PrintDevFormDTO printDevForm) {
        PrintDevEntity printDevEntity = (PrintDevEntity)JsonUtil.getJsonToBean((Object)printDevForm, PrintDevEntity.class);
        printDevEntity.setId(id);
        this.iPrintDevService.updateById(printDevEntity);
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    @ApiOperation(value="\u4fee\u6539\u72b6\u6001")
    @PutMapping(value={"/{id}/Actions/State"})
    public ActionResult<PageListVO<PrintDevEntity>> state(@PathVariable String id) {
        PrintDevEntity entity = (PrintDevEntity)this.iPrintDevService.getById((Serializable)((Object)id));
        if (entity != null) {
            if ("1".equals(entity.getEnabledMark().toString())) {
                entity.setEnabledMark(0);
            } else {
                entity.setEnabledMark(1);
            }
            this.iPrintDevService.updateById(entity);
            return ActionResult.success((String)MsgCode.SU004.get());
        }
        return ActionResult.fail((String)MsgCode.FA002.get());
    }

    @ApiOperation(value="\u9884\u89c8")
    @GetMapping(value={"/{id}"})
    public ActionResult<PrintDevEntity> info(@PathVariable String id) {
        return ActionResult.success((Object)this.iPrintDevService.getById((Serializable)((Object)id)));
    }

    @ApiOperation(value="\u5217\u8868")
    @GetMapping
    public ActionResult list(PaginationPrint paginationPrint) {
        List<PrintDevEntity> list = this.iPrintDevService.getList(paginationPrint);
        List<String> userId = list.stream().map(t -> t.getCreatorUserId()).collect(Collectors.toList());
        List<String> lastUserId = list.stream().map(t -> t.getLastModifyUserId()).collect(Collectors.toList());
        lastUserId.removeAll(Collections.singleton(null));
        List<UserEntity> userEntities = this.userService.getUserName(userId);
        List<UserEntity> lastUserIdEntities = this.userService.getUserName(lastUserId);
        DictionaryTypeEntity typeEntity = this.dictionaryTypeService.getInfoByEnCode("printDev");
        List<DictionaryDataEntity> typeList = this.dictionaryDataService.getList(typeEntity.getId());
        ArrayList<PrintDevListVO> listVOS = new ArrayList<PrintDevListVO>();
        for (PrintDevEntity entity : list) {
            PrintDevListVO vo = (PrintDevListVO)JsonUtil.getJsonToBean((Object)entity, PrintDevListVO.class);
            DictionaryDataEntity dataEntity = typeList.stream().filter(t -> t.getEnCode().equals(entity.getCategory())).findFirst().orElse(null);
            if (dataEntity != null) {
                vo.setCategory(dataEntity.getFullName());
            } else {
                vo.setCategory("");
            }
            UserEntity creatorUser = userEntities.stream().filter(t -> t.getId().equals(entity.getCreatorUserId())).findFirst().orElse(null);
            vo.setCreatorUserId(creatorUser != null ? creatorUser.getRealName() : entity.getCreatorUserId());
            UserEntity lastModifyUser = lastUserIdEntities.stream().filter(t -> t.getId().equals(entity.getLastModifyUserId())).findFirst().orElse(null);
            vo.setLastModifyUserId(lastModifyUser != null ? lastModifyUser.getRealName() : entity.getLastModifyUserId());
            listVOS.add(vo);
        }
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)paginationPrint), PaginationVO.class);
        return ActionResult.page(listVOS, (PaginationVO)paginationVO);
    }

    @ApiOperation(value="\u4e0b\u62c9\u5217\u8868")
    @GetMapping(value={"/Selector"})
    public ActionResult<ListVO<PrintDevVO>> selectorList(Integer type) {
        ListVO vo = new ListVO();
        try {
            vo.setList(this.iPrintDevService.getTreeModel(type));
            return ActionResult.success((Object)vo);
        }
        catch (Exception e) {
            return ActionResult.fail((String)e.getMessage());
        }
    }

    @ApiOperation(value="Sql\u6570\u636e\u83b7\u53d6")
    @GetMapping(value={"/Data"})
    public ActionResult<Map<String, Object>> getFieldData(PrintDevDataQuery printDevSqlDataQuery) {
        Map<String, Object> printDataMap;
        String id = XSSEscape.escape((String)printDevSqlDataQuery.getId());
        String formId = XSSEscape.escape((String)printDevSqlDataQuery.getFormId());
        PrintDevEntity entity = (PrintDevEntity)this.iPrintDevService.getById((Serializable)((Object)id));
        if (entity == null) {
            return ActionResult.fail((String)MsgCode.PRI001.get());
        }
        try {
            printDataMap = this.iPrintDevService.getDataBySql(entity.getDbLinkId(), entity.getSqlTemplate().replaceAll("@formId", "'" + formId + "'"), 2);
        }
        catch (Exception e) {
            return ActionResult.fail((String)e.getMessage());
        }
        List headTableList = (List)printDataMap.get("headTable");
        printDataMap.remove("headTable");
        for (Map map : headTableList) {
            printDataMap.putAll(map);
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
        dataMap.put("printData", printDataMap);
        dataMap.put("printTemplate", entity.getPrintTemplate());
        List<OperatorRecordEntity> operatorRecordList = this.iPrintDevService.getFlowTaskOperatorRecordList(formId);
        dataMap.put("operatorRecordList", operatorRecordList);
        return ActionResult.success(dataMap);
    }

    @ApiOperation(value="Sql\u5b57\u6bb5\u83b7\u53d6")
    @PostMapping(value={"/Fields"})
    public ActionResult<Map<String, Object>> getFields(@RequestBody PrintDevFieldsQuery printDevFieldsQuery) {
        String dbLinkId = XSSEscape.escape((String)printDevFieldsQuery.getDbLinkId());
        try {
            return ActionResult.success(this.iPrintDevService.getDataBySql(dbLinkId, printDevFieldsQuery.getSqlTemplate().replaceAll("@formId", " null "), 1));
        }
        catch (Exception e) {
            return ActionResult.fail((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @GetMapping(value={"/{id}/Actions/Export"})
    public ActionResult<DownloadVO> export(@PathVariable String id) {
        PrintDevEntity entity = (PrintDevEntity)this.iPrintDevService.getById((Serializable)((Object)id));
        DownloadVO downloadVO = this.fileExport.exportFile((Object)entity, this.configValueUtil.getTemporaryFilePath(), entity.getFullName(), ModuleTypeEnum.SYSTEM_PRINT.getTableName());
        return ActionResult.success((Object)downloadVO);
    }

    @ApiOperation(value="\u5bfc\u5165")
    @PostMapping(value={"/Actions/ImportData"}, consumes={"multipart/form-data"})
    public ActionResult<PageListVO<PrintDevEntity>> importData(@RequestPart(value="file") MultipartFile multipartFile) throws DataException {
        if (FileUtil.existsSuffix((MultipartFile)multipartFile, (String)ModuleTypeEnum.SYSTEM_PRINT.getTableName())) {
            return ActionResult.fail((String)MsgCode.IMP002.get());
        }
        String fileContent = FileUtil.getFileContent((MultipartFile)multipartFile, (String)this.configValueUtil.getTemporaryFilePath());
        try {
            PrintDevEntity entity = (PrintDevEntity)JsonUtil.getJsonToBean((String)fileContent, PrintDevEntity.class);
            if (this.iPrintDevService.getById((Serializable)((Object)entity.getId())) == null && !this.iPrintDevService.checkNameExist(entity.getFullName(), entity.getId()).booleanValue()) {
                this.iPrintDevService.save(entity);
                return ActionResult.success((String)MsgCode.IMP001.get());
            }
        }
        catch (Exception e) {
            throw new DataException(MsgCode.IMP004.get());
        }
        return ActionResult.fail((String)MsgCode.IMP003.get());
    }
}

