package com.bringspring.system.base.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;

/**
 * 单据规则
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月27日 上午9:18
 */
@Data
@TableName("BASE_BILL_RULE")
public class BillRuleEntity {
    /**
     * 单据主键
     */
    @TableId("ID")
    private String id;

    /**
     * 单据名称
     */
    @TableField("FULL_NAME")
    private String fullName;

    /**
     * 单据编码
     */
    @TableField("ENCODE")
    private String enCode;

    /**
     * 单据前缀
     */
    @TableField("PREFIX")
    private String prefix;

    /**
     * 日期格式
     */
    @TableField("DATE_FORMAT")
    private String dateFormat;

    /**
     * 流水位数
     */
    @TableField("DIGIT")
    private Integer digit;

    /**
     * 流水起始
     */
    @TableField("START_NUMBER")
    private String startNumber;

    /**
     * 流水范例
     */
    @TableField("EXAMPLE")
    private String example;

    /**
     * 当前流水号
     */
    @TableField("THIS_NUMBER")
    private Integer thisNumber;

    /**
     * 输出流水号
     */
    @TableField("OUTPUT_NUMBER")
    private String outputNumber;

    /**
     * 描述
     */
    @TableField("DESCRIPTION")
    private String description;

    /**
     * 排序码
     */
    @TableField("SORT_CODE")
    private Long sortCode;

    /**
     * 有效标志
     */
    @TableField("ENABLED_MARK")
    private Integer enabledMark;

    /**
     * 创建时间
     */
    @TableField(value = "CREATOR_TIME",fill = FieldFill.INSERT)
    private Date creatorTime;

    /**
     * 创建用户
     */
    @TableField(value = "CREATOR_USER_ID",fill = FieldFill.INSERT)
    private String creatorUserId;

    /**
     * 修改时间
     */
    @TableField(value = "LAST_MODIFY_TIME",fill = FieldFill.UPDATE)
    private Date lastModifyTime;

    /**
     * 修改用户
     */
    @TableField(value = "LAST_MODIFY_USER_ID",fill = FieldFill.UPDATE)
    private String lastModifyUserId;

    /**
     * 删除时间
     */
    @TableField("DELETE_TIME")
    private Date deleteTime;

    /**
     * 删除用户
     */
    @TableField("DELETE_USER_ID")
    private String deleteUserId;

    /**
     * 删除标志
     */
    @TableField("DELETE_MARK")
    private Integer deleteMark;
}
