package com.bringspring.system.base.model.systemconfig;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 系统基础配置信息
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2022年3月7日08:58:52
 */
@Data
public class SystemInfo {
    /**
     * 系统名称
     */
    public String sysName;

    /**
     * 系统版本
     */
    public String sysVersion;

    /**
     * 版权信息
     */
    public String copyright;

    /**
     * 公司名称
     */
    public String companyName;
    /**
     * 公司简称
     */
    private String companyCode;
    /**
     * 公司地址
     */
    private String companyAddress;
    /**
     * 公司法人
     */
    private String companyContacts;
    /**
     * 公司联系电话
     */
    private String companyTelePhone;
    /**
     * 公司联系邮箱
     */
    private String companyEmail;
    /**
     * 电脑端地址
     */
    private String sysComputerUrl;
    /**
     * 移动端地址
     */
    private String sysMobileUrl;
    /**
     * 登录图标
     */
    public String loginIcon;

    /**
     * 导航图标
     */
    public String navigationIcon;

    /**
     * logo图标
     */
    public String logoIcon;

    /**
     * App图标
     */
    public String appIcon;
}
