package com.bringspring.system.base.service.impl;


import com.bringspring.common.base.Page;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.*;
import com.bringspring.system.base.service.UserOnlineService;
import com.bringspring.system.base.util.RemoveUtil;
import com.bringspring.system.message.model.UserOnlineModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

import static com.bringspring.common.constant.CacheConsts.LOGIN_CACHE;

/**
 * 在线用户
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月26日 上午9:18
 */
@Service
public class UserOnlineServiceImpl implements UserOnlineService {

    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private CacheKeyUtil cacheKeyUtil;
    @Autowired
    private CacheUtil cacheUtil;

    @Override
    public List<UserOnlineModel> getList(Page page) {
        List<UserOnlineModel> userOnlineList = new ArrayList<>();
        String onlineUserKey = cacheKeyUtil.getLoginOnline();
        Set<String> cacheKeys = cacheUtil.getAllKeys(LOGIN_CACHE);
        for (String cacheKey : cacheKeys) {
            if (cacheKey.length() > onlineUserKey.length() && cacheKey.substring(0, onlineUserKey.length()).equals(onlineUserKey)) {
               if(cacheKey.contains(onlineUserKey)) {
                   String onlineToken = String.valueOf(cacheUtil.query(LOGIN_CACHE, cacheKey));
                   Object onlineVal = cacheUtil.query(LOGIN_CACHE, onlineToken);
                   UserInfo userInfo = null;
                   if (onlineVal instanceof String) {
                       userInfo = JsonUtil.getJsonToBean(String.valueOf(onlineVal), UserInfo.class);
                   } else {
                       userInfo = (UserInfo) onlineVal;
                   }
                   if (userInfo != null) {
                       UserOnlineModel userOnlineModel = new UserOnlineModel();
                       userOnlineModel.setUserId(userInfo.getUserId());
                       userOnlineModel.setUserAccount(userInfo.getUserAccount());
                       userOnlineModel.setUserName((userInfo.getRealName()) + "/" + userInfo.getUserAccount());
                       userOnlineModel.setLoginIPAddress(userInfo.getLoginIpAddress());
                       userOnlineModel.setLoginTime(userInfo.getLoginTime());
                       userOnlineModel.setLoginPlatForm(userInfo.getLoginPlatForm());
                       userOnlineModel.setTenantId(userInfo.getTenantId());
                       userOnlineModel.setToken(onlineToken);
                       userOnlineList.add(userOnlineModel);
                   }
               }
            }
        }
        String tenantId =userProvider.get().getTenantId();
        userOnlineList = userOnlineList.stream().filter(t -> String.valueOf(t.getTenantId()).equals(String.valueOf(tenantId))).collect(Collectors.toList());
        if(!StringUtils.isEmpty(page.getKeyword())){
            userOnlineList=userOnlineList.stream().filter(t->t.getUserName().contains(page.getKeyword())).collect(Collectors.toList());
        }
        userOnlineList.sort(Comparator.comparing(UserOnlineModel::getLoginTime).reversed());
        return userOnlineList;
    }

    @Override
    public void delete(String id) {
        userProvider.removeOnLine(id);
        RemoveUtil.removeOnline(id);
    }
}
