package com.bringspring.system.msgcenter.enums;

/**
 * 消息中心提示信息
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/12/20
 */
public enum MsgCenterCode {
    // 成功类（SU前缀）
    SEND_SUCCESS("SU001", "发送成功"),
    RESEND_SUCCESS("SU002", "重发成功"),

    // 失败类（FA前缀）
    SEND_FAILURE("FA001", "发送失败"),
    RESEND_FAILURE("FA002", "重发失败"),
    BLACKLIST_USER("FA003", "黑名单用户"),
    RECEIVER_ID_EMPTY("FA004", "接收者ID为空"),
    THIRD_PARTY_INFO_MISSING("FA005", "第三方信息缺失"),
    THIRD_PARTY_ID_EMPTY("FA006", "第三方对象ID为空");

    private final String code;
    private final String desc;

    MsgCenterCode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    // Getter方法
    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
