package com.bringspring.system.msgcenter.exception;

import com.bringspring.system.msgcenter.entity.McTaskMsgReceiveEntity;
import lombok.Getter;

import java.util.List;

@Getter
public class SendMessageException extends RuntimeException {
    private final int errorCode;
    private final String errorMessage;
    private final transient List<McTaskMsgReceiveEntity> receiveList;

    public SendMessageException(int errorCode, String errorMessage) {
        this(errorCode, errorMessage, null); // 调用三参构造函数
    }

    public SendMessageException(int errorCode, String errorMessage, List<McTaskMsgReceiveEntity> receiveList) {
        super(String.format("消息发送失败 [Code=%d]: %s", errorCode, errorMessage));
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        this.receiveList = receiveList;
    }

}
